/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.impl.AbstractIndividualVirtualizerFactory;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwapFileVirtualizerFactory
extends AbstractIndividualVirtualizerFactory {
    private static final Log log = LogFactory.getLog(SwapFileVirtualizerFactory.class);
    public static final int DEFAULT_MAX_SIZE = 200;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    public static final int DEFAULT_MIN_BLOCK_GROW_COUNT = 100;
    private int maxSize = 200;
    private String tempDirectory = System.getProperty("java.io.tmpdir");
    private int blockSize = 100;
    private int minBlockGrowCount = 100;

    public JRVirtualizer getVirtualizer() {
        JRSwapFile swapFile = this.getSwapFile();
        JRSwapFileVirtualizer virtualizer = new JRSwapFileVirtualizer(this.maxSize, swapFile);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created swap file virtualizer " + virtualizer));
        }
        return virtualizer;
    }

    protected JRSwapFile getSwapFile() {
        JRSwapFile swapFile = new JRSwapFile(this.tempDirectory, this.blockSize, this.minBlockGrowCount);
        return swapFile;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public int getMinBlockGrowCount() {
        return this.minBlockGrowCount;
    }

    public void setMinBlockGrowCount(int minBlockGrowCount) {
        this.minBlockGrowCount = minBlockGrowCount;
    }
}

