/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.RepoLogEvent;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.user.UserPersistenceHandler;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class HibernateLoggingService
extends HibernateDaoSupport
implements LoggingService {
    private static final Log log = LogFactory.getLog(HibernateLoggingService.class);
    private static final long EVENT_ID_NEW = 0L;
    private SecurityContextProvider securityContextProvider;
    private int maximumAge;
    private ResourceFactory objectFactory;
    private UserPersistenceHandler userHandler;

    public void setUserHandler(UserPersistenceHandler userHandler) {
        this.userHandler = userHandler;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public int getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumAge(int days) {
        this.maximumAge = days;
    }

    public LogEvent instantiateLogEvent() {
        return this.createLogEvent();
    }

    protected LogEvent createLogEvent() {
        return new RepoLogEvent();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false)
    public void log(LogEvent event) {
        this.prepareForSave(event);
        this.getHibernateTemplate().save((Object)event);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void update(LogEvent event) {
        RepoLogEvent repoLogEvent = this.getRepoLogEvent(event.getId());
        repoLogEvent.copyFromClient(event);
        this.getHibernateTemplate().saveOrUpdate((Object)repoLogEvent);
    }

    protected void prepareForSave(LogEvent event) {
        event.setId(0L);
        if (event.getOccurrenceDate() == null) {
            event.setOccurrenceDate(new Date());
        }
        RepoLogEvent repoLogEvent = (RepoLogEvent)event;
        RepoUser persistentUser = this.userHandler.getPersistentUserFromContext();
        repoLogEvent.setUser((User)persistentUser);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false)
    public void purge() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -this.getMaximumAge());
        Date last = cal.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purging log events older than " + last));
        }
        this.getHibernateTemplate().bulkUpdate("delete RepoLogEvent e where e.occurrenceDate < ?", (Object)last);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void delete(ExecutionContext context, long[] eventIds) {
        for (long eventId : eventIds) {
            RepoLogEvent event = this.getRepoLogEvent(eventId);
            this.getHibernateTemplate().delete((Object)event);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List getUserEvents(ExecutionContext context) {
        List events;
        RepoUser user = this.userHandler.getPersistentUserFromContext();
        if (user != null) {
            DetachedCriteria criteria = DetachedCriteria.forClass(RepoLogEvent.class);
            criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
            criteria.addOrder(Order.desc((String)"occurrenceDate"));
            events = this.getHibernateTemplate().findByCriteria(criteria);
        } else {
            events = Collections.emptyList();
        }
        return this.getClientEvents(events);
    }

    private List<LogEvent> getClientEvents(List<RepoLogEvent> repoEvents) {
        ArrayList<LogEvent> events = new ArrayList<LogEvent>();
        for (RepoLogEvent repoEvent : repoEvents) {
            events.add(repoEvent.toClient(this.objectFactory));
        }
        return events;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<LogEvent> getUnreadEvents(ExecutionContext context) {
        List events;
        RepoUser user = this.userHandler.getPersistentUserFromContext();
        if (user != null) {
            DetachedCriteria criteria = DetachedCriteria.forClass(RepoLogEvent.class);
            criteria.add((Criterion)Restrictions.eq((String)"state", (Object)1));
            criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
            criteria.addOrder(Order.desc((String)"occurrenceDate"));
            events = this.getHibernateTemplate().findByCriteria(criteria);
        } else {
            events = Collections.emptyList();
        }
        return this.getClientEvents(events);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public LogEvent getLogEvent(ExecutionContext context, long id) {
        return this.getRepoLogEvent(id).toClient(this.objectFactory);
    }

    protected RepoLogEvent getRepoLogEvent(long id) {
        RepoLogEvent event = (RepoLogEvent)this.getHibernateTemplate().get(RepoLogEvent.class, (Serializable)Long.valueOf(id));
        if (event == null) {
            log.debug((Object)("Log event with id " + id + " not found"));
        } else {
            User user = this.securityContextProvider.getContextUser();
            if (event.getUser() == null) {
                log.debug((Object)("Log event with id " + id + " has no user."));
            } else {
                User eventUser = (User)((RepoUser)event.getUser()).toClient(this.objectFactory);
                if (!(user.getTenantId() != null || eventUser.getUsername().equals(user.getUsername()) && eventUser.getTenantId() == null)) {
                    log.debug((Object)("Log event with id " + id + " does not belongs to user [username=\"" + user.getUsername() + "\", tenantId=\"" + user.getTenantId() + "\"."));
                    event = null;
                }
            }
        }
        return event;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int getUserEventsCount(ExecutionContext context) {
        String username = this.securityContextProvider.getContextUsername();
        List result = this.getHibernateTemplate().find("select count(*) from RepoLogEvent where state=?", (Object)new Byte(1));
        if (result != null) {
            return (Integer)result.get(0);
        }
        return 0;
    }
}

