/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class BeanDefinitionOverrider
implements BeanFactoryPostProcessor,
Ordered {
    private static final Log log = LogFactory.getLog(BeanDefinitionOverrider.class);
    private int order;
    private String originalBeanName;
    private String overridingBeanName;
    private boolean mergeProperties = true;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.overrideDefinition(beanFactory);
    }

    protected void overrideDefinition(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition originalBean = beanFactory.getBeanDefinition(this.originalBeanName);
        BeanDefinition overridingBean = beanFactory.getBeanDefinition(this.overridingBeanName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Overriding " + this.originalBeanName + " bean definition with " + this.overridingBeanName));
        }
        if (!originalBean.getBeanClassName().equals(overridingBean.getBeanClassName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting " + this.originalBeanName + " class name to " + " to " + overridingBean.getBeanClassName()));
            }
            originalBean.setBeanClassName(overridingBean.getBeanClassName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding " + this.overridingBeanName + " properties to " + this.originalBeanName));
        }
        MutablePropertyValues originalProps = originalBean.getPropertyValues();
        MutablePropertyValues overridingProps = overridingBean.getPropertyValues();
        if (!this.mergeProperties) {
            originalProps.getPropertyValueList().clear();
        }
        originalProps.addPropertyValues((PropertyValues)overridingProps);
    }

    public String getOriginalBeanName() {
        return this.originalBeanName;
    }

    public void setOriginalBeanName(String originalBeanName) {
        this.originalBeanName = originalBeanName;
    }

    public String getOverridingBeanName() {
        return this.overridingBeanName;
    }

    public void setOverridingBeanName(String overridingBeanName) {
        this.overridingBeanName = overridingBeanName;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isMergeProperties() {
        return this.mergeProperties;
    }

    public void setMergeProperties(boolean mergeProperties) {
        this.mergeProperties = mergeProperties;
    }
}

