/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.teiid.adminapi.Admin;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class DDLStringVisitor {
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    private static final HashSet<String> LENGTH_DATATYPES = new HashSet<String>(Arrays.asList("char", "clob", "blob", "object", "xml", "string", "varbinary", "biginteger"));
    private static final HashSet<String> PRECISION_DATATYPES = new HashSet<String>(Arrays.asList("bigdecimal"));
    protected StringBuilder buffer = new StringBuilder();
    private boolean includeTables = true;
    private boolean includeProcedures = true;
    private boolean includeFunctions = true;
    private Pattern filter;
    private Map<String, String> prefixMap;
    private static final Map<String, String> BUILTIN_PREFIXES = new HashMap<String, String>();

    public static String getDDLString(Schema schema, EnumSet<Admin.SchemaObjectType> types, String regexPattern) {
        DDLStringVisitor visitor = new DDLStringVisitor(types, regexPattern);
        visitor.visit(schema);
        return visitor.toString();
    }

    public DDLStringVisitor(EnumSet<Admin.SchemaObjectType> types, String regexPattern) {
        if (types != null) {
            this.includeTables = types.contains(Admin.SchemaObjectType.TABLES);
            this.includeProcedures = types.contains(Admin.SchemaObjectType.PROCEDURES);
            this.includeFunctions = types.contains(Admin.SchemaObjectType.FUNCTIONS);
        }
        if (regexPattern != null) {
            this.filter = Pattern.compile(regexPattern);
        }
    }

    private void visit(Schema schema) {
        boolean first = true;
        if (this.includeTables) {
            for (Table t : schema.getTables().values()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(NEWLINE);
                    this.buffer.append(NEWLINE);
                }
                this.visit(t);
            }
        }
        if (this.includeProcedures) {
            for (Procedure p : schema.getProcedures().values()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(NEWLINE);
                    this.buffer.append(NEWLINE);
                }
                this.visit(p);
            }
        }
        if (this.includeFunctions) {
            for (FunctionMethod f : schema.getFunctions().values()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(NEWLINE);
                    this.buffer.append(NEWLINE);
                }
                this.visit(f);
            }
        }
    }

    private void visit(Table table) {
        String options;
        if (this.filter != null && !this.filter.matcher(table.getName()).matches()) {
            return;
        }
        this.buffer.append("CREATE").append(" ");
        if (table.isPhysical()) {
            this.buffer.append("FOREIGN TABLE");
        } else {
            this.buffer.append("VIEW");
        }
        this.buffer.append(" ");
        String name = SQLStringVisitor.escapeSinglePart(table.getName());
        this.buffer.append(name);
        if (table.getColumns() != null) {
            this.buffer.append(" ");
            this.buffer.append("(");
            boolean first = true;
            for (Column c : table.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(",");
                }
                this.visit(c);
            }
            this.buildContraints(table);
            this.buffer.append(NEWLINE);
            this.buffer.append(")");
        }
        if (!(options = this.buildTableOptions(table)).isEmpty()) {
            this.buffer.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        if (table.isVirtual()) {
            this.buffer.append(NEWLINE).append("AS").append(NEWLINE).append(table.getSelectTransformation());
        }
        this.buffer.append(";");
        if (table.isInsertPlanEnabled()) {
            this.buildTrigger(name, "INSERT", table.getInsertPlan());
        }
        if (table.isUpdatePlanEnabled()) {
            this.buildTrigger(name, "UPDATE", table.getUpdatePlan());
        }
        if (table.isDeletePlanEnabled()) {
            this.buildTrigger(name, "DELETE", table.getDeletePlan());
        }
    }

    private void buildTrigger(String name, String type, String plan) {
        this.buffer.append(NEWLINE);
        this.buffer.append(NEWLINE);
        this.buffer.append("CREATE TRIGGER ON").append(" ");
        this.buffer.append(name).append(" ").append("INSTEAD OF").append(" ").append(type).append(" ").append("AS").append(NEWLINE);
        this.buffer.append(plan);
        this.buffer.append(";");
    }

    private String buildTableOptions(Table table) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)table);
        if (table.isMaterialized()) {
            this.addOption(options, "MATERIALIZED", table.isMaterialized());
            if (table.getMaterializedTable() != null) {
                this.addOption(options, "MATERIALIZED_TABLE", table.getMaterializedTable().getName());
            }
        }
        if (table.supportsUpdate()) {
            this.addOption(options, "UPDATABLE", table.supportsUpdate());
        }
        if (table.getCardinality() != -1) {
            this.addOption(options, "CARDINALITY", table.getCardinality());
        }
        if (!table.getProperties().isEmpty()) {
            for (String key : table.getProperties().keySet()) {
                this.addOption(options, key, table.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void addCommonOptions(StringBuilder sb, AbstractMetadataRecord record) {
        if (record.getUUID() != null && !record.getUUID().startsWith("tid:")) {
            this.addOption(sb, "UUID", record.getUUID());
        }
        if (record.getAnnotation() != null) {
            this.addOption(sb, "ANNOTATION", record.getAnnotation());
        }
        if (record.getNameInSource() != null && !record.getNameInSource().equals(record.getName())) {
            this.addOption(sb, "NAMEINSOURCE", record.getNameInSource());
        }
    }

    private void buildContraints(Table table) {
        this.addConstraints(table.getAccessPatterns(), "AP", "ACCESSPATTERN");
        KeyRecord pk = table.getPrimaryKey();
        if (pk != null) {
            this.addConstraint("PK", "PRIMARY KEY", pk, true);
        }
        this.addConstraints(table.getUniqueKeys(), "UNIQUE", "UNIQUE");
        this.addConstraints(table.getIndexes(), "INDEX", "INDEX");
        this.addConstraints(table.getFunctionBasedIndexes(), "INDEX", "INDEX");
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKey key = (ForeignKey)table.getForeignKeys().get(i);
            this.addConstraint("FK" + i, "FOREIGN KEY", (KeyRecord)key, false);
            this.buffer.append(" ").append("REFERENCES");
            if (key.getReferenceTableName() != null) {
                this.buffer.append(" ").append(new GroupSymbol(key.getReferenceTableName()).getName());
            }
            this.buffer.append(" ");
            this.addNames(this.buffer, key.getReferenceColumns());
            this.appendOptions((AbstractMetadataRecord)key);
        }
    }

    private void addConstraints(List<KeyRecord> constraints, String defaultName, String type) {
        for (int i = 0; i < constraints.size(); ++i) {
            KeyRecord constraint = constraints.get(i);
            this.addConstraint(defaultName + i, type, constraint, true);
        }
    }

    private void addConstraint(String defaultName, String type, KeyRecord constraint, boolean addOptions) {
        this.buffer.append(",").append(NEWLINE).append(TAB);
        boolean nameMatches = defaultName.equals(constraint.getName());
        if (!nameMatches) {
            this.buffer.append("CONSTRAINT").append(" ").append(SQLStringVisitor.escapeSinglePart(constraint.getName())).append(" ");
        }
        this.buffer.append(type);
        this.addColumns(this.buffer, constraint.getColumns(), false);
        if (addOptions) {
            this.appendOptions((AbstractMetadataRecord)constraint);
        }
    }

    private void addColumns(StringBuilder builder, List<Column> columns, boolean includeType) {
        builder.append("(");
        boolean first = true;
        for (Column c : columns) {
            if (first) {
                first = false;
            } else {
                builder.append(",").append(" ");
            }
            if (includeType) {
                this.appendColumn(builder, (BaseColumn)c, true, includeType);
                this.appendColumnOptions(builder, (BaseColumn)c);
                continue;
            }
            if (c.getParent() instanceof KeyRecord) {
                builder.append(c.getNameInSource());
                continue;
            }
            builder.append(SQLStringVisitor.escapeSinglePart(c.getName()));
        }
        builder.append(")");
    }

    private void addNames(StringBuilder builder, List<String> columns) {
        if (columns != null) {
            builder.append("(");
            boolean first = true;
            for (String c : columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",").append(" ");
                }
                builder.append(SQLStringVisitor.escapeSinglePart(c));
            }
            builder.append(")");
        }
    }

    private void visit(Column column) {
        this.buffer.append(NEWLINE).append(TAB);
        this.appendColumn(this.buffer, (BaseColumn)column, true, true);
        if (column.isAutoIncremented()) {
            this.buffer.append(" ").append("AUTO_INCREMENT");
        }
        this.appendDefault((BaseColumn)column);
        this.appendColumnOptions(this.buffer, (BaseColumn)column);
    }

    private void appendDefault(BaseColumn column) {
        if (column.getDefaultValue() != null) {
            this.buffer.append(" ").append("DEFAULT").append(" ").append("'").append(StringUtil.replaceAll((String)column.getDefaultValue(), (String)"'", (String)"''")).append("'");
        }
    }

    private void appendColumn(StringBuilder builder, BaseColumn column, boolean includeName, boolean includeType) {
        if (includeName) {
            builder.append(SQLStringVisitor.escapeSinglePart(column.getName()));
        }
        if (includeType) {
            String runtimeTypeName = column.getDatatype().getRuntimeTypeName();
            if (includeName) {
                builder.append(" ");
            }
            builder.append(runtimeTypeName);
            if (LENGTH_DATATYPES.contains(runtimeTypeName)) {
                if (column.getLength() != 0 && column.getLength() != column.getDatatype().getLength()) {
                    builder.append("(").append(column.getLength()).append(")");
                }
            } else if (PRECISION_DATATYPES.contains(runtimeTypeName) && (column.getPrecision() != column.getDatatype().getPrecision() || column.getScale() != column.getDatatype().getScale())) {
                builder.append("(").append(column.getPrecision());
                if (column.getScale() != 0) {
                    builder.append(",").append(column.getScale());
                }
                builder.append(")");
            }
            if (column.getNullType() == BaseColumn.NullType.No_Nulls) {
                builder.append(" ").append("NOT NULL");
            }
        }
    }

    private void appendColumnOptions(StringBuilder builder, BaseColumn column) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)column);
        if (!column.getDatatype().isBuiltin()) {
            this.addOption(options, "UDT", column.getDatatype().getName() + "(" + column.getLength() + ", " + column.getPrecision() + ", " + column.getScale() + ")");
        }
        if (column.getDatatype().getRadix() != 0 && column.getRadix() != column.getDatatype().getRadix()) {
            this.addOption(options, "RADIX", column.getRadix());
        }
        if (column instanceof Column) {
            this.buildColumnOptions((Column)column, options);
        }
        if (options.length() != 0) {
            builder.append(" ").append("OPTIONS").append(" ").append("(").append((CharSequence)options).append(")");
        }
    }

    private void buildColumnOptions(Column column, StringBuilder options) {
        if (!column.isSelectable()) {
            this.addOption(options, "SELECTABLE", column.isSelectable());
        }
        if (!column.isUpdatable() && column.getParent() instanceof Table && ((Table)column.getParent()).supportsUpdate()) {
            this.addOption(options, "UPDATABLE", column.isUpdatable());
        }
        if (column.isCurrency()) {
            this.addOption(options, "CURRENCY", column.isCurrency());
        }
        if (!column.isCaseSensitive() && column.getDatatype().isCaseSensitive()) {
            this.addOption(options, "CASE_SENSITIVE", column.isCaseSensitive());
        }
        if (!column.isSigned() && column.getDatatype().isSigned()) {
            this.addOption(options, "SIGNED", column.isSigned());
        }
        if (column.isFixedLength()) {
            this.addOption(options, "FIXED_LENGTH", column.isFixedLength());
        }
        if (column.getCharOctetLength() != 0 && column.getLength() != column.getCharOctetLength()) {
            this.addOption(options, "CHAR_OCTET_LENGTH", column.getCharOctetLength());
        }
        if (column.getSearchType() != null && (!column.getSearchType().equals((Object)column.getDatatype().getSearchType()) || column.isSearchTypeSet())) {
            this.addOption(options, "SEARCHABLE", column.getSearchType().name());
        }
        if (column.getMinimumValue() != null) {
            this.addOption(options, "MIN_VALUE", column.getMinimumValue());
        }
        if (column.getMaximumValue() != null) {
            this.addOption(options, "MAX_VALUE", column.getMaximumValue());
        }
        if (column.getNativeType() != null) {
            this.addOption(options, "NATIVE_TYPE", column.getNativeType());
        }
        if (column.getNullValues() != -1) {
            this.addOption(options, "NULL_VALUE_COUNT", column.getNullValues());
        }
        if (column.getDistinctValues() != -1) {
            this.addOption(options, "DISTINCT_VALUES", column.getDistinctValues());
        }
        this.buildOptions((AbstractMetadataRecord)column, options);
    }

    private void appendOptions(AbstractMetadataRecord record) {
        StringBuilder options = new StringBuilder();
        this.buildOptions(record, options);
        if (options.length() != 0) {
            this.buffer.append(" ").append("OPTIONS").append(" ").append("(").append((CharSequence)options).append(")");
        }
    }

    private void buildOptions(AbstractMetadataRecord record, StringBuilder options) {
        if (!record.getProperties().isEmpty()) {
            for (Map.Entry entry : record.getProperties().entrySet()) {
                this.addOption(options, (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addOption(StringBuilder sb, String key, Object value) {
        int index;
        if (sb.length() != 0) {
            sb.append(",").append(" ");
        }
        value = value != null ? new Constant(value) : Constant.NULL_CONSTANT;
        if (key != null && key.length() > 2 && key.charAt(0) == '{' && (index = key.indexOf(125)) > 1) {
            String uri = key.substring(1, index);
            key = key.substring(index + 1, key.length());
            String prefix = BUILTIN_PREFIXES.get(uri);
            if (prefix == null) {
                if (this.prefixMap == null) {
                    this.prefixMap = new LinkedHashMap<String, String>();
                } else {
                    prefix = this.prefixMap.get(uri);
                }
                if (prefix == null) {
                    prefix = "n" + this.prefixMap.size();
                    this.prefixMap.put(uri, prefix);
                }
            }
            key = prefix + ":" + key;
        }
        sb.append(SQLStringVisitor.escapeSinglePart(key)).append(" ").append(value);
    }

    private void visit(Procedure procedure) {
        String options;
        if (this.filter != null && !this.filter.matcher(procedure.getName()).matches()) {
            return;
        }
        this.buffer.append("CREATE").append(" ");
        if (procedure.isVirtual()) {
            this.buffer.append("VIRTUAL");
        } else {
            this.buffer.append("FOREIGN");
        }
        this.buffer.append(" ").append("PROCEDURE").append(" ").append(SQLStringVisitor.escapeSinglePart(procedure.getName()));
        this.buffer.append("(");
        boolean first = true;
        for (ProcedureParameter pp : procedure.getParameters()) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(",").append(" ");
            }
            this.visit(pp);
        }
        this.buffer.append(")");
        if (procedure.getResultSet() != null) {
            this.buffer.append(" ").append("RETURNS").append(" ").append("TABLE").append(" ");
            this.addColumns(this.buffer, procedure.getResultSet().getColumns(), true);
        }
        if (!(options = this.buildProcedureOptions(procedure)).isEmpty()) {
            this.buffer.append(NEWLINE).append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        if (procedure.isVirtual()) {
            this.buffer.append(NEWLINE).append("AS").append(NEWLINE);
            String plan = procedure.getQueryPlan();
            this.buffer.append(plan);
        }
    }

    private String buildProcedureOptions(Procedure procedure) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)procedure);
        if (procedure.getUpdateCount() != 1) {
            this.addOption(options, "UPDATECOUNT", procedure.getUpdateCount());
        }
        if (!procedure.getProperties().isEmpty()) {
            for (String key : procedure.getProperties().keySet()) {
                this.addOption(options, key, procedure.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void visit(ProcedureParameter param) {
        ProcedureParameter.Type type = param.getType();
        String typeStr = null;
        switch (type) {
            case InOut: {
                typeStr = "INOUT";
                break;
            }
            case ReturnValue: 
            case Out: {
                typeStr = "OUT";
                break;
            }
            case In: {
                typeStr = param.isVarArg() ? "VARIADIC" : "IN";
            }
        }
        this.buffer.append(typeStr).append(" ");
        this.appendColumn(this.buffer, (BaseColumn)param, true, true);
        if (type == ProcedureParameter.Type.ReturnValue) {
            this.buffer.append(" ").append("RESULT");
        }
        this.appendDefault((BaseColumn)param);
        this.appendColumnOptions(this.buffer, (BaseColumn)param);
    }

    private void visit(FunctionMethod function) {
        if (this.filter != null && !this.filter.matcher(function.getName()).matches()) {
            return;
        }
        this.buffer.append("CREATE").append(" ");
        if (function.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN)) {
            this.buffer.append("FOREIGN");
        } else {
            this.buffer.append("VIRTUAL");
        }
        this.buffer.append(" ").append("FUNCTION").append(" ").append(SQLStringVisitor.escapeSinglePart(function.getName()));
        this.buffer.append("(");
        boolean first = true;
        for (FunctionParameter fp : function.getInputParameters()) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(",").append(" ");
            }
            this.visit(fp);
        }
        this.buffer.append(")");
        this.buffer.append(" ").append("RETURNS").append(" ");
        this.buffer.append(function.getOutputParameter().getType());
        String options = this.buildFunctionOptions(function);
        if (!options.isEmpty()) {
            this.buffer.append(NEWLINE).append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        this.buffer.append(";");
    }

    private String buildFunctionOptions(FunctionMethod function) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)function);
        if (function.getCategory() != null) {
            this.addOption(options, "CATEGORY", function.getCategory());
        }
        if (!function.getDeterminism().equals((Object)FunctionMethod.Determinism.DETERMINISTIC)) {
            this.addOption(options, "DETERMINISM", function.getDeterminism().name());
        }
        if (function.getInvocationClass() != null) {
            this.addOption(options, "JAVA_CLASS", function.getInvocationClass());
        }
        if (function.getInvocationMethod() != null) {
            this.addOption(options, "JAVA_METHOD", function.getInvocationMethod());
        }
        if (!function.getProperties().isEmpty()) {
            for (String key : function.getProperties().keySet()) {
                this.addOption(options, key, function.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void visit(FunctionParameter param) {
        if (param.isVarArg()) {
            this.buffer.append("VARIADIC").append(" ");
        }
        this.buffer.append(SQLStringVisitor.escapeSinglePart(param.getName())).append(" ").append(param.getType());
    }

    public String toString() {
        if (this.prefixMap != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.prefixMap.entrySet()) {
                sb.append("SET NAMESPACE '").append(StringUtil.replaceAll((String)entry.getKey(), (String)"'", (String)"''")).append('\'').append(" AS ").append(SQLStringVisitor.escapeSinglePart(entry.getValue())).append(";\n");
            }
            return sb.append(NEWLINE).toString() + this.buffer.toString();
        }
        return this.buffer.toString();
    }

    static {
        for (Map.Entry entry : MetadataFactory.BUILTIN_NAMESPACES.entrySet()) {
            BUILTIN_PREFIXES.put((String)entry.getValue(), (String)entry.getKey());
        }
    }
}

