/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2.repository;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;

/**
 * @author gtoffoli
 * @version $Id: UnknownResourceHandler.java 9304 2007-08-02 16:59:49Z lucian $
 */
public class UnknownResourceHandler extends RepositoryResourceHandler {

	private final static Log log = LogFactory.getLog(UnknownResourceHandler.class); 

	public Class getResourceType() {
		return Resource.class;
	}
	
	protected void doDescribe(Resource resource, ResourceDescriptor descriptor,
			Map arguments, RepositoryServiceContext serviceContext) {
		descriptor.setWsType(ResourceDescriptor.TYPE_UNKNOW);
		
		log.warn("Unknow resource type: "
				+ resource.getResourceType() + " instanceof "
				+ resource.getClass().getName());
	}


	protected void updateResource(Resource resource,
			ResourceDescriptor descriptor, RepositoryServiceContext newParam) {
		// nothing
	}

}
