var UserUtil = {};

UserUtil.clone = function (user) {

    var userClone = {

        userName : user.userName,
        fullName : user.fullName,
        email : user.email,
        enabled : user.enabled,
        external : user.external,
        roles : [],
        attributes : []
    };

    if (user.password != null && user.password != undefined) {
        userClone.password = user.password;
    }

    if (user.tenantId) {
        userClone.tenantId = user.tenantId;
    }

    if (user.roles) {
        user.roles.each(function (role) {
            var roleClone = RoleUtil.clone(role)

            userClone.roles.push(roleClone);
        });
    }

    if (user.attributes) {
        user.attributes.each(function (attribute) {

            userClone.attributes.push({name: attribute.name, value: attribute.value});
        });
    }

    return userClone;
}

UserUtil.getUserNameWithoutTenant = function (userName) {

    if (!userName) {

        return userName;
    }

    return userName.split(BaseUserAndRoleManager.Configuration.userNameSeparator)[0];
}

UserUtil.getTenantWithoutUserName = function (userName) {
    if (!userName || userName.indexOf(BaseUserAndRoleManager.Configuration.userNameSeparator) < 0) {

        return null;
    }

    return userName.split(BaseUserAndRoleManager.Configuration.userNameSeparator)[1];
}

UserUtil.getUserNameWithTenant = function (userName, tenantId) {

    if (tenantId && !tenantId.blank()) {

        return userName + BaseUserAndRoleManager.Configuration.userNameSeparator + tenantId;
    } else {

        return userName;
    }
}

UserUtil.getExternalRoles = function (user) {

    if (user && user.roles) {

        var externalRoles = [];

        user.roles.each(function (role) {

            if (role.external) {

                externalRoles.push(role);
            }
        });

        return externalRoles;
    }

    return [];
}

UserUtil.getAssignedRoles = function (user) {

    if (user && user.roles) {

        var assignedRoles = [];

        user.roles.each(function (role) {

            if (!role.external) {

                assignedRoles.push(role);
            }
        });

        return assignedRoles;
    }

    return [];
}

UserUtil.equals = function (user1, user2) {

    if ((user1 == undefined && user2 == undefined) || (user1 == null && user2 == null)) {

        return true;
    }

    var isUserNameEquals = (user1.userName == user2.userName);
    var isUserFullName = (user1.fullName == user2.fullName);
    var isPasswordEquals = (user1.password == user2.password);
    var isConfirmPasswordEquals = (user1.password == user2.confirmPassword);
    var isEmailEquals = (user1.email == user2.email);
    var isEnabledEquals = (user1.enabled == user2.enabled);
    var isExternalEquals = (user1.external == user2.external);

    var isRolesEquals = (user1.roles.length == user2.roles.length);

    if (isRolesEquals) {

        user1.roles.each( function (r1) {

            var r2 = RoleUtil.getRoleByName(r1.roleName, user2.roles);

            if (r2 == null || !RoleUtil.equals(r1, r2))  {

                isRolesEquals = false;
                throw $break;
            }
        });
    }

    return isUserNameEquals && isUserFullName && isPasswordEquals && isConfirmPasswordEquals && isEmailEquals
            && isEnabledEquals && isExternalEquals && isRolesEquals;
}

UserUtil.isFakeUser = function (user) {
    var userName = user.userName;

    return (!userName || userName.blank());
}

UserUtil.containsUser = function (users, userName) {

    var contain = false;

    users.each(function (user) {
        if (user.userName == userName) {
            contain = true;
        }
    });

    return contain;
}

UserUtil.attributesToString = function(attributes) {
    var s = '';

    if (attributes) {

        var i = 0;
        attributes.each(function(attribute) {

            s += '[' + attribute.name + ':' + attribute.value + ']';

            if (i < attributes.length - 1) {
                s += ", ";
            }

            i ++;
        });
    }

    return s;
}

var RoleUtil = {};

RoleUtil.clone = function (role) {

    var roleClone = {

        roleName : role.roleName,
        external : role.external
    };

    if (role.tenantId) {
        roleClone.tenantId = role.tenantId;
    }

    return roleClone;
}

RoleUtil.equals = function (role1, role2) {
    if ((role1 == undefined && role2 == undefined) || (role1 == null && role2 == null)) {
        return true;
    }

    return (role1.roleName == role2.roleName) && (role1.external == role2.external);
}

RoleUtil.getRoleByName = function (roleName, roles) {

    var role = null;

    roles.each( function (r) {

        if (r.roleName == roleName) {

            role = r;
            throw $break;
        }
    });

    return role;
}

RoleUtil.isFakeRole = function (role) {
    var roleName = role.roleName;

    return (!roleName || roleName.blank());
}

RoleUtil.getRoleNameWithoutTenant = function (roleName) {

    return roleName.split(BaseUserAndRoleManager.Configuration.userNameSeparator)[0];
}

RoleUtil.getRoleNameWithTenant = function (roleName, tenantId) {

    if (tenantId && !tenantId.blank()) {

        return roleName + BaseUserAndRoleManager.Configuration.userNameSeparator + tenantId;
    } else {

        return roleName;
    }
}
