var RoleCreator = Class.create(ItemCreator, {

    initialize : function ($super, messageSource, dataRetriever) {

        $super('roleCreator', messageSource);

        this.role = {};

        this.filteredRoleName = new FilteredTextBox('roleCreatorRoleNameInput',
                    new RegExp(BaseUserAndRoleManager.Configuration.roleNameNotSupportedSymbols, "g"));

        this.roleName = this.filteredRoleName.getElement();
        this.roleNameValidator = null;

        this._setUpValidation(dataRetriever);
    },

    _setUpValidation : function (dataRetriever) {

        var creatorInstance = this;

        this.roleNameValidator = new ItemExistValidator(
                'roleCreatorRoleNameValidator',
                this.roleName.id,
                'blur',
                this.messageSource.getMessage('roleNameIsAlreadyInUse'),
                this.validationImg,
                dataRetriever);

        this.validationSummary = new ValidationSummary('roleCreatorValidationSummary');
        this.validationSummary.registrValidator(this.roleNameValidator);

        this.validationStack.addValidator(this.roleNameValidator);

        var changesHandler = function (e) {
            this.submintClicked = false;
            creatorInstance.submitBtn.disabled = creatorInstance.isRequiredFieldsEmpty();
        }

        this.roleName.onkeyup = changesHandler;
    },

    isRequiredFieldsEmpty : function () {
        return (this.roleName.value.blank());
    },

    setTenantId : function ($super, tenantId) {

        $super(tenantId);
        this.roleNameValidator.setTenantId(tenantId);
    },

    getItem : function () {

//        var roleName = RoleUtil.getRoleNameWithTenant(this.roleName.value, this.tenantId);
        var roleName = this.roleName.value;

        var role = {
            roleName : roleName
        };

        if (this.tenantId) {

            role.tenantId = this.tenantId;
        }

        return role;
    },

    show : function ($super) {

        this.submintClicked = false;
        
        this.roleName.value = '';

        this.submitBtn.disabled = true;

        this.roleNameValidator.setState(ControlValidator.State.UNKNOWN);

        $super();
    }
});
