/*
    <link href="stylesheets/SearchTextBox.css" rel="stylesheet" type="text/css">
    <script language="JavaScript" src="scripts/prototype.js"></script>
    <script language="JavaScript" src="scripts/SearchTextBox.js"></script>

 */
var SearchTextBox = Class.create({
    initialize: function(id, defaultText) {
        this.id = id;
        this.defaultText = defaultText;

        this.input = null;
        this.clearBtn = null;

        this.container = $(id);
        if (!this.container) {
            throw new Error("SearchTextBox: canot find container with id '" + this.id + "'.");
        }

        this.container.style.overflow = 'hidden';
        this.container.innerHTML = this._getHtml();

        this.input = $(this._getInputId());
        this.img = $(this._getImgId());

        this._setUpInput();
        this._setUpClearButton();

        this.clear();
    },

    getInput: function() {
        return this.input;    
    },

    getValue: function(value) {
        return this.value;
    },

    setValue: function(value) {
        if (value) {
            this.value = value;

            if (this.value.length > 0) {

                this.input.value = this.value;
                this.input.removeClassName(SearchTextBox.DEFAULT_TEXT_STYLE_CLASS);
                this._disableClear(false);
            } else {

                this.input.value = this.defaultText;
                this.input.addClassName(SearchTextBox.DEFAULT_TEXT_STYLE_CLASS);
                this._disableClear(true);
            }
        }
    },

    clear: function() {
        this.value = '';

        this.input.value = this.defaultText;
        this.input.addClassName(SearchTextBox.DEFAULT_TEXT_STYLE_CLASS);

        try {
            $(this._getFocusHolderId()).focus();
        } catch(ex) { }
        
        this._disableClear(true);
    },

    onclear: function() {
        /* Do Nothing*/
    },

    setInputClassName: function(className) {
        if (className) {
            this.inputClassName = className;

            this.input.addClassName(className);
            if (this.value.length > 0) {

                this.input.addClassName(SearchTextBox.DEFAULT_TEXT_STYLE_CLASS);
            }
        }
    },

    setClearImage: function(src) {
        this.img.src = src;
    },

    resize: function() {
        try {
            this.input.style.width = (this.container.clientWidth - 25) + 'px';
        } catch(ex) {}
    },

    _setUpInput: function() {
        var _this = this;

        this.input.observe('focus', function() {

            if (_this.value.length == 0) {
                
                _this.input.value = "";
                _this.input.removeClassName(SearchTextBox.DEFAULT_TEXT_STYLE_CLASS);
                _this._disableClear(false);
            }
        });

        this.input.observe('blur', function() {

            if (_this.value.length == 0) {

                _this.input.value = _this.defaultText;
                _this.input.addClassName(SearchTextBox.DEFAULT_TEXT_STYLE_CLASS);
                _this._disableClear(true);
            }
        });

        this.input.observe('keypress', function(e) {

            cancelEventBubbling(e);
        });
        
        this.input.observe('keyup', function(e) {

            _this.value = _this.input.value;
            cancelEventBubbling(e);
        });
    },

    _setUpClearButton: function() {
        this.img.src = SearchTextBox.CLEAR_IMAGE_SRC;

//        try {
//            this.img.style.height = this.container.height + 'px';
//        } catch(ex) {
//        }
//
        Event.observe(this._getImgId(), 'click', this._getOnClickListener());
    },

    _getOnClickListener: function() {
        var _this = this;

        return function () {

            _this.clear();
            _this.onclear();
        }
    },

    _getHtml: function() {
        var html = SearchTextBox.HTML.replace(new RegExp(SearchTextBox.INPUT), this._getInputId());
        html = html.replace(new RegExp(SearchTextBox.INPUT_CLEAR), this._getImgId());
        html = html.replace(new RegExp(SearchTextBox.INPUT_FOCUS), this._getFocusHolderId());

        return html;
    },

    _getInputId: function() {
        return this.id + SearchTextBox.INPUT;
    },

    _getImgId: function() {
        return this.id + SearchTextBox.INPUT_CLEAR;
    },

    _getFocusHolderId: function() {
        return this.id + SearchTextBox.INPUT_FOCUS;
    },

    _disableClear: function(disabled) {

        this.img.disabled = disabled;
        if (disabled) {

            this.img.src = SearchTextBox.CLEAR_IMAGE_DISABLED_SRC;
            Event.observe(this._getImgId(), 'click', function() {});
        } else {

            this.img.src = SearchTextBox.CLEAR_IMAGE_SRC;
            Event.observe(this._getImgId(), 'click', this._getOnClickListener());
        }
    }

});

SearchTextBox.INPUT = "TextInput";
SearchTextBox.INPUT_CLEAR = "InputClear";
SearchTextBox.INPUT_FOCUS = "InputFocusHolder";
SearchTextBox.CLEAR_IMAGE_SRC = "images/clearValue.gif";
SearchTextBox.CLEAR_IMAGE_DISABLED_SRC = "images/clearValue-dis.gif";
SearchTextBox.DEFAULT_TEXT_STYLE_CLASS = "defaultText";
//SearchTextBox.HTML = '<table class="new_tabletextfieldorlist" style="padding:0px; margin:0px;"><tbody style="padding:0px; margin:0px;"> <tr style="padding:0px; margin:0px;">' +
//                     '<td style="padding:0px; margin:0px;"><input id="TextInput" type="text" size="20" style="border:none; height:18px; padding:0px; margin:0px;" /></td>' +
//                     '<td valign="middle" style="padding:0px; margin:0px;"><input type="image" id="InputClear" src="" style="padding:0px; margin:0px;"/><input id="InputFocusHolder" type="text" style="border-style:hidden; height:0px; width:0px; padding:0px; margin:0px;" /></td>' +
//                     '</tr></tbody></table>';
//SearchTextBox.HTML = '<div class="new_tabletextfieldorlist" style="width:142px"> ' +
//                     '<input id="TextInput" type="text" style="border:none; width:120px; height:18px" />' +
//                     '<input id="InputFocusHolder" type="text" style="border:none; height:0px; width:0px; padding:0px; margin:0px;" />' +
//                     '<span style="vertical-align:middle;"><input id="InputClear" type="image" style="margin-top:2px;" src=""/></span>' +
//                     '</div>';
//SearchTextBox.HTML = '<div class="new_tabletextfieldorlist" style="width:100%; height:100%"> ' +
//                     '<input id="TextInput" type="text" style="border:none; width:91%; padding:0px; margin:0px;" />' +
//                     '<input id="InputFocusHolder" type="text" style="border:none; height:0px; width:0px; padding:0px; margin:0px;" />' +
//                     '<span style="vertical-align:middle; padding:0px; margin:0px;"><img id="InputClear" src="" style="padding:0px; margin:0px;" /></span>' +
//                     '</div>';
SearchTextBox.HTML = '<input id="TextInput" type="text" class="searchInputControl" />' +
                     '<input id="InputFocusHolder" type="text" style="border:none; height:0px; width:0px; padding:0px; margin:0px;" />' +
                     '<img class="clearImg" id="InputClear" src=""/>' +
                     '</div>';

var FilteredTextBox = Class.create({

    initialize: function(id, filterExpression) {

        this.id = id;
        this.filterExpression = filterExpression;

        this.element = $(this.id);
        var input = this.element;

        var filteredTextBoxInstance = this;
        var oldHandler = input.onkeyup;

        input.observe('keyup', function (e) {

            var event = getEvent(e);
            var keynum = whichKeyHit(e);

            input.value = input.value.replace(filterExpression, '');

            if (oldHandler) {

                oldHandler(e);
            }

            filteredTextBoxInstance.onkeyup(e);
        });
    },

    setValue : function(value) {
        this.element.value = value;
    },

    getValue : function() {
        return this.element.value;
    },

    getElement : function() {
        return this.element;
    },

    onkeyup : function(e) { /* Do Nothing*/ }

});