/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.war.xmla;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;

/**
 * @author asokolnikov
 *
 */
public class XMLAUpdateListener {

	private Set registeredListeners = new LinkedHashSet();
	
	private static final Log log = LogFactory.getLog(XMLAUpdateListener.class);
	
	public void registerListener(UpdatableXMLAContainer updatableXMLAContainer) {
		if (updatableXMLAContainer != null) {
			registeredListeners.add(updatableXMLAContainer);
		}
	}
	
	public boolean unregisterListener(UpdatableXMLAContainer updatableXMLAContainer) {
		if (updatableXMLAContainer != null) {
			return registeredListeners.remove(updatableXMLAContainer);
		}
		return false;
	}
	
	public void notifyListeners(MondrianXMLADefinition oldDef, MondrianXMLADefinition newDef) {
		for (Iterator iter = registeredListeners.iterator(); iter.hasNext(); ) {
			UpdatableXMLAContainer updatableXMLAContainer = (UpdatableXMLAContainer) iter.next();
			try {
				updatableXMLAContainer.updateXMLAConnection(oldDef, newDef);
			} catch (Exception ex) {
				log.error("Cannot update XMLA Connection!", ex);
			}
		}
	}
	
}
