/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.war.util;

import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: DefaultHttpUtils.java 9885 2007-09-03 16:39:13Z lucian $
 */
public class DefaultHttpUtils implements HttpUtils {

	public static class HeaderEncoder {
		private Pattern userAgentPattern;
		private StringEncoder headerEncoder;
		
		public boolean matches(String userAgent) {
			return userAgentPattern.matcher(userAgent).matches();
		}
		
		public String encodeHeader(String text, String charset) {
			return headerEncoder.encode(text, charset);
		}

		public Pattern getUserAgentPattern() {
			return userAgentPattern;
		}

		public void setUserAgentPattern(Pattern userAgentPattern) {
			this.userAgentPattern = userAgentPattern;
		}

		public StringEncoder getHeaderEncoder() {
			return headerEncoder;
		}

		public void setHeaderEncoder(StringEncoder headerEncoder) {
			this.headerEncoder = headerEncoder;
		}
	}
	
	private CharacterEncodingProvider characterEncodingProvider;
	private HeaderEncoder[] headerEncoders;
	
	public String encodeContentFilename(HttpServletRequest request, String filename) {
		String encodedFilename = filename;
		String userAgent = request.getHeader("User-Agent").toLowerCase();
		String charset = characterEncodingProvider.getCharacterEncoding();
		for (int i = 0; i < headerEncoders.length; i++) {
			HeaderEncoder encoder = headerEncoders[i];
			if (encoder.matches(userAgent)) {
				encodedFilename = encoder.encodeHeader(filename, charset);
				break;
			}
		}
		return encodedFilename;
	}

	public CharacterEncodingProvider getCharacterEncodingProvider() {
		return characterEncodingProvider;
	}

	public void setCharacterEncodingProvider(
			CharacterEncodingProvider characterEncodingProvider) {
		this.characterEncodingProvider = characterEncodingProvider;
	}

	public HeaderEncoder[] getHeaderEncoders() {
		return headerEncoders;
	}

	public void setHeaderEncoders(HeaderEncoder[] headerEncoders) {
		this.headerEncoders = headerEncoders;
	}

}
