package com.jaspersoft.jasperserver.war.helper;

import org.json.JSONObject;
import org.json.JSONArray;

import java.util.*;

import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;

/**
 */
public class UserJsonHelper extends JSONHelper {
    public static final String USER_USER_NAME = "userName";
    public static final String USER_FULL_NAME = "fullName";
    public static final String USER_PASSWORD = "password";
    public static final String USER_EMAIL = "email";
    public static final String USER_ENABLED = "enabled";
    public static final String USER_EXTERNAL = "external";
    public static final String USER_ROLES = "roles";
    public static final String USER_ATTRIBUTES = "attributes";
    public static final String USER_TENANT_ID = "tenantId";
    public static final String IS_USER_EXIST = "isExist";

    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";

    public static final String ROLES = "roles";

    public JSONObject createUsersResponseJson(List users, int firstResult, int maxResult, int totalResult) throws Exception {
        JSONObject data = new JSONObject();

        data.put(PAGINATION_FIRST_RESULT, firstResult);
        data.put(PAGINATION_MAX_RESULT, maxResult);
        data.put(PAGINATION_TOTAL_RESULT, totalResult);

        data.put("users", convertUserListToJson(users,
                new String[]{
                        UserJsonHelper.USER_USER_NAME,
                        UserJsonHelper.USER_FULL_NAME,
                        UserJsonHelper.USER_TENANT_ID,
                        UserJsonHelper.USER_ENABLED}));

        return data;
    }

    public JSONObject createEmptyUserListResponseJson() throws Exception {
        List tempUserList = new ArrayList();

        User tempUser = new UserImpl();

        tempUser.setFullName("");
        tempUser.setEmailAddress("");
        tempUser.setPassword("");
        tempUser.setEnabled(false);
        tempUser.setExternallyDefined(false);

        tempUserList.add(tempUser);

        JSONObject usersJson = createUsersResponseJson(tempUserList, 0, 0, 0);

        return usersJson;
    }

    public JSONObject createIsUserExistJson(boolean isUserExist) throws Exception {
        JSONObject isUserExistJson = new JSONObject();

        isUserExistJson.put(IS_USER_EXIST, isUserExist);

        return isUserExistJson;
    }

    public JSONObject convertUserToJson(User user, String[] fields) throws Exception {

        String userName = user.getUsername();
        String fullName = (user.getFullName() != null) ? user.getFullName() : "";
        String emailAddress = (user.getEmailAddress() != null) ? user.getEmailAddress() : "";
        String password = (user.getPassword() != null) ? user.getPassword() : "";
        Boolean enabled = new Boolean(user.isEnabled());
        Boolean external = new Boolean(user.isExternallyDefined());
        String tenantId = user.getTenantId();
        List roles = (user.getRoles() != null) ? new ArrayList(user.getRoles()) : new ArrayList();
        JSONArray attributes = convertUserAttributesToJson(user.getAttributes());

        RoleJsonHelper roleHelper = new RoleJsonHelper();
        JSONArray rolesJson = roleHelper.convertRoleListToJson(roles,
                new String[]{RoleJsonHelper.ROLE_ROLE_NAME, RoleJsonHelper.ROLE_EXTERNAL, RoleJsonHelper.ROLE_TENANT_ID});

        String[] allUserFields =
                {USER_USER_NAME, USER_FULL_NAME, USER_EMAIL, USER_PASSWORD, USER_ENABLED, USER_ROLES, USER_TENANT_ID, USER_EXTERNAL, USER_ATTRIBUTES};
        Object[] allFieldValues =
                {userName, fullName, emailAddress, password, enabled, rolesJson, tenantId, external, attributes};
        List convertFields = (fields != null) ? Arrays.asList(fields) : Arrays.asList(allUserFields);

        JSONObject userJson = new JSONObject();

        for (int i = 0; i < allUserFields.length; i++) {
            String userField = allUserFields[i];
            Object fieldValue = allFieldValues[i];

            if (convertFields.contains(userField)) {

                userJson.put(userField, fieldValue);
            }
        }

        return userJson;
    }

    public JSONArray convertUserAttributesToJson(List userAttributes) throws Exception {
        List attributes = (userAttributes != null) ? userAttributes : new ArrayList();

        JSONArray attributesJson = new JSONArray();

        for (Iterator it = attributes.iterator(); it.hasNext();) {

            ProfileAttribute attribute = (ProfileAttribute) it.next();

            JSONObject attributeJson = new JSONObject();
            attributeJson.put(ATTRIBUTE_NAME, attribute.getAttrName());
            attributeJson.put(ATTRIBUTE_VALUE, attribute.getAttrValue());

            attributesJson.put(attributeJson);
        }

        return attributesJson;
    }

    public JSONArray convertUserListToJson(List userList, String[] fields) throws Exception {
        JSONArray userListJson = new JSONArray();

        for (Iterator it = userList.iterator(); it.hasNext();) {

            User user = (User) it.next();

            userListJson.put(convertUserToJson(user, fields));
        }

        return userListJson;
    }

    public User convertJsonToUser(String json) throws Exception {

        return convertJsonToUser(new JSONObject(json));
    }

    public User convertJsonToUser(JSONObject userJson) throws Exception {

        User user = new UserImpl();
        RoleJsonHelper roleHelper = new RoleJsonHelper();

        user.setUsername(getPropertyIfHas(userJson, USER_USER_NAME));
        user.setFullName(getPropertyIfHas(userJson, USER_FULL_NAME));
        user.setEmailAddress(getPropertyIfHas(userJson, USER_EMAIL));

        String enabled = getPropertyIfHas(userJson, USER_ENABLED);
        user.setEnabled((enabled != null) ? Boolean.valueOf(enabled).booleanValue() : false);

        String external = getPropertyIfHas(userJson, USER_EXTERNAL);
        user.setExternallyDefined((external != null) ? Boolean.valueOf(external).booleanValue() : false);

        user.setPassword(getPropertyIfHas(userJson, USER_PASSWORD));
        user.setTenantId(getPropertyIfHas(userJson, USER_TENANT_ID));

        String rolesProp = "roles";
        if (userJson.has(rolesProp)) {

            JSONArray rolesJson = userJson.getJSONArray(rolesProp);

            if (rolesJson != null && rolesJson.length() > 0) {

                for (int i = 0; i < rolesJson.length(); i++) {

                    Role role = roleHelper.convertJsonToRole(rolesJson.getJSONObject(i));
                    user.addRole(role);
                }
            }
        }

        return user;
    }

}
