package com.jaspersoft.jasperserver.war.helper;

import org.json.JSONObject;
import org.json.JSONArray;

import java.util.*;

import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;

/**
 */
public class RoleJsonHelper extends JSONHelper {
    public static final String ROLE_ROLE_NAME = "roleName";
    public static final String ROLE_EXTERNAL = "external";
    public static final String ROLE_TENANT_ID = "tenantId";

    public static final String IS_ROLE_EXIST = "isExist";

    public static final String ROLES = "roles";
    public static final String USERS = "users";

    public JSONObject createRolesResponseJson(List roles, int firstResult, int maxResult, int totalResult) throws Exception {
        JSONObject data = new JSONObject();

        data.put(PAGINATION_FIRST_RESULT, firstResult);
        data.put(PAGINATION_MAX_RESULT, maxResult);
        data.put(PAGINATION_TOTAL_RESULT, totalResult);

        data.put(ROLES, convertRoleListToJson(roles, new String[]{RoleJsonHelper.ROLE_ROLE_NAME, RoleJsonHelper.ROLE_TENANT_ID}));

        return data;
    }

    public JSONObject createEmptyRoleListResponseJson() throws Exception {
        List tempRolesList = new ArrayList();

        Role tempRole = new RoleImpl();
        tempRole.setRoleName("");

        tempRolesList.add(tempRole);

        return createRolesResponseJson(tempRolesList, 0, 0, 0);
    }

    public JSONObject createIsRoleExistJson(boolean isRoleExist) throws Exception {
        JSONObject isUserExistJson = new JSONObject();

        isUserExistJson.put(IS_ROLE_EXIST, isRoleExist);

        return isUserExistJson;
    }

    public JSONObject convertRoleToJson(Role user, String[] fields) throws Exception {

        String roleName = user.getRoleName();
        Boolean external = new Boolean(user.isExternallyDefined());
        String tenantId = user.getTenantId();

        String[] allUserFields = {ROLE_ROLE_NAME, ROLE_EXTERNAL, ROLE_TENANT_ID};
        Object[] allFieldValues = {roleName, external, tenantId};
        List convertFields = (fields != null) ? Arrays.asList(fields) : Arrays.asList(allUserFields);

        JSONObject roleJson = new JSONObject();

        for (int i = 0; i < allUserFields.length; i++) {
            String userField = allUserFields[i];
            Object fieldValue = allFieldValues[i];

            if (convertFields.contains(userField)) {

                roleJson.put(userField, fieldValue);
            }
        }

        return roleJson;
    }

    public JSONArray convertRoleListToJson(List roleList, String[] fields) throws Exception {
        JSONArray userListJson = new JSONArray();

        for (Iterator it = roleList.iterator(); it.hasNext();) {

            Role role = (Role) it.next();

            userListJson.put(convertRoleToJson(role, fields));
        }

        return userListJson;
    }

    public Role convertJsonToRole(JSONObject roleJson) throws Exception {

        Role role = new RoleImpl();
        UserJsonHelper userHelper = new UserJsonHelper();

        role.setRoleName(getPropertyIfHas(roleJson, ROLE_ROLE_NAME));
        role.setTenantId(getPropertyIfHas(roleJson, ROLE_TENANT_ID));

        String external = getPropertyIfHas(roleJson, ROLE_EXTERNAL);
        role.setExternallyDefined((external != null) ? Boolean.valueOf(external).booleanValue() : false);

        if ( roleJson.has(USERS)) {

            JSONArray userJson =  roleJson.getJSONArray(USERS);

            if (userJson != null && userJson.length() > 0) {

                for (int i = 0; i < userJson.length(); i++) {

                    User user = userHelper.convertJsonToUser(userJson.getJSONObject(i));
                    role.addUser(user);
                }
            }
        }

        return role;
    }

    public Role convertJsonToRole(String json) throws Exception {

        return convertJsonToRole(new JSONObject(json));
    }

}