/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.irplugin.gui.inputcontrols.ui;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.irplugin.gui.inputcontrols.ListItemWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

/**
 *
 * @author  gtoffoli
 */
public class RadioListInputControlUI extends javax.swing.JPanel implements InputControlUI {
    
    private java.util.List radios = new java.util.ArrayList();
    private java.util.HashMap itemValues = new java.util.HashMap();
    
    
    /** Creates new form BasicInputControlUI */
    public RadioListInputControlUI() {
        initComponents();
    }
    
    public Object getValue()
    {
        ButtonModel bm = buttonGroup1.getSelection();
        if (bm != null)
        {
            return itemValues.get(bm);
        }
        return null;
    }
    
    public void setValue(Object v)
    {
        Iterator it = itemValues.keySet().iterator();
        while (it.hasNext())
        {
            ButtonModel bm = (ButtonModel)it.next();
            Object val = itemValues.get(bm);
            if ( ( val == null && v == null) || ( val != null && val.equals(v)) )
            {
                buttonGroup1.setSelected(bm, true);
                return;
            }
            buttonGroup1.setSelected(bm, false);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabelName = new javax.swing.JLabel();
        jPanelList = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(250, 40));
        jLabelName.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabelName, gridBagConstraints);

        jPanelList.setLayout(new javax.swing.BoxLayout(jPanelList, javax.swing.BoxLayout.Y_AXIS));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 14, 4, 4);
        add(jPanelList, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    public void setLabel(String lbl)
    {
        this.jLabelName.setText(lbl);
    }
    
    /**
     *  Expected a list of ListItemWrapper
     */
    public void setHistory(java.util.List values){
        
        if (values == null) return;
        
        
        jPanelList.removeAll();
        this.buttonGroup1 = new ButtonGroup();
        
        //java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        //gridBagConstraints.gridx = 0;
        //gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        //gridBagConstraints.weightx = 1.0;
        //gridBagConstraints.insets = new java.awt.Insets(4, 10, 0, 0);
        // Try to understand how much columns...
        
        int w = 100;
        Dimension d = jPanelList.getPreferredSize();
        for (int i=0; i<values.size(); ++i)
        {
            ListItemWrapper iw =  (ListItemWrapper)values.get(i);
            
            
            JRadioButton rb = new JRadioButton(iw.getItem().getLabel());
            this.buttonGroup1.add(rb);
            rb.setSelected(false);
            itemValues.put(rb.getModel(), iw.getItem().getValue() );
            
            rb.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
            rb.setMargin(new java.awt.Insets(0, 0, 0, 0));
            
            if (rb.getPreferredSize().width > w) w = rb.getPreferredSize().width;
            d = new Dimension(w,(rb.getPreferredSize().height)* values.size());
            
            jPanelList.add(rb); //, gridBagConstraints);
        }
        
        jPanelList.setPreferredSize(d);
        jPanelList.setMinimumSize(d);
        d.height += jLabelName.getPreferredSize().height + 6;
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        
        jPanelList.updateUI();
        this.updateUI();
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jLabelName;
    private javax.swing.JPanel jPanelList;
    // End of variables declaration//GEN-END:variables
    
    public void setReadOnly( boolean b )
    {
        
        for (int i=0; i<jPanelList.getComponentCount(); ++i)
        {
            Component c = jPanelList.getComponent(i);
            if (c instanceof JRadioButton)
            {
               ((JRadioButton)c).setEnabled(!b);
            }
        }
    }

}
