/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.export.modules.repository;

import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: RepositoryExportPathFilter.java 14990 2009-02-04 12:15:22Z lucian $
 */
public class RepositoryExportPathFilter implements RepositoryExportFilter {

	private static final Log log = LogFactory.getLog(RepositoryExportPathFilter.class);
	
	private String[] excludeContentsFolderPatterns;
	private Pattern[] excludeContentsFolderCompiledPatterns;
	
	public String[] getExcludeContentsFolderPatterns() {
		return excludeContentsFolderPatterns;
	}

	public void setExcludeContentsFolderPatterns(
			String[] excludeContentsFolderPatterns) {
		this.excludeContentsFolderPatterns = excludeContentsFolderPatterns;
		compileExcludeContentsFolderPatterns();
	}

	protected void compileExcludeContentsFolderPatterns() {
		if (excludeContentsFolderPatterns == null 
				|| excludeContentsFolderPatterns.length == 0) {
			excludeContentsFolderCompiledPatterns = null;
		} else {
			excludeContentsFolderCompiledPatterns = 
				new Pattern[excludeContentsFolderPatterns.length];
			for (int i = 0; i < excludeContentsFolderPatterns.length; i++) {
				excludeContentsFolderCompiledPatterns[i] = 
					compilePattern(excludeContentsFolderPatterns[i]);
			}
		}
	}

	protected Pattern compilePattern(String pattern) {
		return Pattern.compile(pattern);
	}

	public boolean toExportContents(Folder folder) {
		if (excludeContentsFolderCompiledPatterns == null) {
			return true;
		}
		
		String folderPath = folder.getURIString();
		for (int i = 0; i < excludeContentsFolderCompiledPatterns.length; i++) {
			Pattern pattern = excludeContentsFolderCompiledPatterns[i];
			if (pattern.matcher(folderPath).matches()) {
				if (log.isDebugEnabled()) {
					log.debug("Folder path " + folderPath 
							+ " matched exclude contents pattern " + pattern);
				}
				
				return false;
			}
		}
		
		return true;
	}

}
