/* 
 * Copyright (C) 2005 - 2007 JasperSoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 * Licensed under commercial JasperSoft Subscription License Agreement
 */

package com.jaspersoft.jasperserver.export.modules.mt;

import com.jaspersoft.jasperserver.api.metadata.user.domain.User;

import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.HashMap;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: DefaultMultiTenancyConfiguration.java 15916 2009-02-20 21:26:54Z schubar $
 */
public class DefaultTenantExportConfiguration
{

	private String rootTenantId;
	private String qualifiedNameSeparator;
	private int qualifiedNameSeparatorLength;

	public String getQualifiedNameSeparator()
	{
		return qualifiedNameSeparator;
	}

	public void setQualifiedNameSeparator(String qualifiedNameSeparator)
	{
		this.qualifiedNameSeparator = qualifiedNameSeparator;
		this.qualifiedNameSeparatorLength = this.qualifiedNameSeparator == null ? 0
				: this.qualifiedNameSeparator.length();
	}

	public String makeQualifiedName(String tenantId, String name)
	{
		String qName;
		if (tenantId == null)
		{
			qName = name;
		}
		else
		{
			qName = name + qualifiedNameSeparator + tenantId;
		}
		return qName;
	}

	public void setRootTenantId(String rootTenantId)
	{
		this.rootTenantId = rootTenantId;
	}

	public String getRootTenantId()
	{
		return rootTenantId;
	}

}
