/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.export.modules.common;


/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: TenantQualifiedName.java 14897 2009-01-16 17:50:01Z lucian $
 */
public class TenantQualifiedName {

	private String tenantId;
	private String name;
	
	public TenantQualifiedName() {
	}
	
	public TenantQualifiedName(String tenantId, String name) {
		this.tenantId = tenantId;
		this.name = name;
	}

	public String getTenantId() {
		return tenantId;
	}
	
	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public boolean equals(Object o) {
		if (!(o instanceof TenantQualifiedName)) {
			return false;
		}
		
		if (o == this) {
			return true;
		}
		
		TenantQualifiedName n = (TenantQualifiedName) o;
		return name.equals(n.name)
			&& (tenantId == null ? n.tenantId == null : (tenantId.equals(n.tenantId)));
	}
	
	public int hashCode() {
		return 37 * name.hashCode() 
			+ (tenantId == null ? 0 : tenantId.hashCode());
	}
	
}
