/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.metadata.user.domain.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;

/**
 * @author achan
 *
 */
public class TenantImpl implements Tenant, Serializable {
	
	private String id = null;
	private String parentId = null;
	private String tenantName = null;
    private List attributes = new ArrayList();
    private String tenantDesc = null;
    private String tenantNote = null;
    private String tenantUri = null;
    private String tenantFolderUri = null;
	
	
	/**
	 * @return Returns the tenantDesc.
	 */
	public String getTenantDesc() {
		return tenantDesc;
	}
	/**
	 * @param tenantDesc The tenantDesc to set.
	 */
	public void setTenantDesc(String tenantDesc) {
		this.tenantDesc = tenantDesc;
	}
	/**
	 * @return Returns the tenantNote.
	 */
	public String getTenantNote() {
		return tenantNote;
	}
	/**
	 * @param tenantNote The tenantNote to set.
	 */
	public void setTenantNote(String tenantNote) {
		this.tenantNote = tenantNote;
	}
	
	public String getId() {
		return id;
	}
	public void setId(String pid) {
		id = pid;
	}
    
	public String getParentId() {
		return parentId;
	}
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	public String getTenantName() {
		return tenantName;
	}
	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public List getAttributes() {
	    return attributes;
	}

    public void setAttributes(List attrs) {
	    attributes = attrs;
    }

	/**
	 * @return Returns the tenantUri.
	 */
	public String getTenantUri() {
		return tenantUri;
	}
	/**
	 * @param tenantUri The tenantUri to set.
	 */
	public void setTenantUri(String tenantUri) {
		this.tenantUri = tenantUri;
	}
	public String getTenantFolderUri() {
		return tenantFolderUri;
	}
	public void setTenantFolderUri(String tenantFolderUri) {
		this.tenantFolderUri = tenantFolderUri;
	}
	
	
	
	
	
}
