/*
 * Copyright (C) 2005 - 2008 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileName;

/**
 * Implementation of Apache VFS FileName to access the JasperServer repository
 *
 * @author swood
 */
public class RepositoryFileName extends AbstractFileName {

    public static final String REPOSITORY_SCHEME = "repo";

    protected RepositoryFileName(final String path, final FileType type) {
        /*
         * We could get "repo:/a/resource", "/a/resource", "a/resource"
         *
         * Want to put in "/a/resource" as the path
         */
        super(REPOSITORY_SCHEME,
                   (path == null)
                        ? "/"           // the root
                        : (
                            (path.startsWith("/")
                            ? path      // "/a/resource"
                            : (
                                (path.startsWith(REPOSITORY_SCHEME + ":/")  // "repo:/a/resource"
                                ? path.substring(5)
                                : "/" + path    // "a/resource"
                              )
                          )
                           )),
                   type);
    }

    /**
     * Factory method for creating name instances.
     */
    public FileName createName(final String path, FileType type) {
        return new RepositoryFileName(path, type);
    }

    /**
     * Builds the root URI for this file name.
     */
    protected void appendRootUri(final StringBuffer buffer, boolean addPassword) {
        buffer.append(getScheme());
        buffer.append(":");
    }

    @Override
    public String getScheme() {
        return REPOSITORY_SCHEME;
    }
}
