/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.security;

import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclDao;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ReportJobAclDao.java 14870 2009-01-09 18:33:20Z lucian $
 */
public class ReportJobAclDao implements BasicAclDao {

	private static final Log log = LogFactory.getLog(ReportJobAclDao.class);
	
	private ReportJobsInternalService reportJobsInternalService;
	private String administratorRole;
	
	public BasicAclEntry[] getAcls(AclObjectIdentity objectIdentity) {
		if (log.isDebugEnabled()) {
			log.debug("Retrieving ACLs for " + objectIdentity);
		}

		String jobOwner = getJobOwner(objectIdentity);
		return makeJobAclEntries(objectIdentity, jobOwner);
	}

	protected final String getJobOwner(AclObjectIdentity jobIdentity) {
		NamedEntityObjectIdentity namedId = (NamedEntityObjectIdentity) jobIdentity;
		long jobId = Long.parseLong(namedId.getId());
		return getReportJobsInternalService().getJobOwner(jobId);
	}

	protected BasicAclEntry[] makeJobAclEntries(
			AclObjectIdentity objectIdentity, String jobOwner) {
		SimpleAclEntry userReadEntry = new SimpleAclEntry(jobOwner, 
				objectIdentity, null, SimpleAclEntry.READ_WRITE_DELETE);
		SimpleAclEntry admReadEntry = new SimpleAclEntry(getAdministratorRole(), 
				objectIdentity, null, SimpleAclEntry.ADMINISTRATION);
		return new BasicAclEntry[]{userReadEntry, admReadEntry};
	}

	public String getAdministratorRole() {
		return administratorRole;
	}

	public void setAdministratorRole(String administratorRole) {
		this.administratorRole = administratorRole;
	}

	public ReportJobsInternalService getReportJobsInternalService() {
		return reportJobsInternalService;
	}

	public void setReportJobsInternalService(
			ReportJobsInternalService reportJobsInternalService) {
		this.reportJobsInternalService = reportJobsInternalService;
	}

}
