/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: DefaultRepositoryContextManager.java 14705 2008-11-25 09:54:35Z lucian $
 */
public class DefaultRepositoryContextManager implements
		RepositoryContextManager {

	private RepositoryService repository;
	private CompiledReportProvider compiledReportProvider;
	
	public DefaultRepositoryContextManager() {
	}
	
	public DefaultRepositoryContextManager(RepositoryService repository, 
			CompiledReportProvider compiledReportProvider) {
		this.repository = repository;
		this.compiledReportProvider = compiledReportProvider;
	}
	
	public RepositoryService getRepository() {
		return repository;
	}

	public void setRepository(RepositoryService repository) {
		this.repository = repository;
	}

	public CompiledReportProvider getCompiledReportProvider() {
		return compiledReportProvider;
	}

	public void setCompiledReportProvider(
			CompiledReportProvider compiledReportProvider) {
		this.compiledReportProvider = compiledReportProvider;
	}

	public void setRepositoryContext(ExecutionContext context,
			String reportUnitURI, ReportUnit inMemoryReportUnit) {
		RepositoryContext repositoryContext = createRepositoryContext(context,
				reportUnitURI, inMemoryReportUnit);
		RepositoryUtil.setThreadRepositoryContext(repositoryContext);
	}

	protected RepositoryContext createRepositoryContext(
			ExecutionContext context,
			String reportUnitURI, ReportUnit inMemoryReportUnit) {
		RepositoryContext repositoryContext = new RepositoryContext();
		repositoryContext.setRepository(repository);
		repositoryContext.setContextResourceURI(reportUnitURI);
		repositoryContext.setReportUnit(inMemoryReportUnit);
		repositoryContext.setExecutionContext(context);
		repositoryContext.setCompiledReportProvider(compiledReportProvider);
		return repositoryContext;
	}

	public void resetRepositoryContext() {
		RepositoryUtil.clearThreadRepositoryContext();
	}

	public String getRepositoryPathKey(String path) {
		return path;
	}

	public String getRepositoryUriForKey(String pathKey) {
		return pathKey;
	}

}
