
    create table JIAdhocChartMeasure (
        id bigint not null,
        name varchar(255) not null,
        label varchar(255) with null,
        width integer with null,
        jiFunction varchar(255) with null,
        type varchar(255) with null,
        mask varchar(255) with null,
        functionMask varchar(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIAdhocColumn (
        id bigint not null,
        name varchar(255) not null,
        label varchar(255) with null,
        width integer with null,
        jiFunction varchar(255) with null,
        type varchar(255) with null,
        mask varchar(255) with null,
        functionMask varchar(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIAdhocGroup (
        id bigint not null,
        name varchar(255) not null,
        label varchar(255) with null,
        type varchar(255) with null,
        mask varchar(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIAdhocReportUnit (
        id bigint not null,
        adhocStateId bigint with null,
        primary key (id)
    );

    create table JIAdhocState (
        id bigint not null,
        type varchar(255) not null,
        theme varchar(255) with null,
        title varchar(255) with null,
        pageOrientation varchar(255) with null,
        paperSize varchar(255) with null,
        maxRows integer with null,
        summaryLabel varchar(255) with null,
        group_name varchar(255) with null,
        group_label varchar(255) with null,
        group_type varchar(255) with null,
        group_mask varchar(255) with null,
        primary key (id)
    );

    create table JIAdhocStateProperty (
        state_id bigint not null,
        value varchar(1000) with null,
        name varchar(100) not null,
        primary key (state_id, name)
    );

    create table JIAdhocTableSortField (
        id bigint not null,
        fieldName varchar(255) not null,
        ascending tinyint with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIAdhocXTabColumnGroup (
        id bigint not null,
        name varchar(255) not null,
        label varchar(255) with null,
        type varchar(255) with null,
        categorizer varchar(1000) with null,
        fieldName varchar(255) with null,
        fieldType varchar(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIAdhocXTabMeasure (
        id bigint not null,
        name varchar(255) not null,
        label varchar(255) with null,
        width integer with null,
        jiFunction varchar(255) with null,
        type varchar(255) with null,
        mask varchar(255) with null,
        functionMask varchar(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIAdhocXTabRowGroup (
        id bigint not null,
        name varchar(255) not null,
        label varchar(255) with null,
        type varchar(255) with null,
        categorizer varchar(1000) with null,
        fieldName varchar(255) with null,
        fieldType varchar(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIBeanDatasource (
        id bigint not null,
        beanName varchar(100) not null,
        beanMethod varchar(100) with null,
        primary key (id)
    );

    create table JIContentResource (
        id bigint not null,
        data long byte with null,
        file_type varchar(20) with null,
        primary key (id)
    );

    create table JICustomDatasource (
        id bigint not null,
        serviceClass varchar(250) not null,
        primary key (id)
    );

    create table JICustomDatasourceProperty (
        ds_id bigint not null,
        value varchar(1000) with null,
        name varchar(100) not null,
        primary key (ds_id, name)
    );

    create table JIDashboard (
        id bigint not null,
        adhocStateId bigint with null,
        primary key (id)
    );

    create table JIDashboardFrameProperty (
        id bigint not null,
        frameName varchar(255) not null,
        frameClassName varchar(255) not null,
        propertyName varchar(255) not null,
        propertyValue varchar(1000) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JIDashboardResource (
        dashboard_id bigint not null,
        resource_id bigint not null,
        resource_index integer not null,
        primary key (dashboard_id, resource_index)
    );

    create table JIDataDefinerUnit (
        id bigint not null,
        primary key (id)
    );

    create table JIDataType (
        id bigint not null,
        type tinyint with null,
        maxLength integer with null,
        decimals integer with null,
        regularExpr varchar(255) with null,
        minValue varbyte(255) with null,
        maxValue varbyte(255) with null,
        strictMin tinyint with null,
        strictMax tinyint with null,
        primary key (id)
    );

    create table JIDomainDatasource (
        id bigint not null,
        schema_id bigint not null,
        security_id bigint with null,
        primary key (id)
    );

    create table JIDomainDatasourceBundle (
        slds_id bigint not null,
        locale varchar(20) with null,
        bundle_id bigint not null,
        idx integer not null,
        primary key (slds_id, idx)
    );

    create table JIDomainDatasourceDSRef (
        slds_id bigint not null,
        ref_id bigint not null,
        alias varchar(100) not null,
        primary key (slds_id, alias)
    );

    create table JIFileResource (
        id bigint not null,
        data long byte with null,
        file_type varchar(20) with null,
        reference bigint with null,
        primary key (id)
    );

    create table JIInputControl (
        id bigint not null,
        type tinyint with null,
        mandatory tinyint with null,
        readOnly tinyint with null,
        visible tinyint with null,
        data_type bigint with null,
        list_of_values bigint with null,
        list_query bigint with null,
        query_value_column varchar(200) with null,
        defaultValue varbyte(255) with null,
        primary key (id)
    );

    create table JIInputControlQueryColumn (
        input_control_id bigint not null,
        query_column varchar(200) not null,
        column_index integer not null,
        primary key (input_control_id, column_index)
    );

    create table JIJNDIJdbcDatasource (
        id bigint not null,
        jndiName varchar(100) not null,
        timezone varchar(100) with null,
        primary key (id)
    );

    create table JIJdbcDatasource (
        id bigint not null,
        driver varchar(100) not null,
        password varchar(100) with null,
        connectionUrl varchar(500) with null,
        username varchar(100) with null,
        timezone varchar(100) with null,
        primary key (id)
    );

    create table JIListOfValues (
        id bigint not null,
        primary key (id)
    );

    create table JIListOfValuesItem (
        id bigint not null,
        label varchar(255) with null,
        value varbyte(255) with null,
        idx integer not null,
        primary key (id, idx)
    );

    create table JILogEvent (
        id bigint not null,
        occurrence_date date not null,
        event_type tinyint not null,
        component varchar(100) with null,
        message varchar(250) not null,
        resource_uri varchar(250) with null,
        event_text long varchar with null,
        event_data long byte with null,
        event_state tinyint with null,
        userId bigint with null,
        primary key (id)
    );

    create table JIMondrianConnection (
        id bigint not null,
        reportDataSource bigint with null,
        mondrianSchema bigint with null,
        primary key (id)
    );

    create table JIMondrianConnectionGrant (
        mondrianConnectionId bigint not null,
        accessGrant bigint not null,
        grantIndex integer not null,
        primary key (mondrianConnectionId, grantIndex)
    );

    create table JIMondrianXMLADefinition (
        id bigint not null,
        catalog varchar(100) not null,
        mondrianConnection bigint with null,
        primary key (id)
    );

    create table JIObjectPermission (
        id bigint not null,
        uri varchar(250) not null,
        recipientobjectclass varchar(250) with null,
        recipientobjectid bigint with null,
        permissionMask integer not null,
        primary key (id)
    );

    create table JIOlapClientConnection (
        id bigint not null,
        primary key (id)
    );

    create table JIOlapUnit (
        id bigint not null,
        olapClientConnection bigint with null,
        mdx_query varchar(3600) not null,
        view_options long byte with null,
        primary key (id)
    );

    create table JIProfileAttribute (
        id bigint not null,
        attrName varchar(255) not null,
        attrValue varchar(255) not null,
        principalobjectclass varchar(255) not null,
        principalobjectid bigint not null,
        primary key (id)
    );

    create table JIQuery (
        id bigint not null,
        dataSource bigint with null,
        query_language varchar(40) not null,
        sql_query varchar(3600) not null,
        primary key (id)
    );

    create table JIReportJob (
        id bigint not null,
        version integer not null,
        owner bigint not null,
        label varchar(100) not null,
        description varchar(2000) with null,
        report_unit_uri varchar(250) not null,
        job_trigger bigint not null,
        base_output_name varchar(100) not null,
        output_locale varchar(20) with null,
        content_destination bigint with null,
        mail_notification bigint with null,
        primary key (id)
    );

    create table JIReportJobCalendarTrigger (
        id bigint not null,
        minutes varchar(200) not null,
        hours varchar(80) not null,
        days_type tinyint not null,
        week_days varchar(20) with null,
        month_days varchar(100) with null,
        months varchar(40) not null,
        primary key (id)
    );

    create table JIReportJobMail (
        id bigint not null,
        version integer not null,
        subject varchar(100) not null,
        message varchar(2000) with null,
        send_type tinyint not null,
        skip_empty tinyint not null,
        primary key (id)
    );

    create table JIReportJobMailRecipient (
        destination_id bigint not null,
        recipient_type tinyint not null,
        address varchar(100) not null,
        recipient_idx integer not null,
        primary key (destination_id, recipient_idx)
    );

    create table JIReportJobOutputFormat (
        report_job_id bigint not null,
        output_format tinyint not null,
        primary key (report_job_id, output_format)
    );

    create table JIReportJobParameter (
        job_id bigint not null,
        parameter_value varbyte(1000) with null,
        parameter_name varchar(100) not null,
        primary key (job_id, parameter_name)
    );

    create table JIReportJobRepoDest (
        id bigint not null,
        version integer not null,
        folder_uri varchar(250) not null,
        sequential_filenames tinyint not null,
        overwrite_files tinyint not null,
        output_description varchar(250) with null,
        timestamp_pattern varchar(250) with null,
        primary key (id)
    );

    create table JIReportJobSimpleTrigger (
        id bigint not null,
        occurrence_count integer not null,
        recurrence_interval integer with null,
        recurrence_interval_unit tinyint with null,
        primary key (id)
    );

    create table JIReportJobTrigger (
        id bigint not null,
        version integer not null,
        timezone varchar(40) with null,
        start_type tinyint not null,
        start_date date with null,
        end_date date with null,
        primary key (id)
    );

    create table JIReportOptions (
        id bigint not null,
        options_name varchar(210) not null,
        report_id bigint not null,
        primary key (id)
    );

    create table JIReportOptionsInput (
        options_id bigint not null,
        input_value varbyte(1000) with null,
        input_name varchar(100) not null,
        primary key (options_id, input_name)
    );

    create table JIReportUnit (
        id bigint not null,
        reportDataSource bigint with null,
        query bigint with null,
        mainReport bigint with null,
        controlrenderer varchar(100) with null,
        reportrenderer varchar(100) with null,
        promptcontrols tinyint with null,
        controlslayout tinyint with null,
        primary key (id)
    );

    create table JIReportUnitInputControl (
        report_unit_id bigint not null,
        input_control_id bigint not null,
        control_index integer not null,
        primary key (report_unit_id, control_index)
    );

    create table JIReportUnitResource (
        report_unit_id bigint not null,
        resource_id bigint not null,
        resource_index integer not null,
        primary key (report_unit_id, resource_index)
    );

    create table JIRepositoryCache (
        id bigint not null,
        uri varchar(250) not null,
        cache_name varchar(20) not null,
        data long byte with null,
        version integer not null,
        version_date date not null,
        item_reference bigint with null,
        primary key (id),
        unique (uri, cache_name)
    );

    create table JIResource (
        id bigint not null,
        version integer not null,
        name varchar(100) not null,
        parent_folder bigint not null,
        childrenFolder bigint with null,
        label varchar(100) not null,
        description varchar(250) with null,
        creation_date date not null,
        primary key (id),
        unique (name, parent_folder)
    );

    create table JIResourceFolder (
        id bigint not null,
        version integer not null,
        uri varchar(250) not null,
        hidden tinyint with null,
        name varchar(100) not null,
        label varchar(100) not null,
        description varchar(250) with null,
        parent_folder bigint with null,
        creation_date date not null,
        primary key (id),
        unique (uri)
    );

    create table JIRole (
        id bigint not null,
        rolename varchar(100) not null,
        tenantId bigint not null,
        externallyDefined tinyint with null,
        primary key (id),
        unique (rolename, tenantId)
    );

    create table JITenant (
        id bigint not null,
        tenantId varchar(100) not null,
        parentId bigint with null,
        tenantName varchar(100) not null,
        tenantDesc varchar(250) with null,
        tenantNote varchar(250) with null,
        tenantUri varchar(250) not null,
        tenantFolderUri varchar(250) not null,
        primary key (id),
        unique (tenantId)
    );

    create table JIUser (
        id bigint not null,
        username varchar(100) not null,
        tenantId bigint not null,
        fullname varchar(100) not null,
        emailAddress varchar(100) with null,
        password varchar(100) with null,
        externallyDefined tinyint with null,
        enabled tinyint with null,
        previousPasswordChangeTime date with null,
        primary key (id),
        unique (username, tenantId)
    );

    create table JIUserRole (
        roleId bigint not null,
        userId bigint not null,
        primary key (userId, roleId)
    );

    create table JIXMLAConnection (
        id bigint not null,
        catalog varchar(100) not null,
        username varchar(100) not null,
        password varchar(100) not null,
        datasource varchar(100) not null,
        uri varchar(100) not null,
        primary key (id)
    );

    alter table JIAdhocChartMeasure 
        add constraint FK89D1A3FAB0A3C8CB 
        foreign key (id) 
        references JIAdhocState;

    alter table JIAdhocColumn 
        add constraint FK9265D330EC885ADB 
        foreign key (id) 
        references JIAdhocState;

    alter table JIAdhocGroup 
        add constraint FK704D9365EC885ADB 
        foreign key (id) 
        references JIAdhocState;

    alter table JIAdhocReportUnit 
        add constraint FK68AE6BB2981B13F0 
        foreign key (id) 
        references JIReportUnit;

    alter table JIAdhocReportUnit 
        add constraint FK68AE6BB231211827 
        foreign key (adhocStateId) 
        references JIAdhocState;

    alter table JIAdhocStateProperty 
        add constraint FK2C7E3C6C298B519D 
        foreign key (state_id) 
        references JIAdhocState;

    alter table JIAdhocTableSortField 
        add constraint FK1AF05FA8EC885ADB 
        foreign key (id) 
        references JIAdhocState;

    alter table JIAdhocXTabColumnGroup 
        add constraint FK336E71F262231DA 
        foreign key (id) 
        references JIAdhocState;

    alter table JIAdhocXTabMeasure 
        add constraint FK3CF53B0762231DA 
        foreign key (id) 
        references JIAdhocState;

    alter table JIAdhocXTabRowGroup 
        add constraint FK9D33843C62231DA 
        foreign key (id) 
        references JIAdhocState;

    alter table JIBeanDatasource 
        add constraint FK674BF34A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIContentResource 
        add constraint FKE466FC68A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JICustomDatasource 
        add constraint FK2BBCEDF5A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JICustomDatasourceProperty 
        add constraint FKB8A66AEA858A89D1 
        foreign key (ds_id) 
        references JICustomDatasource;

    alter table JIDashboard 
        add constraint FKEC09F815A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIDashboard 
        add constraint FKEC09F81531211827 
        foreign key (adhocStateId) 
        references JIAdhocState;

    alter table JIDashboardFrameProperty 
        add constraint FK679EF04DFA08F0B4 
        foreign key (id) 
        references JIAdhocState;

    alter table JIDashboardResource 
        add constraint FK37B53B43326276AC 
        foreign key (dashboard_id) 
        references JIDashboard;

    alter table JIDashboardResource 
        add constraint FK37B53B43F254B53E 
        foreign key (resource_id) 
        references JIResource;

    alter table JIDataDefinerUnit 
        add constraint FK1EC11AF2981B13F0 
        foreign key (id) 
        references JIReportUnit;

    alter table JIDataType 
        add constraint FK533BCC63A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIDomainDatasource 
        add constraint FK59F8EB88A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIDomainDatasource 
        add constraint FK59F8EB88992A3868 
        foreign key (security_id) 
        references JIFileResource;

    alter table JIDomainDatasource 
        add constraint FK59F8EB8833A6D267 
        foreign key (schema_id) 
        references JIFileResource;

    alter table JIDomainDatasourceBundle 
        add constraint FKE9F0422AE494DFE6 
        foreign key (bundle_id) 
        references JIFileResource;

    alter table JIDomainDatasourceBundle 
        add constraint FKE9F0422ACB906E03 
        foreign key (slds_id) 
        references JIDomainDatasource;

    alter table JIDomainDatasourceDSRef 
        add constraint FKFDA42FCCB906E03 
        foreign key (slds_id) 
        references JIDomainDatasource;

    alter table JIDomainDatasourceDSRef 
        add constraint FKFDA42FC7106B699 
        foreign key (ref_id) 
        references JIResource;

    alter table JIFileResource 
        add constraint FKF75B5889A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIFileResource 
        add constraint FKF75B58895A0C539 
        foreign key (reference) 
        references JIFileResource;

    alter table JIInputControl 
        add constraint FKCAC6A512120E06F7 
        foreign key (data_type) 
        references JIDataType;

    alter table JIInputControl 
        add constraint FKCAC6A512A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIInputControl 
        add constraint FKCAC6A51262A86F04 
        foreign key (list_of_values) 
        references JIListOfValues;

    alter table JIInputControl 
        add constraint FKCAC6A512B37DB6EB 
        foreign key (list_query) 
        references JIQuery;

    alter table JIInputControlQueryColumn 
        add constraint FKE436A5CCE7922149 
        foreign key (input_control_id) 
        references JIInputControl;

    alter table JIJNDIJdbcDatasource 
        add constraint FK7F9DA248A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIJdbcDatasource 
        add constraint FKC8BDFCBFA8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIListOfValues 
        add constraint FK4E86A776A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIListOfValuesItem 
        add constraint FKD37CEBA993F0E1F6 
        foreign key (id) 
        references JIListOfValues;

    alter table JILogEvent 
        add constraint FK5F32081591865AF 
        foreign key (userId) 
        references JIUser;

    alter table JIMondrianConnection 
        add constraint FK4FF53B191D51BFAD 
        foreign key (id) 
        references JIOlapClientConnection;

    alter table JIMondrianConnection 
        add constraint FK4FF53B19324CFECB 
        foreign key (reportDataSource) 
        references JIResource;

    alter table JIMondrianConnection 
        add constraint FK4FF53B19C495A60B 
        foreign key (mondrianSchema) 
        references JIFileResource;

    alter table JIMondrianConnectionGrant 
        add constraint FK3DDE9D8346D80AD2 
        foreign key (mondrianConnectionId) 
        references JIMondrianConnection;

    alter table JIMondrianConnectionGrant 
        add constraint FK3DDE9D83FFAC5026 
        foreign key (accessGrant) 
        references JIFileResource;

    alter table JIMondrianXMLADefinition 
        add constraint FK313B2AB8A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIMondrianXMLADefinition 
        add constraint FK313B2AB8DC098B1 
        foreign key (mondrianConnection) 
        references JIMondrianConnection;

    alter table JIMondrianXMLADefinition 
        add constraint FK313B2AB8801D6C37 
        foreign key (mondrianConnection) 
        references JIMondrianConnection;

    create index uri_index on JIObjectPermission (uri);

    alter table JIOlapClientConnection 
        add constraint FK3CA3B7D4A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIOlapUnit 
        add constraint FKF034DCCFA8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIOlapUnit 
        add constraint FKF034DCCF8F542247 
        foreign key (olapClientConnection) 
        references JIOlapClientConnection;

    alter table JIQuery 
        add constraint FKCBCB0EC9A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIQuery 
        add constraint FKCBCB0EC92B329A97 
        foreign key (dataSource) 
        references JIResource;

    alter table JIReportJob 
        add constraint FK156F5F6AE4D73E35 
        foreign key (mail_notification) 
        references JIReportJobMail;

    alter table JIReportJob 
        add constraint FK156F5F6A9EEC902C 
        foreign key (content_destination) 
        references JIReportJobRepoDest;

    alter table JIReportJob 
        add constraint FK156F5F6A74D2696E 
        foreign key (job_trigger) 
        references JIReportJobTrigger;

    alter table JIReportJob 
        add constraint FK156F5F6A4141263C 
        foreign key (owner) 
        references JIUser;

    alter table JIReportJobCalendarTrigger 
        add constraint FKC374C7D0D2B2EB53 
        foreign key (id) 
        references JIReportJobTrigger;

    alter table JIReportJobMailRecipient 
        add constraint FKBB6DB6D880001AAE 
        foreign key (destination_id) 
        references JIReportJobMail;

    alter table JIReportJobOutputFormat 
        add constraint FKB42A5CE2C3389A8 
        foreign key (report_job_id) 
        references JIReportJob;

    alter table JIReportJobParameter 
        add constraint FKEAC52B5F2EC643D 
        foreign key (job_id) 
        references JIReportJob;

    alter table JIReportJobSimpleTrigger 
        add constraint FKB9337C5CD2B2EB53 
        foreign key (id) 
        references JIReportJobTrigger;

    alter table JIReportOptions 
        add constraint resource_id 
        foreign key (id) 
        references JIResource;

    alter table JIReportOptions 
        add constraint report_fk 
        foreign key (report_id) 
        references JIReportUnit;

    alter table JIReportOptionsInput 
        add constraint options_fk 
        foreign key (options_id) 
        references JIReportOptions;

    alter table JIReportUnit 
        add constraint FK98818B77A8BF376D 
        foreign key (id) 
        references JIResource;

    alter table JIReportUnit 
        add constraint FK98818B778FDA11CC 
        foreign key (query) 
        references JIQuery;

    alter table JIReportUnit 
        add constraint FK98818B77324CFECB 
        foreign key (reportDataSource) 
        references JIResource;

    alter table JIReportUnit 
        add constraint FK98818B778C8DF21B 
        foreign key (mainReport) 
        references JIFileResource;

    alter table JIReportUnitInputControl 
        add constraint FK5FBE934AE7922149 
        foreign key (input_control_id) 
        references JIInputControl;

    alter table JIReportUnitInputControl 
        add constraint FK5FBE934AA6A48880 
        foreign key (report_unit_id) 
        references JIReportUnit;

    alter table JIReportUnitResource 
        add constraint FK8B1C4CA5A6A48880 
        foreign key (report_unit_id) 
        references JIReportUnit;

    alter table JIReportUnitResource 
        add constraint FK8B1C4CA5865B10DA 
        foreign key (resource_id) 
        references JIFileResource;

    alter table JIRepositoryCache 
        add constraint FKE7338B19E7C5A6 
        foreign key (item_reference) 
        references JIRepositoryCache;

    alter table JIResource 
        add constraint FKD444826DA58002DF 
        foreign key (childrenFolder) 
        references JIResourceFolder;

    alter table JIResource 
        add constraint FKD444826DA08E2155 
        foreign key (parent_folder) 
        references JIResourceFolder;

    alter table JIResourceFolder 
        add constraint FK7F24453BA08E2155 
        foreign key (parent_folder) 
        references JIResourceFolder;

    alter table JIRole 
        add constraint FK82724655E415AC2D 
        foreign key (tenantId) 
        references JITenant;

    alter table JITenant 
        add constraint FKB1D7B2C97803CC2D 
        foreign key (parentId) 
        references JITenant;

    alter table JIUser 
        add constraint FK8273B1AAE415AC2D 
        foreign key (tenantId) 
        references JITenant;

    alter table JIUserRole 
        add constraint FKD8B5C1403C31045 
        foreign key (roleId) 
        references JIRole;

    alter table JIUserRole 
        add constraint FKD8B5C14091865AF 
        foreign key (userId) 
        references JIUser;

    alter table JIXMLAConnection 
        add constraint FK94C688A71D51BFAD 
        foreign key (id) 
        references JIOlapClientConnection;

    create sequence hibernate_sequence;
