/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.BarChartCompiler;
import com.jaspersoft.sample.ofc.BarDataset;
import com.jaspersoft.sample.ofc.BarSeries;
import com.jaspersoft.sample.ofc.FillBarSeries;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;

public class FillBarDataset
extends JRFillElementDataset {
    private final BarDataset dataset;
    private List seriesList;
    private Set seriesKeys = new LinkedHashSet();
    private Set categories = new LinkedHashSet();
    private Map values = new LinkedHashMap();

    public FillBarDataset(BarDataset dataset, JRFillObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        this.dataset = dataset;
        List datasetSeries = dataset.getSeries();
        this.seriesList = new ArrayList(datasetSeries.size());
        Iterator it = datasetSeries.iterator();
        while (it.hasNext()) {
            BarSeries series = (BarSeries)it.next();
            FillBarSeries fillSeries = new FillBarSeries(series);
            this.seriesList.add(fillSeries);
        }
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        Iterator it = this.seriesList.iterator();
        while (it.hasNext()) {
            FillBarSeries series = (FillBarSeries)it.next();
            series.evaluate(calculator);
        }
    }

    protected void customIncrement() {
        Iterator it = this.seriesList.iterator();
        while (it.hasNext()) {
            FillBarSeries series = (FillBarSeries)it.next();
            String seriesKey = series.getSeriesKey();
            String category = series.getCategory();
            Number value = series.getValue();
            this.seriesKeys.add(seriesKey);
            this.categories.add(category);
            this.values.put(new Pair((Object)seriesKey, (Object)category), value);
        }
    }

    protected void customInitialize() {
        this.seriesKeys.clear();
        this.categories.clear();
        this.values.clear();
    }

    public void collectExpressions(JRExpressionCollector collector) {
        BarChartCompiler.collectExpressions(this.dataset, collector);
    }

    public void finishDataset() {
        super.increment();
    }

    public Set getSeriesKeys() {
        return this.seriesKeys;
    }

    public Set getCategories() {
        return this.categories;
    }

    public Number getValue(String seriesKey, String category) {
        return (Number)this.values.get(new Pair((Object)seriesKey, (Object)category));
    }
}

