/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlTinyInt
extends SqlData {
    private byte value = 0;

    public SqlTinyInt() {
        super(true);
    }

    public SqlTinyInt(byte by) {
        super(false);
        this.value = by;
    }

    public void set(byte by) {
        this.setNotNull();
        this.value = by;
    }

    public void set(SqlTinyInt sqlTinyInt) {
        if (sqlTinyInt == null || sqlTinyInt.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlTinyInt.value;
        }
    }

    public byte get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.value = (byte)(bl ? 1 : 0);
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.value = by;
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.value = (byte)s;
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.value = (byte)n;
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.value = (byte)l;
    }

    public void setFloat(float f) throws SqlEx {
        this.setNotNull();
        this.value = (byte)f;
    }

    public void setDouble(double d) throws SqlEx {
        this.setNotNull();
        this.value = (byte)d;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = (byte)bigDecimal.intValue();
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Byte.parseByte(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    public boolean getBoolean() throws SqlEx {
        return this.value != 0;
    }

    public byte getByte() throws SqlEx {
        return this.value;
    }

    public short getShort() throws SqlEx {
        return this.value;
    }

    public int getInt() throws SqlEx {
        return this.value;
    }

    public long getLong() throws SqlEx {
        return this.value;
    }

    public float getFloat() throws SqlEx {
        return this.value;
    }

    public double getDouble() throws SqlEx {
        return this.value;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return BigDecimal.valueOf(this.value);
    }

    public String getString() throws SqlEx {
        return Byte.toString(this.value);
    }

    public Object getObject() throws SqlEx {
        return new Integer(this.value);
    }
}

