/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.AbstractTreeModel;
import com.tonbeller.wcf.tree.DefaultDeleteNodeModel;
import com.tonbeller.wcf.tree.DeleteNodeModel;
import com.tonbeller.wcf.tree.NodeFilter;
import org.apache.log4j.Logger;

public class TestTreeModel
extends AbstractTreeModel {
    private static final Logger logger = Logger.getLogger((Class)TestTreeModel.class);
    private int[] childCount;
    Node[] roots;

    public TestTreeModel() {
        this(new int[]{3, 4, 4, 4, 4, 4});
    }

    public TestTreeModel(int[] childCount) {
        this.childCount = childCount;
        int c = 65;
        this.roots = new Node[childCount[0]];
        for (int i = 0; i < this.roots.length; ++i) {
            this.roots[i] = new Node(null, "" + (char)(c + i), 1);
        }
    }

    public Object[] getRoots() {
        logger.info((Object)"getRoots");
        return this.roots;
    }

    public boolean hasChildren(Object node) {
        logger.info((Object)("hasChildren: " + node));
        return ((Node)node).hasChildren();
    }

    public Object[] getChildren(Object node) {
        logger.info((Object)("getChildren: " + node));
        return ((Node)node).getChildren();
    }

    public Object getParent(Object node) {
        logger.info((Object)("getParent: " + node));
        return ((Node)node).getParent();
    }

    public DeleteNodeModel getDeleteNodeModel() {
        NodeFilter nf = new NodeFilter(){

            public boolean accept(Object node) {
                return ((Node)node).getName().startsWith("A");
            }
        };
        DefaultDeleteNodeModel ddnm = new DefaultDeleteNodeModel();
        ddnm.setDeletableFilter(nf);
        return ddnm;
    }

    public class Node {
        Node parent;
        String name;
        int level;
        Node[] children;

        public Node(Node parent, String name, int level) {
            this.parent = parent;
            this.name = name;
            this.level = level;
            if (level < TestTreeModel.this.childCount.length) {
                this.children = new Node[TestTreeModel.this.childCount[level]];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = new Node(this, name + "[" + i + "]", level + 1);
                }
            }
        }

        boolean hasChildren() {
            return this.children != null;
        }

        Object[] getChildren() {
            return this.children;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.name;
        }
    }
}

