/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.NodeFilter;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.tree.TreeModelDecorator;

public class SimpleOptimizingTreeModelDecorator
extends TreeModelDecorator {
    NodeFilter filter;
    Object[] roots;
    boolean dirty = true;

    public SimpleOptimizingTreeModelDecorator(NodeFilter filter, TreeModel decoree) {
        super(decoree);
        this.filter = filter;
        decoree.addTreeModelChangeListener(new TreeModelChangeListener(){

            public void treeModelChanged(TreeModelChangeEvent event) {
                SimpleOptimizingTreeModelDecorator.this.dirty = true;
            }
        });
    }

    public Object[] getRoots() {
        if (this.dirty) {
            this.initialize();
        }
        return this.roots;
    }

    public Object getParent(Object node) {
        if (this.dirty) {
            this.initialize();
        }
        for (int i = 0; i < this.roots.length; ++i) {
            if (!this.roots[i].equals(node)) continue;
            return null;
        }
        return super.getParent(node);
    }

    void initialize() {
        this.dirty = false;
        this.roots = super.getRoots();
        while (this.roots.length == 1 && !this.filter.accept(this.roots[0])) {
            this.roots = this.getChildren(this.roots[0]);
        }
    }
}

