/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.toolbar;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.toolbar.ToolBar;
import com.tonbeller.wcf.toolbar.ToolBarComponentSupport;
import com.tonbeller.wcf.toolbar.ToolButtonModel;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class ToolButton
extends ToolBarComponentSupport
implements RequestListener {
    private String tooltip;
    String upImg;
    String downImg;
    boolean pressed;
    String radioGroup;
    ToolBar toolBar;
    ToolButtonModel model;
    String requestId;

    public ToolButton(ToolButtonModel model, String upImg, String downImg) {
        this.model = model;
        this.upImg = upImg;
        this.downImg = downImg;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public String getRadioGroup() {
        return this.radioGroup;
    }

    public void setRadioGroup(String radioGroup) {
        this.radioGroup = radioGroup;
    }

    public String getDownImg() {
        return this.downImg;
    }

    public String getUpImg() {
        return this.upImg;
    }

    public void setDownImg(String downImg) {
        this.downImg = downImg;
    }

    public void setUpImg(String upImg) {
        this.upImg = upImg;
    }

    public void initialize(RequestContext context, ToolBar owner) {
        this.toolBar = owner;
        this.requestId = this.toolBar.isGlobalButtonIds() ? this.getId() : this.toolBar.getId() + "." + this.getId();
        owner.getDispatcher().addRequestListener(this.requestId, null, this);
    }

    public void render(RequestContext context, Element parent) throws Exception {
        this.pressed = this.model.isPressed(context);
        Element elem = DomUtils.appendElement(parent, "tool-button");
        elem.setAttribute("id", this.requestId);
        if (this.pressed) {
            elem.setAttribute("img", this.downImg);
        } else {
            elem.setAttribute("img", this.upImg);
        }
        elem.setAttribute("title", this.toolBar.getTooltip(this.tooltip));
    }

    public void request(RequestContext context) throws Exception {
        List list = this.toolBar.getRadioGroup(this);
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ToolButton btn = (ToolButton)it.next();
                if (btn == this) continue;
                btn.model.setPressed(context, false);
            }
        }
        this.pressed = this.model.isPressed(context);
        this.pressed = !this.pressed;
        this.model.setPressed(context, this.pressed);
        this.pressed = this.model.isPressed(context);
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isSeparator() {
        return false;
    }

    public void setImg(String img) {
        this.setUpImg(img + "-up");
        this.setDownImg(img + "-down");
    }
}

