/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.NestableComponentSupport;
import com.tonbeller.wcf.component.RenderListener;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.selection.SelectionMgr;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.table.CellRenderer;
import com.tonbeller.wcf.table.ITableComponent;
import com.tonbeller.wcf.table.PagedTableModel;
import com.tonbeller.wcf.table.RowComparator;
import com.tonbeller.wcf.table.SortedTableModel;
import com.tonbeller.wcf.table.TableColumn;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.table.TableModelChangeEvent;
import com.tonbeller.wcf.table.TableModelChangeListener;
import com.tonbeller.wcf.table.TableRow;
import com.tonbeller.wcf.utils.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TableComponent
extends NestableComponentSupport
implements ITableComponent {
    private TableColumn[] tableColumns;
    private TableModel tableModel;
    private boolean sortable = true;
    private boolean pageable = true;
    private boolean closable = true;
    private boolean colHeaders = true;
    private Resources resources;
    private String border = null;
    private String width = null;
    private String renderId = null;
    private String error = null;
    SelectionMgr selectionMgr;
    RowComparator comparator = new RowComparator();
    Dispatcher dispatcher = new DispatcherSupport();
    SortedTableModel sorter = new SortedTableModel();
    PagedTableModel pager = new PagedTableModel();
    Document factory;
    Element root;
    String closeHandlerId;
    String selectButtonId;
    String gotoButtonId;
    String gotoInputId;
    String pageSizeButtonId;
    String pageSizeInputId;
    TableModelChangeListener changeListener = new TableModelChangeListener(){

        public void tableModelChanged(TableModelChangeEvent event) {
            if (event.isIdentityChanged()) {
                TableComponent.this.setModel(TableComponent.this.getModel());
            }
        }
    };
    private String tr = "xtr";
    private String td = "xtd";
    private String th = "xth";

    public TableComponent(String id, Component parent, TableModel model) {
        super(id, parent);
        this.selectionMgr = new SelectionMgr(this.getDispatcher(), this);
        this.closeHandlerId = this.getId() + ".close";
        this.selectButtonId = this.getId() + ".select";
        this.gotoButtonId = this.getId() + ".goto.button";
        this.gotoInputId = this.getId() + ".goto.input";
        this.pageSizeButtonId = this.getId() + ".pageSize.button";
        this.pageSizeInputId = this.getId() + ".pageSize.input";
        this.getDispatcher().addRequestListener(this.closeHandlerId, null, new CloseHandler());
        this.getDispatcher().addRequestListener(this.selectButtonId, null, new SelectButtonHandler());
        this.getDispatcher().addRequestListener(this.gotoButtonId, null, new GotoButtonHandler());
        this.getDispatcher().addRequestListener(this.pageSizeButtonId, null, new PageSizeButtonHandler());
        this.getDispatcher().addRequestListener(null, null, this.dispatcher);
        this.sorter.setDecoree(model);
        this.pager.setDecoree(this.sorter);
        this.setModel(model);
    }

    public TableComponent(String id, Component parent) {
        super(id, parent);
        this.tableModel = null;
        super.setVisible(false);
        this.selectionMgr = new SelectionMgr(this.getDispatcher(), this);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.resources = Resources.instance();
        if (this.resources == null) {
            this.resources = context.getResources(TableComponent.class);
        }
    }

    public TableColumn getTableColumn(int columnIndex) {
        return this.tableColumns[columnIndex];
    }

    public void setTableColumn(int columnIndex, TableColumn tableColumn) {
        this.tableColumns[columnIndex] = tableColumn;
    }

    public void setModel(TableModel newModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelChangeListener(this.changeListener);
        }
        this.tableModel = newModel;
        this.tableColumns = new TableColumn[this.tableModel.getColumnCount()];
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.tableColumns[i] = new TableColumn(i);
        }
        if (this.tableColumns.length > 0) {
            this.comparator.setColumn(this.tableColumns[0]);
        } else {
            this.comparator.setColumn(new TableColumn(0));
        }
        this.tableModel.addTableModelChangeListener(this.changeListener);
        this.getSelectionModel().clear();
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.selectionMgr.setSelectionModel(selectionModel);
    }

    public SelectionModel getSelectionModel() {
        return this.selectionMgr.getSelectionModel();
    }

    public void setSortable(boolean newSortable) {
        this.sortable = newSortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setPageable(boolean newPageable) {
        this.pageable = newPageable;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public void setSortColumnIndex(int index) {
        this.comparator.setColumn(this.tableColumns[index]);
    }

    public RowComparator getRowComparator() {
        return this.comparator;
    }

    public int getPageSize() {
        return this.pager.getPageSize();
    }

    public void setPageSize(int newPageSize) {
        this.pager.setPageSize(newPageSize);
    }

    public int getCurrentPage() {
        return this.pager.getCurrentPage();
    }

    public void setCurrentPage(int newCurrentPage) {
        this.pager.setCurrentPage(newCurrentPage);
    }

    public int getPageCount() {
        return this.pager.getPageCount();
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        this.startRendering(context);
        this.dispatcher.clear();
        this.factory = factory;
        this.root = factory.createElement("xtable-component");
        TableModel model = this.getModel();
        if (this.isSortable()) {
            this.sorter.setDecoree(model);
            model = this.sorter;
        }
        if (this.isPageable()) {
            this.pager.setDecoree(model);
            model = this.pager;
        }
        if (this.isSortable()) {
            this.sorter.sort(this.getRowComparator());
        }
        this.renderHeading(model, context);
        this.renderBody(model, context);
        if (this.isPageable()) {
            this.renderPager(model, context);
        }
        if (model.getTitle() != null && model.getTitle().length() > 0) {
            this.root.setAttribute("title", model.getTitle());
        }
        if (this.isClosable()) {
            this.root.setAttribute("closeId", this.closeHandlerId);
        }
        if (this.error != null) {
            this.root.setAttribute("error", this.error);
        }
        if (this.border != null) {
            this.root.setAttribute("border", this.border);
        }
        if (this.width != null) {
            this.root.setAttribute("width", this.width);
        }
        if (this.renderId != null) {
            this.root.setAttribute("renderId", this.renderId);
        }
        this.stopRendering();
        return this.root;
    }

    private void startRendering(RequestContext context) {
        this.selectionMgr.startRendering(context);
        for (int i = 0; i < this.tableColumns.length; ++i) {
            CellRenderer r = this.tableColumns[i].getCellRenderer();
            if (!(r instanceof RenderListener)) continue;
            ((RenderListener)((Object)r)).startRendering(context);
        }
    }

    private void stopRendering() {
        this.selectionMgr.stopRendering();
        for (int i = 0; i < this.tableColumns.length; ++i) {
            CellRenderer r = this.tableColumns[i].getCellRenderer();
            if (!(r instanceof RenderListener)) continue;
            ((RenderListener)((Object)r)).stopRendering();
        }
    }

    void renderHeading(TableModel model, RequestContext context) throws FormatException {
        int visibleColumns = 0;
        Element tr = this.tr();
        int selMode = this.getSelectionModel().getMode();
        if (selMode != 0) {
            Element th = this.th(tr);
            ++visibleColumns;
            if (selMode == 2) {
                th.setAttribute("selectId", this.selectButtonId);
            } else {
                this.text(th, "\u00a0");
            }
        }
        int N = model.getColumnCount();
        for (int i = 0; i < N; ++i) {
            TableColumn tc = this.getTableColumn(i);
            int columnIndex = tc.getColumnIndex();
            if (tc.isHidden()) continue;
            Element th = this.th(tr);
            th.setAttribute("id", DomUtils.randomId());
            if (this.isSortable() && tc.isSortable()) {
                StringBuffer img = new StringBuffer();
                img.append(tc.isDescending() ? "a" : "d");
                img.append(this.getRowComparator().getColumnIndex() == columnIndex ? "c" : "n");
                th.setAttribute("sort", img.toString());
                SortButtonHandler h = new SortButtonHandler(tc);
                this.dispatcher.addRequestListener(th.getAttribute("id"), null, h);
            }
            this.text(th, model.getColumnTitle(columnIndex));
            ++visibleColumns;
        }
        this.root.setAttribute("visibleColumns", "" + visibleColumns);
        if (!this.colHeaders) {
            this.root.removeChild(tr);
        }
    }

    void renderBody(TableModel model, RequestContext context) throws FormatException {
        int rowCount = model.getRowCount();
        int colCount = model.getColumnCount();
        int selectionMode = this.getSelectionModel().getMode();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Element tr = this.tr();
            TableRow row = model.getRow(rowIndex);
            if (selectionMode != 0) {
                Element td = this.td(tr);
                this.selectionMgr.renderButton(td, row);
            }
            for (int i = 0; i < colCount; ++i) {
                TableColumn tc = this.getTableColumn(i);
                if (tc.isHidden()) continue;
                int columnIndex = tc.getColumnIndex();
                Element td = this.td(tr);
                CellRenderer renderer = tc.getCellRenderer();
                renderer.render(context, td, row.getValue(columnIndex));
            }
        }
    }

    void renderPager(TableModel model, RequestContext context) {
        String label;
        Element e;
        int pageCount = this.pager.getPageCount();
        if (model.getRowCount() < 2) {
            return;
        }
        Element tr = this.tr();
        Element td = this.td(tr);
        int visibleColumns = this.countVisibleColumns(model);
        td.setAttribute("colspan", Integer.toString(visibleColumns));
        int currentPage = this.pager.getCurrentPage();
        if (currentPage > 0) {
            DomUtils.appendText(td, "\u00a0");
            this.addPageLink(td, 0, "first");
            this.addPageLink(td, currentPage - 1, "prev");
        }
        DomUtils.appendText(td, "\u00a0");
        Object[] args = new Object[]{new Integer(currentPage + 1), new Integer(pageCount)};
        this.text(td, this.resources.getString("jsp.wcf.table.pages", args));
        if (currentPage < pageCount - 1) {
            DomUtils.appendText(td, "\u00a0");
            this.addPageLink(td, currentPage + 1, "next");
            this.addPageLink(td, pageCount - 1, "last");
        }
        if (pageCount > 1) {
            DomUtils.appendText(td, "\u00a0");
            e = DomUtils.appendElement(td, "xgotopage");
            label = this.resources.getString("jsp.wcf.table.goto.label");
            e.setAttribute("label", label);
            e.setAttribute("buttonId", this.gotoButtonId);
            e.setAttribute("inputId", this.gotoInputId);
            e.setAttribute("value", "" + (currentPage + 1));
        }
        DomUtils.appendText(td, "\u00a0");
        e = DomUtils.appendElement(td, "xgotopage");
        label = this.resources.getString("jsp.wcf.table.rowcnt.label");
        e.setAttribute("label", label);
        e.setAttribute("buttonId", this.pageSizeButtonId);
        e.setAttribute("inputId", this.pageSizeInputId);
        e.setAttribute("value", "" + this.pager.getPageSize());
    }

    private int countVisibleColumns(TableModel model) {
        int visibleColumns = 0;
        if (this.getSelectionModel().getMode() != 0) {
            visibleColumns = 1;
        }
        int N = model.getColumnCount();
        for (int i = 0; i < N; ++i) {
            if (this.getTableColumn(i).isHidden()) continue;
            ++visibleColumns;
        }
        return visibleColumns;
    }

    void addPageLink(Element td, int page, String direction) {
        Element pg = this.factory.createElement("xpagenav");
        td.appendChild(pg);
        String id = DomUtils.randomId();
        pg.setAttribute("id", id);
        pg.setAttribute("page", Integer.toString(page + 1));
        pg.setAttribute("direction", direction);
        PageHandler h = new PageHandler(page);
        this.dispatcher.addRequestListener(id, null, h);
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean b) {
        this.closable = b;
    }

    public String getBorder() {
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setRenderId(String renderId) {
        this.renderId = renderId;
    }

    public String getRenderId() {
        return this.renderId;
    }

    Element tr() {
        Element xtr = this.factory.createElement(this.tr);
        this.root.appendChild(xtr);
        return xtr;
    }

    Element th(Element tr) {
        Element xth = this.factory.createElement(this.th);
        tr.appendChild(xth);
        return xth;
    }

    Element td(Element tr) {
        Element xtd = this.factory.createElement(this.td);
        tr.appendChild(xtd);
        return xtd;
    }

    void text(Element parent, String text) {
        Text t = this.factory.createTextNode(text);
        parent.appendChild(t);
    }

    public void setTr(String newTr) {
        this.tr = newTr;
    }

    public String getTr() {
        return this.tr;
    }

    public void setTd(String newTd) {
        this.td = newTd;
    }

    public String getTd() {
        return this.td;
    }

    public void setTh(String newTh) {
        this.th = newTh;
    }

    public String getTh() {
        return this.th;
    }

    PagedTableModel getPager() {
        return this.pager;
    }

    public TableColumn[] getTableColumns() {
        return this.tableColumns;
    }

    public void setError(String message) {
        this.error = message;
    }

    public boolean isColHeaders() {
        return this.colHeaders;
    }

    public void setColHeaders(boolean title) {
        this.colHeaders = title;
    }

    public boolean isReadOnly() {
        return this.selectionMgr.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.selectionMgr.setReadOnly(readOnly);
    }

    private class SortButtonHandler
    implements RequestListener {
        TableColumn tc;

        SortButtonHandler(TableColumn tc) {
            this.tc = tc;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TableComponent.this.validate(context);
            if (this.tc.getColumnIndex() == TableComponent.this.comparator.getColumnIndex()) {
                this.tc.setDescending(!this.tc.isDescending());
            } else {
                TableComponent.this.comparator.setColumn(this.tc);
            }
            TableComponent.this.sorter.sort(TableComponent.this.getRowComparator());
        }
    }

    class PageHandler
    implements RequestListener {
        int page;

        public PageHandler(int page) {
            this.page = page;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TableComponent.this.validate(context);
            TableComponent.this.pager.setCurrentPage(this.page);
        }
    }

    class PageSizeButtonHandler
    implements RequestListener {
        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TableComponent.this.validate(context);
            try {
                int ps = Integer.parseInt(context.getParameter(TableComponent.this.pageSizeInputId));
                if (ps < 1) {
                    ps = 1;
                }
                TableComponent.this.pager.setPageSize(ps);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class GotoButtonHandler
    implements RequestListener {
        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TableComponent.this.validate(context);
            try {
                int page = Integer.parseInt(context.getParameter(TableComponent.this.gotoInputId));
                TableComponent.this.pager.setCurrentPage(page - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class SelectButtonHandler
    implements RequestListener {
        SelectButtonHandler() {
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TableComponent.this.validate(context);
            if (TableComponent.this.isReadOnly()) {
                return;
            }
            SelectionModel sm = TableComponent.this.getSelectionModel();
            if (this.isFirstSelectableRowSelected()) {
                sm.clear();
                sm.fireSelectionChanged(context);
            } else {
                sm.clear();
                TableModel tm = TableComponent.this.getModel();
                int N = tm.getRowCount();
                for (int i = 0; i < N; ++i) {
                    TableRow row = tm.getRow(i);
                    if (!sm.isSelectable(row)) continue;
                    sm.add(row);
                }
                sm.fireSelectionChanged(context);
            }
        }

        boolean isFirstSelectableRowSelected() {
            SelectionModel sm = TableComponent.this.getSelectionModel();
            TableModel tm = TableComponent.this.getModel();
            int N = tm.getRowCount();
            for (int i = 0; i < N; ++i) {
                TableRow row = tm.getRow(i);
                if (!sm.isSelectable(row)) continue;
                return sm.contains(row);
            }
            return false;
        }
    }

    class CloseHandler
    implements RequestListener {
        CloseHandler() {
        }

        public void request(RequestContext context) throws Exception {
            TableComponent.this.setVisible(false);
        }
    }
}

