/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.statusline;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.utils.JDK13Utils;
import com.tonbeller.wcf.utils.XmlUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpSession;

public class StatusLine {
    public static final String WEBKEY = "wcfStatusLine";
    private String message;
    private Exception exception;
    private String exceptionType;
    private Resources resources = Resources.instance((Class)StatusLine.class);

    private StatusLine() {
    }

    public static synchronized StatusLine instance() {
        return StatusLine.instance(RequestContext.instance().getSession());
    }

    public static synchronized StatusLine instance(HttpSession session) {
        StatusLine sl = (StatusLine)session.getAttribute(WEBKEY);
        if (sl == null) {
            sl = new StatusLine();
            session.setAttribute(WEBKEY, (Object)sl);
        }
        return sl;
    }

    public void setMessage(String message) {
        this.message = message;
        this.exception = null;
    }

    public void setError(String exceptionType, Exception exception) {
        this.exceptionType = exceptionType;
        this.exception = exception;
    }

    public String getStatusHTML() {
        if (this.exception != null) {
            return this.getErrorHTML();
        }
        if (this.message != null) {
            return this.getMessageHTML();
        }
        return "";
    }

    public String getStatusText() {
        if (this.exception != null) {
            return this.getErrorText();
        }
        if (this.message != null) {
            return this.getMessageText();
        }
        return "";
    }

    public boolean isEmpty() {
        return this.exception == null && this.message == null;
    }

    public void clear() {
        this.exception = null;
        this.message = null;
    }

    private String getMessageHTML() {
        String s = XmlUtils.escapeXml(this.message);
        s = this.resources.getString("jsp.wcf.statusLine.message.format.html", (Object)s);
        return s;
    }

    private String getMessageText() {
        return this.resources.getString("jsp.wcf.statusLine.message.format.text", (Object)this.message);
    }

    private String getErrorHTML() {
        return this.getErrorFmt("jsp.wcf.statusLine.error.format.html");
    }

    private String getErrorText() {
        return this.getErrorFmt("jsp.wcf.statusLine.error.format.text");
    }

    private String getErrorFmt(String resKey) {
        Object[] args = new Object[3];
        Throwable t = this.unwind(this.exception);
        args[0] = this.exceptionType != null ? this.exceptionType : t.getClass().getName();
        args[1] = XmlUtils.escapeXml(t.getMessage());
        args[2] = this.getStackTrace(t);
        return this.resources.getString(resKey, args);
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private Throwable unwind(Throwable t) {
        Throwable x = JDK13Utils.getCause(t);
        while (x != null) {
            t = x;
            x = JDK13Utils.getCause(t);
        }
        return t;
    }
}

