/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.sqltable;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.sqltable.SqlTable;
import com.tonbeller.wcf.sqltable.SqlTableNestedTag;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;

public class SqlTableSortButtonTag
extends SqlTableNestedTag {
    String column;
    private static final Logger logger = Logger.getLogger((Class)SqlTableSortButtonTag.class);

    public int doStartTag() throws JspException {
        try {
            if (!this.isRenderActions()) {
                return 0;
            }
            SqlTable table = this.getTable();
            if (table.getOrderBy() == null) {
                throw new JspException("sqlTable must have the orderBy attribute set to use sort buttons");
            }
            RequestListener rl = this.getSortButtonHandler(table);
            String name = table.nextId();
            table.addRequestListener(name, null, rl);
            String imgSrc = this.getSortButtonImageSource(table);
            Object[] args = new Object[]{name, imgSrc};
            Resources res = this.getResources();
            String imgTag = res.getString("jsp.wcf.sqltable.sort.imgtag", args);
            this.pageContext.getOut().print(imgTag);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(null, (Throwable)e);
        }
        catch (MissingResourceException e) {
            logger.error(null, (Throwable)e);
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        return 0;
    }

    private RequestListener getSortButtonHandler(SqlTable table) {
        String currentColumn = table.getOrderBy();
        if (currentColumn.equals(this.column)) {
            return new SortButtonHandler(table, this.column, !table.isDescending());
        }
        return new SortButtonHandler(table, this.column, table.isDescending());
    }

    private String getSortButtonImageSource(SqlTable table) throws JspException {
        Resources res = this.getResources();
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        String currentColumn = table.getOrderBy();
        if (currentColumn == null) {
            throw new JspException("sqlTable must have the orderBy attribute set to use sort buttons");
        }
        if (currentColumn.equals(this.column)) {
            if (table.isDescending()) {
                return res.getString("jsp.wcf.sqltable.sortimg.cur.desc", (Object)contextPath);
            }
            return res.getString("jsp.wcf.sqltable.sortimg.cur.asc", (Object)contextPath);
        }
        if (table.isDescending()) {
            return res.getString("jsp.wcf.sqltable.sortimg.other.desc", (Object)contextPath);
        }
        return res.getString("jsp.wcf.sqltable.sortimg.other.asc", (Object)contextPath);
    }

    public void setColumn(String column) {
        this.column = column;
    }

    static class SortButtonHandler
    implements RequestListener {
        private String column;
        private boolean descending;
        private SqlTable table;

        SortButtonHandler(SqlTable table, String column, boolean descending) {
            this.table = table;
            this.column = column;
            this.descending = descending;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            this.table.setOrderBy(this.column);
            this.table.setDescending(this.descending);
        }
    }
}

