/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.component;

import com.tonbeller.wcf.bookmarks.BookmarkManager;
import com.tonbeller.wcf.bookmarks.Bookmarkable;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.component.RoleExprHolder;
import com.tonbeller.wcf.controller.RequestContext;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public abstract class ComponentTag
extends TagSupport {
    boolean objectCreated;
    boolean visible = true;
    boolean validate = false;
    String role;
    private static Logger logger = Logger.getLogger((Class)ComponentTag.class);

    protected abstract Component createComponent(RequestContext var1) throws Exception;

    public int doStartTag() throws JspException {
        logger.info((Object)this.id);
        try {
            this.objectCreated = false;
            HttpSession session = this.pageContext.getSession();
            if (session.getAttribute(this.getId()) == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("creating " + this.id));
                }
                Component comp = this.createComponent(RequestContext.instance());
                session.setAttribute(this.getId(), (Object)comp);
                this.objectCreated = true;
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            logger.error((Object)("trouble creating " + this.getId()), (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    public Component getComponent() {
        return (Component)this.pageContext.getSession().getAttribute(this.getId());
    }

    public boolean isObjectCreated() {
        return this.objectCreated;
    }

    public int doEndTag() throws JspException {
        logger.info((Object)this.id);
        if (this.objectCreated) {
            try {
                Component comp = this.getComponent();
                comp.initialize(RequestContext.instance());
                comp.setVisible(this.visible);
                if (comp instanceof ComponentSupport) {
                    ((ComponentSupport)comp).setAutoValidate(this.validate);
                }
                if (comp instanceof RoleExprHolder) {
                    ((RoleExprHolder)((Object)comp)).setRoleExpr(this.role);
                }
                if (comp instanceof Bookmarkable) {
                    BookmarkManager.instance(this.pageContext.getSession()).restoreAttributeState(this.id);
                }
            }
            catch (Exception e) {
                logger.error((Object)("trouble initializing " + this.getId()), (Throwable)e);
                throw new JspException(e.toString(), (Throwable)e);
            }
        }
        return super.doEndTag();
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }
}

