/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.BarChartCompiler;
import com.jaspersoft.sample.ofc.BarDataset;
import com.jaspersoft.sample.ofc.BarSeries;
import com.jaspersoft.sample.ofc.FillBarSeries;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillBarDataset
extends JRFillElementDataset {
    private final BarDataset dataset;
    private List<FillBarSeries> seriesList;
    private Set<String> seriesKeys = new LinkedHashSet<String>();
    private Set<String> categories = new LinkedHashSet<String>();
    private Map<Pair, Number> values = new LinkedHashMap<Pair, Number>();

    public FillBarDataset(BarDataset dataset, JRFillObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        this.dataset = dataset;
        List<BarSeries> datasetSeries = dataset.getSeries();
        this.seriesList = new ArrayList<FillBarSeries>(datasetSeries.size());
        for (BarSeries series : datasetSeries) {
            FillBarSeries fillSeries = new FillBarSeries(series);
            this.seriesList.add(fillSeries);
        }
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        for (FillBarSeries series : this.seriesList) {
            series.evaluate(calculator);
        }
    }

    protected void customIncrement() {
        for (FillBarSeries series : this.seriesList) {
            String seriesKey = series.getSeriesKey();
            String category = series.getCategory();
            Number value = series.getValue();
            this.seriesKeys.add(seriesKey);
            this.categories.add(category);
            this.values.put(new Pair((Object)seriesKey, (Object)category), value);
        }
    }

    protected void customInitialize() {
        this.seriesKeys.clear();
        this.categories.clear();
        this.values.clear();
    }

    public void collectExpressions(JRExpressionCollector collector) {
        BarChartCompiler.collectExpressions(this.dataset, collector);
    }

    public void finishDataset() {
        super.increment();
    }

    public Set<String> getSeriesKeys() {
        return this.seriesKeys;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Number getValue(String seriesKey, String category) {
        return this.values.get(new Pair((Object)seriesKey, (Object)category));
    }
}

