/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQuery {
    private final boolean generateFormattedSql;
    private boolean distinct;
    private final ClauseList select;
    private final ClauseList from;
    private final ClauseList where;
    private final ClauseList groupBy;
    private final ClauseList having;
    private final ClauseList orderBy;
    private final List<ClauseList> groupingSet;
    private final ClauseList groupingFunction;
    private final List<String> fromAliases;
    private final Dialect dialect;
    private final StringBuilder buf;
    private static final int SINGLE_QUOTE_SIZE = 10;
    private static final int DOUBLE_QUOTE_SIZE = 21;

    public SqlQuery(Dialect dialect, boolean formatted) {
        this.generateFormattedSql = formatted;
        this.select = new ClauseList(true);
        this.from = new ClauseList(true);
        this.groupingFunction = new ClauseList(false);
        this.where = new ClauseList(false);
        this.groupBy = new ClauseList(false);
        this.having = new ClauseList(false);
        this.orderBy = new ClauseList(false);
        this.fromAliases = new ArrayList<String>();
        this.buf = new StringBuilder(128);
        this.groupingSet = new ArrayList<ClauseList>();
        this.dialect = dialect;
    }

    public SqlQuery(Dialect dialect) {
        this(dialect, MondrianProperties.instance().GenerateFormattedSql.get());
    }

    public SqlQuery(DatabaseMetaData databaseMetaData) {
        this(Dialect.create(databaseMetaData));
    }

    public SqlQuery cloneEmpty() {
        return new SqlQuery(this.dialect);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean addFromQuery(String query, String alias, boolean failIfExists) {
        assert (alias != null);
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        return true;
    }

    boolean addFromTable(String schema, String table, String alias, String filter, boolean failIfExists) {
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.dialect.quoteIdentifier(this.buf, schema, table);
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        if (filter != null) {
            this.addWhere("(", filter, ")");
        }
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias, boolean failIfExists) {
        this.addFromQuery(sqlQuery.toString(), alias, failIfExists);
    }

    public boolean addFrom(MondrianDef.RelationOrJoin relation, String alias, boolean failIfExists) {
        if (relation instanceof MondrianDef.View) {
            MondrianDef.View view = (MondrianDef.View)relation;
            String viewAlias = alias == null ? view.getAlias() : alias;
            String sqlString = view.getCodeSet().chooseQuery(this.dialect);
            return this.addFromQuery(sqlString, viewAlias, false);
        }
        if (relation instanceof MondrianDef.InlineTable) {
            MondrianDef.Relation relation1 = RolapUtil.convertInlineTableToRelation((MondrianDef.InlineTable)relation, this.dialect);
            return this.addFrom(relation1, alias, failIfExists);
        }
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            String tableAlias = alias == null ? table.getAlias() : alias;
            return this.addFromTable(table.schema, table.name, tableAlias, table.getFilter(), failIfExists);
        }
        if (relation instanceof MondrianDef.Join) {
            boolean added;
            MondrianDef.Join join = (MondrianDef.Join)relation;
            String leftAlias = join.getLeftAlias();
            String rightAlias = join.getRightAlias();
            boolean addLeft = this.addFrom(join.left, leftAlias, failIfExists);
            boolean addRight = this.addFrom(join.right, rightAlias, failIfExists);
            boolean bl = added = addLeft || addRight;
            if (added) {
                this.buf.setLength(0);
                this.dialect.quoteIdentifier(this.buf, leftAlias, join.leftKey);
                this.buf.append(" = ");
                this.dialect.quoteIdentifier(this.buf, rightAlias, join.rightKey);
                this.addWhere(this.buf.toString());
            }
            return added;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    public void addSelect(String expression) {
        if (this.dialect.isAS400() || this.dialect.isDerby()) {
            this.addSelect(expression, null);
        } else {
            this.addSelect(expression, this.nextColumnAlias());
        }
    }

    public int getCurrentSelectListSize() {
        return this.select.size();
    }

    public String nextColumnAlias() {
        return "c" + this.select.size();
    }

    public void addSelect(String expression, String alias) {
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.dialect.quoteIdentifier(alias, this.buf);
        }
        this.select.add(this.buf.toString());
    }

    public void addWhere(String exprLeft, String exprMid, String exprRight) {
        int len = exprLeft.length() + exprMid.length() + exprRight.length();
        StringBuilder buf = new StringBuilder(len);
        buf.append(exprLeft);
        buf.append(exprMid);
        buf.append(exprRight);
        this.addWhere(buf.toString());
    }

    public void addWhere(String expression) {
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void addHaving(String expression) {
        this.having.add(expression);
    }

    public void addOrderBy(String expr, boolean ascending, boolean prepend, boolean nullable) {
        if (nullable && !this.dialect.isNullsCollateLast()) {
            expr = this.dialect.forceNullsCollateLast(expr);
        }
        expr = ascending ? expr + " ASC" : expr + " DESC";
        if (prepend) {
            this.orderBy.add(0, expr);
        } else {
            this.orderBy.add(expr);
        }
    }

    public String toString() {
        if (this.generateFormattedSql) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }
        this.buf.setLength(0);
        this.select.toBuffer(this.buf, this.distinct ? "select distinct " : "select ", ", ");
        this.buf.append(this.getGroupingFunction(""));
        this.from.toBuffer(this.buf, " from ", ", ");
        this.where.toBuffer(this.buf, " where ", " and ");
        if (this.hasGroupingSet()) {
            StringWriter stringWriter = new StringWriter();
            this.printGroupingSets(new PrintWriter(stringWriter), "");
            this.buf.append(stringWriter.toString());
        } else {
            this.groupBy.toBuffer(this.buf, " group by ", ", ");
        }
        this.having.toBuffer(this.buf, " having ", " and ");
        this.orderBy.toBuffer(this.buf, " order by ", ", ");
        return this.buf.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        this.select.print(pw, this.generateFormattedSql, prefix, this.distinct ? "select distinct " : "select ", ", ");
        pw.print(this.getGroupingFunction(prefix));
        this.from.print(pw, this.generateFormattedSql, prefix, "from ", ", ");
        this.where.print(pw, this.generateFormattedSql, prefix, "where ", " and ");
        if (this.hasGroupingSet()) {
            this.printGroupingSets(pw, prefix);
        } else {
            this.groupBy.print(pw, this.generateFormattedSql, prefix, "group by ", ", ");
        }
        this.having.print(pw, this.generateFormattedSql, prefix, "having ", " and ");
        this.orderBy.print(pw, this.generateFormattedSql, prefix, "order by ", ", ");
    }

    private String getGroupingFunction(String prefix) {
        if (!this.hasGroupingSet()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.groupingFunction.size(); ++i) {
            if (this.generateFormattedSql) {
                buf.append("    ").append(prefix);
            }
            buf.append(", ");
            buf.append("grouping(");
            buf.append((String)this.groupingFunction.get(i));
            buf.append(") as ");
            this.dialect.quoteIdentifier("g" + i, buf);
            if (!this.generateFormattedSql) continue;
            buf.append(Util.nl);
        }
        return buf.toString();
    }

    private void printGroupingSets(PrintWriter pw, String prefix) {
        pw.print(" group by grouping sets (");
        for (int i = 0; i < this.groupingSet.size(); ++i) {
            if (i > 0) {
                pw.print(",");
            }
            pw.print("(");
            this.groupingSet.get(i).print(pw, this.generateFormattedSql, prefix, "", ",", "", "");
            pw.print(")");
        }
        pw.print(")");
    }

    private boolean hasGroupingSet() {
        return !this.groupingSet.isEmpty();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public static SqlQuery newQuery(Connection jdbcConnection, String err) {
        try {
            Dialect dialect = Dialect.create(jdbcConnection.getMetaData());
            return new SqlQuery(dialect);
        }
        catch (SQLException e) {
            throw Util.newInternal(e, err);
        }
    }

    public static SqlQuery newQuery(DataSource dataSource, String err) {
        Connection jdbcConnection = null;
        try {
            jdbcConnection = dataSource.getConnection();
            Dialect dialect = Dialect.create(jdbcConnection.getMetaData());
            SqlQuery sqlQuery = new SqlQuery(dialect);
            return sqlQuery;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, err);
        }
        finally {
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public void addGroupingSet(List<String> groupingColumnsExpr) {
        ClauseList groupingList = new ClauseList(false);
        for (String columnExp : groupingColumnsExpr) {
            groupingList.add(columnExp);
        }
        this.groupingSet.add(groupingList);
    }

    public void addGroupingFunction(String columnExpr) {
        this.groupingFunction.add(columnExpr);
    }

    public static class CodeSet {
        private final Map<String, String> dialectCodes = new HashMap<String, String>();

        public String put(String dialect, String code) {
            return this.dialectCodes.put(dialect, code);
        }

        public String chooseQuery(Dialect dialect) {
            String best = dialect.getBestName();
            String bestCode = this.dialectCodes.get(best);
            if (bestCode != null) {
                return bestCode;
            }
            String genericCode = this.dialectCodes.get("generic");
            if (genericCode == null) {
                throw Util.newError("View has no 'generic' variant");
            }
            return genericCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Datatype {
        String{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteStringLiteral(buf, value);
            }
        }
        ,
        Numeric{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteNumericLiteral(buf, value);
            }

            public boolean isNumeric() {
                return true;
            }
        }
        ,
        Integer{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteNumericLiteral(buf, value);
            }

            public boolean isNumeric() {
                return true;
            }
        }
        ,
        Boolean{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteBooleanLiteral(buf, value);
            }
        }
        ,
        Date{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteDateLiteral(buf, value);
            }
        }
        ,
        Time{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteTimeLiteral(buf, value);
            }
        }
        ,
        Timestamp{

            public void quoteValue(StringBuilder buf, Dialect dialect, String value) {
                dialect.quoteTimestampLiteral(buf, value);
            }
        };


        public abstract void quoteValue(StringBuilder var1, Dialect var2, String var3);

        public boolean isNumeric() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dialect {
        private final String quoteIdentifierString;
        private final String productName;
        private final String productVersion;
        private final Set<List<Integer>> supportedResultSetTypes;
        private final boolean readOnly;
        private final int maxColumnNameLength;
        private static final int[] RESULT_SET_TYPE_VALUES = new int[]{1003, 1004, 1005};
        private static final int[] CONCURRENCY_VALUES = new int[]{1007, 1008};

        Dialect(String quoteIdentifierString, String productName, String productVersion, Set<List<Integer>> supportedResultSetTypes, boolean readOnly, int maxColumnNameLength) {
            this.quoteIdentifierString = quoteIdentifierString;
            this.productName = productName;
            this.productVersion = productVersion;
            this.supportedResultSetTypes = supportedResultSetTypes;
            this.readOnly = readOnly;
            this.maxColumnNameLength = maxColumnNameLength;
        }

        public static Dialect create(DatabaseMetaData databaseMetaData) {
            int maxColumnNameLength;
            boolean readOnly;
            String productVersion;
            String quoteIdentifierString;
            String productName;
            try {
                productName = databaseMetaData.getDatabaseProductName();
            }
            catch (SQLException e1) {
                throw Util.newInternal(e1, "while detecting database product");
            }
            try {
                quoteIdentifierString = databaseMetaData.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "while quoting identifier");
            }
            if (quoteIdentifierString == null || quoteIdentifierString.trim().length() == 0) {
                quoteIdentifierString = productName.toUpperCase().equals("MYSQL") ? "`" : null;
            }
            try {
                productVersion = databaseMetaData.getDatabaseProductVersion();
            }
            catch (SQLException e11) {
                throw Util.newInternal(e11, "while detecting database product version");
            }
            HashSet<List<Integer>> supports = new HashSet<List<Integer>>();
            try {
                for (int type : RESULT_SET_TYPE_VALUES) {
                    for (int concurrency : CONCURRENCY_VALUES) {
                        if (!databaseMetaData.supportsResultSetConcurrency(type, concurrency)) continue;
                        String driverName = databaseMetaData.getDriverName();
                        if (type != 1003 && driverName.equals("JDBC-ODBC Bridge (odbcjt32.dll)")) continue;
                        supports.add(new ArrayList<Integer>(Arrays.asList(type, concurrency)));
                    }
                }
            }
            catch (SQLException e11) {
                throw Util.newInternal(e11, "while detecting result set concurrency");
            }
            try {
                readOnly = databaseMetaData.isReadOnly();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "while detecting isReadOnly");
            }
            try {
                maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "while detecting maxColumnNameLength");
            }
            return new Dialect(quoteIdentifierString, productName, productVersion, supports, readOnly, maxColumnNameLength);
        }

        public static Dialect create(DataSource dataSource) {
            Connection conn = null;
            try {
                conn = dataSource.getConnection();
                Dialect dialect = Dialect.create(conn.getMetaData());
                return dialect;
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "Error while creating SQL dialect");
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {}
            }
        }

        public boolean isAccess() {
            return this.productName.equals("ACCESS");
        }

        public boolean isDerby() {
            return this.productName.trim().toUpperCase().equals("APACHE DERBY");
        }

        public boolean isCloudscape() {
            return this.productName.trim().toUpperCase().equals("DBMS:CLOUDSCAPE");
        }

        public boolean isDB2() {
            return this.productName.startsWith("DB2");
        }

        public boolean isAS400() {
            return this.productName.startsWith("DB2 UDB for AS/400");
        }

        public boolean isOldAS400() {
            if (!this.isAS400()) {
                return false;
            }
            String[] version_release = this.productVersion.split("\\.", 3);
            return "04".compareTo(version_release[0]) >= 0;
        }

        private String getBestName() {
            String best = this.isOracle() ? "oracle" : (this.isMSSQL() ? "mssql" : (this.isMySQL() ? "mysql" : (this.isAccess() ? "access" : (this.isPostgres() ? "postgres" : (this.isSybase() ? "sybase" : (this.isCloudscape() || this.isDerby() ? "derby" : (this.isDB2() ? "db2" : (this.isFirebird() ? "firebird" : (this.isInterbase() ? "interbase" : (this.isIngres() ? "ingres" : (this.isLucidDB() ? "luciddb" : (this.isTeradata() ? "teradata" : "generic"))))))))))));
            return best;
        }

        public String toUpper(String expr) {
            if (this.isDB2() || this.isAccess()) {
                return "UCASE(" + expr + ")";
            }
            return "UPPER(" + expr + ")";
        }

        public String caseWhenElse(String cond, String thenExpr, String elseExpr) {
            if (this.isAccess()) {
                return "IIF(" + cond + "," + thenExpr + "," + elseExpr + ")";
            }
            return "CASE WHEN " + cond + " THEN " + thenExpr + " ELSE " + elseExpr + " END";
        }

        public String quoteIdentifier(String val) {
            int size = val.length() + 10;
            StringBuilder buf = new StringBuilder(size);
            this.quoteIdentifier(val, buf);
            return buf.toString();
        }

        public void quoteIdentifier(String val, StringBuilder buf) {
            String q = this.getQuoteIdentifierString();
            if (q == null) {
                buf.append(val);
                return;
            }
            if (val.startsWith(q) && val.endsWith(q)) {
                buf.append(val);
                return;
            }
            int k = val.indexOf(46);
            if (k > 0) {
                String val1 = Util.replace(val.substring(0, k), q, q + q);
                String val2 = Util.replace(val.substring(k + 1), q, q + q);
                buf.append(q);
                buf.append(val1);
                buf.append(q);
                buf.append(".");
                buf.append(q);
                buf.append(val2);
                buf.append(q);
            } else {
                String val2 = Util.replace(val, q, q + q);
                buf.append(q);
                buf.append(val2);
                buf.append(q);
            }
        }

        public String quoteIdentifier(String qual, String name) {
            int size = name.length() + (qual == null ? 10 : qual.length() + 21);
            StringBuilder buf = new StringBuilder(size);
            this.quoteIdentifier(buf, qual, name);
            return buf.toString();
        }

        public void quoteIdentifier(StringBuilder buf, String ... names) {
            int nonNullNameCount = 0;
            for (String name : names) {
                if (name == null) continue;
                if (nonNullNameCount > 0) {
                    buf.append('.');
                }
                assert (name.length() > 0) : "name should probably be null, not empty";
                this.quoteIdentifier(name, buf);
                ++nonNullNameCount;
            }
        }

        public String getQuoteIdentifierString() {
            return this.quoteIdentifierString;
        }

        public void quoteStringLiteral(StringBuilder buf, String s) {
            Util.singleQuoteString(s, buf);
        }

        public void quoteNumericLiteral(StringBuilder buf, String value) {
            buf.append(value);
        }

        public void quoteBooleanLiteral(StringBuilder buf, String value) {
            if (!value.equalsIgnoreCase("TRUE") && !value.equalsIgnoreCase("FALSE")) {
                throw new NumberFormatException("Illegal BOOLEAN literal:  " + value);
            }
            buf.append(value);
        }

        public void quoteDateLiteral(StringBuilder buf, String value) {
            try {
                Date.valueOf(value);
            }
            catch (IllegalArgumentException ex) {
                throw new NumberFormatException("Illegal DATE literal:  " + value);
            }
            buf.append("DATE ");
            Util.singleQuoteString(value, buf);
        }

        public void quoteTimeLiteral(StringBuilder buf, String value) {
            try {
                Time.valueOf(value);
            }
            catch (IllegalArgumentException ex) {
                throw new NumberFormatException("Illegal TIME literal:  " + value);
            }
            buf.append("TIME ");
            Util.singleQuoteString(value, buf);
        }

        public void quoteTimestampLiteral(StringBuilder buf, String value) {
            try {
                Timestamp.valueOf(value);
            }
            catch (IllegalArgumentException ex) {
                throw new NumberFormatException("Illegal TIMESTAMP literal:  " + value);
            }
            buf.append("TIMESTAMP ");
            Util.singleQuoteString(value, buf);
        }

        public boolean isFirebird() {
            return this.productName.toUpperCase().indexOf("FIREBIRD") >= 0;
        }

        public boolean isInformix() {
            return this.productName.startsWith("Informix");
        }

        public boolean isIngres() {
            return this.productName.toUpperCase().equals("INGRES");
        }

        public boolean isInterbase() {
            return this.productName.equals("Interbase");
        }

        public boolean isLucidDB() {
            return this.productName.toUpperCase().equals("LUCIDDB");
        }

        public boolean isMSSQL() {
            return this.productName.toUpperCase().indexOf("SQL SERVER") >= 0;
        }

        public boolean isOracle() {
            return this.productName.equals("Oracle");
        }

        public boolean isPostgres() {
            return this.productName.toUpperCase().indexOf("POSTGRE") >= 0;
        }

        public boolean isMySQL() {
            return this.productName.toUpperCase().equals("MYSQL");
        }

        public boolean isSybase() {
            return this.productName.toUpperCase().indexOf("SYBASE") >= 0;
        }

        public boolean isTeradata() {
            return this.productName.toUpperCase().indexOf("TERADATA") >= 0;
        }

        public boolean requiresAliasForFromQuery() {
            return this.isMySQL() || this.isDerby() || this.isTeradata() || this.isPostgres();
        }

        protected boolean allowsAs() {
            return !this.isOracle() && !this.isSybase() && !this.isFirebird() && !this.isInterbase();
        }

        public boolean allowsFromQuery() {
            return (!this.isMySQL() || this.productVersion.compareTo("4.") >= 0) && !this.isOldAS400() && !this.isInformix() && !this.isSybase() && !this.isInterbase();
        }

        public boolean allowsCompoundCountDistinct() {
            return this.isMySQL();
        }

        public boolean allowsCountDistinct() {
            return !this.isAccess();
        }

        public boolean allowsMultipleCountDistinct() {
            return this.allowsCountDistinct() && !this.isDerby();
        }

        public boolean allowsMultipleDistinctSqlMeasures() {
            return this.allowsMultipleCountDistinct() && !this.isLucidDB();
        }

        public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
            if (this.isOracle()) {
                return this.generateInlineGeneric(columnNames, columnTypes, valueList, " from dual");
            }
            if (this.isAccess()) {
                return this.generateInlineGeneric(columnNames, columnTypes, valueList, " from `days` where `day` = 1");
            }
            if (this.isMySQL() || this.isIngres() || this.isTeradata()) {
                String fromClause = null;
                if (this.isTeradata() && valueList.size() > 1) {
                    fromClause = " FROM (SELECT 1 a) z ";
                }
                return this.generateInlineGeneric(columnNames, columnTypes, valueList, fromClause);
            }
            return this.generateInlineForAnsi("t", columnNames, columnTypes, valueList);
        }

        private String generateInlineGeneric(List<String> columnNames, List<String> columnTypes, List<String[]> valueList, String fromClause) {
            int i;
            StringBuilder buf = new StringBuilder();
            int columnCount = columnNames.size();
            assert (columnTypes.size() == columnCount);
            Integer[] maxLengths = new Integer[columnCount];
            if (this.isTeradata()) {
                for (i = 0; i < columnTypes.size(); ++i) {
                    String columnType = columnTypes.get(i);
                    Datatype datatype = Datatype.valueOf(columnType);
                    if (datatype != Datatype.String) continue;
                    int maxLen = -1;
                    for (String[] strings : valueList) {
                        if (strings[i] == null || strings[i].length() <= maxLen) continue;
                        maxLen = strings[i].length();
                    }
                    maxLengths[i] = maxLen;
                }
            }
            for (i = 0; i < valueList.size(); ++i) {
                if (i > 0) {
                    buf.append(" union all ");
                }
                String[] values = valueList.get(i);
                buf.append("select ");
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    if (j > 0) {
                        buf.append(", ");
                    }
                    String columnType = columnTypes.get(j);
                    String columnName = columnNames.get(j);
                    Datatype datatype = Datatype.valueOf(columnType);
                    Integer maxLength = maxLengths[j];
                    if (maxLength != null) {
                        buf.append("CAST(");
                        this.quote(buf, value, datatype);
                        buf.append(" AS VARCHAR(").append(maxLength).append("))");
                    } else {
                        this.quote(buf, value, datatype);
                    }
                    if (this.allowsAs()) {
                        buf.append(" as ");
                    } else {
                        buf.append(' ');
                    }
                    this.quoteIdentifier(columnName, buf);
                }
                if (fromClause == null) continue;
                buf.append(fromClause);
            }
            return buf.toString();
        }

        private String generateInlineForAnsi(String alias, List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
            int i;
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT * FROM (VALUES ");
            String[] castTypes = null;
            if (this.isDerby()) {
                castTypes = new String[columnNames.size()];
                for (i = 0; i < columnNames.size(); ++i) {
                    String columnType = columnTypes.get(i);
                    if (!columnType.equals("String")) continue;
                    castTypes[i] = Dialect.guessSqlType(columnType, valueList, i);
                }
            }
            for (i = 0; i < valueList.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                String[] values = valueList.get(i);
                buf.append("(");
                for (int j = 0; j < values.length; ++j) {
                    String value = values[j];
                    if (j > 0) {
                        buf.append(", ");
                    }
                    String columnType = columnTypes.get(j);
                    Datatype datatype = Datatype.valueOf(columnType);
                    if (value == null) {
                        String sqlType = Dialect.guessSqlType(columnType, valueList, j);
                        buf.append("CAST(NULL AS ").append(sqlType).append(")");
                        continue;
                    }
                    if (this.isDerby() && castTypes[j] != null) {
                        buf.append("CAST(");
                        this.quote(buf, value, datatype);
                        buf.append(" AS ").append(castTypes[j]).append(")");
                        continue;
                    }
                    this.quote(buf, value, datatype);
                }
                buf.append(")");
            }
            buf.append(") AS ");
            this.quoteIdentifier(alias, buf);
            buf.append(" (");
            for (int j = 0; j < columnNames.size(); ++j) {
                String columnName = columnNames.get(j);
                if (j > 0) {
                    buf.append(", ");
                }
                this.quoteIdentifier(columnName, buf);
            }
            buf.append(")");
            return buf.toString();
        }

        private boolean needsExponent(Object value, String valueString) {
            return this.isLucidDB() && value instanceof Double && !valueString.contains("E");
        }

        public void quote(StringBuilder buf, Object value, Datatype datatype) {
            if (value == null) {
                buf.append("null");
            } else {
                String valueString = value.toString();
                if (this.needsExponent(value, valueString)) {
                    valueString = valueString + "E0";
                }
                datatype.quoteValue(buf, this, valueString);
            }
        }

        private static String guessSqlType(String basicType, List<String[]> valueList, int column) {
            if (basicType.equals("String")) {
                int maxLen = 1;
                for (String[] values : valueList) {
                    String value = values[column];
                    if (value == null) continue;
                    maxLen = Math.max(maxLen, value.length());
                }
                return "VARCHAR(" + maxLen + ")";
            }
            return "INTEGER";
        }

        public boolean allowsDdl() {
            return !this.readOnly;
        }

        public boolean isNullsCollateLast() {
            return !this.isMySQL();
        }

        public String forceNullsCollateLast(String expr) {
            if (this.isMySQL()) {
                String addIsNull = "ISNULL(" + expr + "), ";
                expr = addIsNull + expr;
            }
            return expr;
        }

        public boolean supportsGroupByExpressions() {
            return !this.isDerby() && !this.isCloudscape();
        }

        public boolean supportsGroupingSets() {
            return this.isOracle() || this.isDB2() || this.isTeradata();
        }

        public boolean supportsUnlimitedValueList() {
            return this.isLucidDB();
        }

        public boolean requiresOrderByAlias() {
            return this.isMySQL() || this.isDB2() || this.isIngres();
        }

        public boolean allowsOrderByAlias() {
            return this.requiresOrderByAlias();
        }

        public boolean supportsMultiValueInExpr() {
            return this.isLucidDB() || this.isMySQL();
        }

        public boolean supportsResultSetConcurrency(int type, int concurrency) {
            return this.supportedResultSetTypes.contains(Arrays.asList(type, concurrency));
        }

        public String toString() {
            return this.productName;
        }

        public int getMaxColumnNameLength() {
            return this.maxColumnNameLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClauseList
    extends ArrayList<String> {
        private final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        @Override
        public boolean add(String element) {
            if (this.allowDups || !this.contains(element)) {
                return super.add(element);
            }
            return false;
        }

        void toBuffer(StringBuilder buf, String first, String sep) {
            boolean firstTime = true;
            for (String s : this) {
                if (firstTime) {
                    buf.append(first);
                    firstTime = false;
                } else {
                    buf.append(sep);
                }
                buf.append(s);
            }
        }

        void print(PrintWriter pw, boolean generateFormattedSql, String prefix, String first, String sep) {
            this.print(pw, generateFormattedSql, prefix, first, sep, "", "");
        }

        void print(PrintWriter pw, boolean generateFormattedSql, String prefix, String first, String sep, String suffix, String last) {
            String subprefix = prefix + "    ";
            boolean firstTime = true;
            for (String s : this) {
                if (firstTime) {
                    if (generateFormattedSql) {
                        pw.print(prefix);
                    }
                    pw.print(first);
                    firstTime = false;
                } else {
                    pw.print(sep);
                }
                if (generateFormattedSql) {
                    pw.println();
                    pw.print(subprefix);
                }
                pw.print(s);
                if (!generateFormattedSql) continue;
                pw.print(suffix);
            }
            pw.print(last);
            if (!firstTime && generateFormattedSql) {
                pw.println();
            }
        }
    }
}

