/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.ChildByNameConstraint;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.DefaultTupleConstraint;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintFactory {
    boolean enabled;
    private static final SqlConstraintFactory instance = new SqlConstraintFactory();

    private SqlConstraintFactory() {
        this.enabled = MondrianProperties.instance().EnableNativeNonEmpty.get();
    }

    public static SqlConstraintFactory instance() {
        return instance;
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(Evaluator context) {
        if (!this.enabled || !SqlContextConstraint.isValidContext(context)) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context) {
        boolean[] satisfied = new boolean[]{false};
        return this.getLevelMembersConstraint(context, null, satisfied);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context, Level[] levels, boolean[] satisfied) {
        if (context == null) {
            satisfied[0] = true;
            return DefaultTupleConstraint.instance();
        }
        if (!this.enabled) {
            satisfied[0] = false;
            return DefaultTupleConstraint.instance();
        }
        satisfied[0] = true;
        if (!SqlContextConstraint.isValidContext(context, false, levels)) {
            return DefaultTupleConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public MemberChildrenConstraint getChildByNameConstraint(RolapMember parent, Id.Segment childName) {
        if (!this.enabled || parent.getHierarchy().isRagged()) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new ChildByNameConstraint(childName);
    }

    public TupleConstraint getDescendantsConstraint(List<RolapMember> parentMembers, MemberChildrenConstraint mcc) {
        return new DescendantsConstraint(parentMembers, mcc);
    }
}

