/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.CacheCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapUtil;

public class RankFunDef
extends FunDefBase {
    static final boolean debug = false;
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Rank", "Rank(<Tuple>, <Set> [, <Calc Expression>])", "Returns the one-based rank of a tuple in a set.", new String[]{"fitx", "fitxn", "fimx", "fimxn"}, RankFunDef.class);

    public RankFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        switch (call.getArgCount()) {
            case 2: {
                return this.compileCall2(call, compiler);
            }
            case 3: {
                return this.compileCall3(call, compiler);
            }
        }
        throw Util.newInternal("invalid arg count " + call.getArgCount());
    }

    public Calc compileCall3(ResolvedFunCall call, ExpCompiler compiler) {
        Type type0 = call.getArg(0).getType();
        if (type0 instanceof TupleType) {
            TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
            ListCalc listCalc = compiler.compileList(call.getArg(1));
            Calc sortCalc = compiler.compileScalar(call.getArg(2), true);
            SortCalc sortedListCalc = new SortCalc(call, listCalc, sortCalc);
            ExpCacheDescriptor cacheDescriptor = new ExpCacheDescriptor(call, sortedListCalc, compiler.getEvaluator());
            return new Rank3TupleCalc(call, tupleCalc, sortCalc, cacheDescriptor);
        }
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        ListCalc listCalc = compiler.compileList(call.getArg(1));
        Calc sortCalc = compiler.compileScalar(call.getArg(2), true);
        SortCalc sortedListCalc = new SortCalc(call, listCalc, sortCalc);
        ExpCacheDescriptor cacheDescriptor = new ExpCacheDescriptor(call, sortedListCalc, compiler.getEvaluator());
        return new Rank3MemberCalc(call, memberCalc, sortCalc, cacheDescriptor);
    }

    public Calc compileCall2(ResolvedFunCall call, ExpCompiler compiler) {
        AbstractCalc listCalc;
        Exp listExp = call.getArg(1);
        ListCalc listCalc0 = compiler.compileList(listExp);
        RankedListCalc listCalc1 = new RankedListCalc(listCalc0);
        if (MondrianProperties.instance().EnableExpCache.get()) {
            ExpCacheDescriptor key = new ExpCacheDescriptor(listExp, listCalc1, compiler.getEvaluator());
            listCalc = new CacheCalc(listExp, key);
        } else {
            listCalc = listCalc1;
        }
        if (call.getArg(0).getType() instanceof TupleType) {
            TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
            return new Rank2TupleCalc(call, tupleCalc, listCalc);
        }
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new Rank2MemberCalc(call, memberCalc, listCalc);
    }

    static class RankedList {
        Map<Object, Integer> map = new HashMap<Object, Integer>();

        RankedList(List members) {
            for (int i = 0; i < members.size(); ++i) {
                Object key;
                Object o = members.get(i);
                if (o instanceof Member) {
                    key = o;
                } else if (o instanceof Member[]) {
                    key = Arrays.asList((Member[])o);
                } else {
                    throw Util.newInternal("bad member/tuple " + o);
                }
                Integer value = this.map.put(key, i);
                if (value == null) continue;
                this.map.put(key, value);
            }
        }

        int indexOf(Member m) {
            return this.indexOf((Object)m);
        }

        int indexOf(Member[] tuple) {
            return this.indexOf(Arrays.asList(tuple));
        }

        private int indexOf(Object o) {
            Integer integer = this.map.get(o);
            if (integer == null) {
                return -1;
            }
            return integer;
        }
    }

    private static class RankedListCalc
    extends AbstractCalc {
        private final ListCalc listCalc;

        public RankedListCalc(ListCalc listCalc) {
            super(new DummyExp(listCalc.getType()));
            this.listCalc = listCalc;
        }

        public Calc[] getCalcs() {
            return new Calc[]{this.listCalc};
        }

        public Object evaluate(Evaluator evaluator) {
            List members = this.listCalc.evaluateList(evaluator);
            if (members == null) {
                return null;
            }
            return new RankedList(members);
        }
    }

    private static class SortResult {
        final boolean empty;
        final Object[] values;

        public SortResult(boolean empty, Object[] values) {
            this.empty = empty;
            this.values = values;
            assert (values != null);
            assert (!empty || values.length == 0);
        }

        public void print(PrintWriter pw) {
            if (this.empty) {
                pw.println("SortResult: empty");
            } else {
                pw.println("SortResult {");
                for (int i = 0; i < this.values.length; ++i) {
                    if (i > 0) {
                        pw.println(",");
                    }
                    Object value = this.values[i];
                    pw.print(value);
                }
                pw.println("}");
            }
            pw.flush();
        }
    }

    private static class SortCalc
    extends AbstractCalc {
        private final ListCalc listCalc;
        private final Calc sortCalc;

        public SortCalc(Exp exp, ListCalc listExp, Calc sortExp) {
            super(exp);
            this.listCalc = listExp;
            this.sortCalc = sortExp;
        }

        public Calc[] getCalcs() {
            return new Calc[]{this.listCalc, this.sortCalc};
        }

        public boolean dependsOn(Dimension dimension) {
            return SortCalc.anyDependsButFirst(this.getCalcs(), dimension);
        }

        public Object evaluate(Evaluator evaluator) {
            Evaluator evaluator2 = evaluator.push();
            List members = (List)this.listCalc.evaluate(evaluator2);
            assert (members != null);
            if (members.isEmpty()) {
                return new SortResult(true, new Object[0]);
            }
            RuntimeException exception = null;
            Object[] values = new Object[members.size()];
            int j = 0;
            for (Object o : members) {
                if (o instanceof Member) {
                    Member member = (Member)o;
                    evaluator2.setContext(member);
                } else {
                    evaluator2.setContext((Member[])o);
                }
                Object value = this.sortCalc.evaluate(evaluator2);
                if (value instanceof RuntimeException) {
                    if (exception != null) continue;
                    exception = (RuntimeException)value;
                    continue;
                }
                if (Util.isNull(value)) continue;
                values[j++] = value;
            }
            if (exception != null) {
                return exception;
            }
            if (j < members.size()) {
                Object[] oldValues = values;
                values = new Object[j];
                System.arraycopy(oldValues, 0, values, 0, j);
            }
            FunUtil.sortValuesDesc(values);
            return new SortResult(false, values);
        }
    }

    private static class Rank3MemberCalc
    extends AbstractDoubleCalc {
        private final MemberCalc memberCalc;
        private final Calc sortCalc;
        private final ExpCacheDescriptor cacheDescriptor;

        public Rank3MemberCalc(ResolvedFunCall call, MemberCalc memberCalc, Calc sortCalc, ExpCacheDescriptor cacheDescriptor) {
            super(call, new Calc[]{memberCalc, sortCalc});
            this.memberCalc = memberCalc;
            this.sortCalc = sortCalc;
            this.cacheDescriptor = cacheDescriptor;
        }

        public double evaluateDouble(Evaluator evaluator) {
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                return 1.2345E-8;
            }
            Evaluator evaluator2 = evaluator.push(member);
            Object value = this.sortCalc.evaluate(evaluator2);
            if (value == RolapUtil.valueNotReadyException) {
                return 0.0;
            }
            SortResult sortResult = (SortResult)evaluator.getCachedResult(this.cacheDescriptor);
            if (sortResult.empty) {
                return 1.2345E-8;
            }
            if (value == Util.nullValue) {
                return sortResult.values.length + 1;
            }
            int j = FunUtil.searchValuesDesc(sortResult.values, value);
            if (j < 0) {
                j = -(j + 1);
                return j + 1;
            }
            if (j <= sortResult.values.length) {
                while (j > 0 && sortResult.values[j - 1].equals(value)) {
                    --j;
                }
            }
            return j + 1;
        }
    }

    private static class Rank3TupleCalc
    extends AbstractIntegerCalc {
        private final TupleCalc tupleCalc;
        private final Calc sortCalc;
        private final ExpCacheDescriptor cacheDescriptor;

        public Rank3TupleCalc(ResolvedFunCall call, TupleCalc tupleCalc, Calc sortCalc, ExpCacheDescriptor cacheDescriptor) {
            super(call, new Calc[]{tupleCalc, sortCalc});
            this.tupleCalc = tupleCalc;
            this.sortCalc = sortCalc;
            this.cacheDescriptor = cacheDescriptor;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member[] members = this.tupleCalc.evaluateTuple(evaluator);
            if (members == null) {
                return -2147483647;
            }
            assert (!FunUtil.tupleContainsNullMember(members));
            Evaluator evaluator2 = evaluator.push(members);
            Object value = this.sortCalc.evaluate(evaluator2);
            if (value instanceof RuntimeException) {
                return 0;
            }
            SortResult sortResult = (SortResult)evaluator.getCachedResult(this.cacheDescriptor);
            if (sortResult.empty) {
                return -2147483647;
            }
            if (value == Util.nullValue) {
                return sortResult.values.length + 1;
            }
            int j = FunUtil.searchValuesDesc(sortResult.values, value);
            if (j < 0) {
                j = -(j + 1);
                return j + 1;
            }
            if (j <= sortResult.values.length) {
                while (j > 0 && sortResult.values[j - 1].equals(value)) {
                    --j;
                }
            }
            return j + 1;
        }
    }

    private static class Rank2MemberCalc
    extends AbstractIntegerCalc {
        private final MemberCalc memberCalc;
        private final Calc listCalc;

        public Rank2MemberCalc(ResolvedFunCall call, MemberCalc memberCalc, Calc listCalc) {
            super(call, new Calc[]{memberCalc, listCalc});
            this.memberCalc = memberCalc;
            this.listCalc = listCalc;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                return -2147483647;
            }
            RankedList rankedList = (RankedList)this.listCalc.evaluate(evaluator);
            if (rankedList == null) {
                return 0;
            }
            int i = rankedList.indexOf(member);
            return i + 1;
        }
    }

    private static class Rank2TupleCalc
    extends AbstractIntegerCalc {
        private final TupleCalc tupleCalc;
        private final Calc listCalc;

        public Rank2TupleCalc(ResolvedFunCall call, TupleCalc tupleCalc, Calc listCalc) {
            super(call, new Calc[]{tupleCalc, listCalc});
            this.tupleCalc = tupleCalc;
            this.listCalc = listCalc;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member[] members = this.tupleCalc.evaluateTuple(evaluator);
            if (members == null) {
                return -2147483647;
            }
            assert (!FunUtil.tupleContainsNullMember(members));
            RankedList rankedList = (RankedList)this.listCalc.evaluate(evaluator);
            if (rankedList == null) {
                return 0;
            }
            int i = rankedList.indexOf(members);
            return i + 1;
        }
    }
}

