/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class HierarchizeFunDef
extends FunDefBase {
    static final String[] prePost = new String[]{"PRE", "POST"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Hierarchize", "Hierarchize(<Set>[, POST])", "Orders the members of a set in a hierarchy.", new String[]{"fxx", "fxxy"}, HierarchizeFunDef.class, prePost);

    public HierarchizeFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        String order = HierarchizeFunDef.getLiteralArg(call, 1, "PRE", prePost);
        final boolean post = order.equals("POST");
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public List evaluateList(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                FunUtil.hierarchize(list, post);
                return list;
            }
        };
    }
}

