/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractBooleanCalc;
import mondrian.calc.impl.AbstractDimensionCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.AbstractLevelCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.AddCalculatedMembersFunDef;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.AncestorFunDef;
import mondrian.olap.fun.AvgFunDef;
import mondrian.olap.fun.CacheFunDef;
import mondrian.olap.fun.CaseMatchFunDef;
import mondrian.olap.fun.CaseTestFunDef;
import mondrian.olap.fun.CastFunDef;
import mondrian.olap.fun.CoalesceEmptyFunDef;
import mondrian.olap.fun.CorrelationFunDef;
import mondrian.olap.fun.CountFunDef;
import mondrian.olap.fun.CovarianceFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.DescendantsFunDef;
import mondrian.olap.fun.DimensionCurrentMemberFunDef;
import mondrian.olap.fun.DistinctFunDef;
import mondrian.olap.fun.DrilldownLevelFunDef;
import mondrian.olap.fun.DrilldownLevelTopBottomFunDef;
import mondrian.olap.fun.DrilldownMemberFunDef;
import mondrian.olap.fun.ExceptFunDef;
import mondrian.olap.fun.ExistsFunDef;
import mondrian.olap.fun.ExtractFunDef;
import mondrian.olap.fun.FilterFunDef;
import mondrian.olap.fun.FormatFunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.GenerateFunDef;
import mondrian.olap.fun.HeadTailFunDef;
import mondrian.olap.fun.HierarchizeFunDef;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.HierarchyDimensionFunDef;
import mondrian.olap.fun.IifFunDef;
import mondrian.olap.fun.IntersectFunDef;
import mondrian.olap.fun.IsEmptyFunDef;
import mondrian.olap.fun.IsFunDef;
import mondrian.olap.fun.IsNullFunDef;
import mondrian.olap.fun.JavaFunDef;
import mondrian.olap.fun.LastPeriodsFunDef;
import mondrian.olap.fun.LeadLagFunDef;
import mondrian.olap.fun.LevelHierarchyFunDef;
import mondrian.olap.fun.LinReg;
import mondrian.olap.fun.MedianFunDef;
import mondrian.olap.fun.MemberHierarchyFunDef;
import mondrian.olap.fun.MemberLevelFunDef;
import mondrian.olap.fun.MinMaxFunDef;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.olap.fun.OpeningClosingPeriodFunDef;
import mondrian.olap.fun.OrderFunDef;
import mondrian.olap.fun.ParallelPeriodFunDef;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.fun.PercentileFunDef;
import mondrian.olap.fun.PeriodsToDateFunDef;
import mondrian.olap.fun.PropertiesFunDef;
import mondrian.olap.fun.RangeFunDef;
import mondrian.olap.fun.RankFunDef;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.fun.SetItemFunDef;
import mondrian.olap.fun.SetToStrFunDef;
import mondrian.olap.fun.StdevFunDef;
import mondrian.olap.fun.StdevPFunDef;
import mondrian.olap.fun.StrToSetFunDef;
import mondrian.olap.fun.StrToTupleFunDef;
import mondrian.olap.fun.SubsetFunDef;
import mondrian.olap.fun.SumFunDef;
import mondrian.olap.fun.ToggleDrillStateFunDef;
import mondrian.olap.fun.TopBottomCountFunDef;
import mondrian.olap.fun.TopBottomPercentSumFunDef;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.fun.TupleItemFunDef;
import mondrian.olap.fun.TupleToStrFunDef;
import mondrian.olap.fun.UnionFunDef;
import mondrian.olap.fun.ValidMeasureFunDef;
import mondrian.olap.fun.VarFunDef;
import mondrian.olap.fun.VarPFunDef;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.olap.fun.XtdFunDef;
import mondrian.olap.fun.extra.CalculatedChildFunDef;
import mondrian.olap.fun.extra.NthQuartileFunDef;
import mondrian.olap.fun.vba.Excel;
import mondrian.olap.fun.vba.Vba;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;
import org.eigenbase.xom.XOMUtil;

public class BuiltinFunTable
extends FunTableImpl {
    private static BuiltinFunTable instance;

    protected BuiltinFunTable() {
    }

    protected void defineFunctions() {
        this.defineReserved("NULL");
        this.define(new FunDefBase("", "", "Dummy function representing the empty expression", Syntax.Empty, 17, new int[0]){});
        this.define(HierarchyDimensionFunDef.instance);
        this.define(new FunDefBase("Dimension", "Returns the dimension that contains a specified hierarchy.", "pdd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                Dimension dimension = ((DimensionExpr)call.getArg(0)).getDimension();
                return new ConstantCalc(DimensionType.forDimension(dimension), dimension);
            }
        });
        this.define(new FunDefBase("Dimension", "Returns the dimension that contains a specified level.", "pdl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{levelCalc}){

                    public Dimension evaluateDimension(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getDimension();
                    }
                };
            }
        });
        this.define(new FunDefBase("Dimension", "Returns the dimension that contains a specified member.", "pdm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{memberCalc}){

                    public Dimension evaluateDimension(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getDimension();
                    }
                };
            }
        });
        this.define(new FunDefBase("Dimensions", "Returns the dimension whose zero-based position within the cube is specified by a numeric expression.", "fdn"){

            public Type getResultType(Validator validator, Exp[] args) {
                return DimensionType.Unknown;
            }

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{integerCalc}){

                    public Dimension evaluateDimension(Evaluator evaluator) {
                        int n = integerCalc.evaluateInteger(evaluator);
                        return this.nthDimension(evaluator, n);
                    }
                };
            }

            Dimension nthDimension(Evaluator evaluator, int n) {
                Cube cube = evaluator.getCube();
                Dimension[] dimensions = cube.getDimensions();
                if (n >= dimensions.length || n < 0) {
                    throw 6.newEvalException(this, "Index '" + n + "' out of bounds");
                }
                return dimensions[n];
            }
        });
        this.define(new FunDefBase("Dimensions", "Returns the dimension whose name is specified by a string.", "fdS"){

            public Type getResultType(Validator validator, Exp[] args) {
                return DimensionType.Unknown;
            }

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractDimensionCalc(call, new Calc[]{stringCalc}){

                    public Dimension evaluateDimension(Evaluator evaluator) {
                        String dimensionName = stringCalc.evaluateString(evaluator);
                        return this.findDimension(dimensionName, evaluator);
                    }
                };
            }

            Dimension findDimension(String s, Evaluator evaluator) {
                OlapElement o;
                if (s.indexOf("[") == -1) {
                    s = Util.quoteMdxIdentifier(s);
                }
                if ((o = evaluator.getSchemaReader().lookupCompound(evaluator.getCube(), 7.parseIdentifier(s), false, 2)) instanceof Dimension) {
                    return (Dimension)o;
                }
                if (o == null) {
                    throw 7.newEvalException(this, "Dimension '" + s + "' not found");
                }
                throw 7.newEvalException(this, "Dimensions(" + s + ") found " + o);
            }
        });
        this.define(LevelHierarchyFunDef.instance);
        this.define(MemberHierarchyFunDef.instance);
        this.define(MemberLevelFunDef.instance);
        this.define(new FunDefBase("Levels", "Returns the level whose position in a hierarchy is specified by a numeric expression.", "mlhn"){

            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getType();
                return LevelType.forType(argType);
            }

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                final IntegerCalc ordinalCalc = compiler.compileInteger(call.getArg(1));
                return new AbstractLevelCalc(call, new Calc[]{hierarchyCalc, ordinalCalc}){

                    public Level evaluateLevel(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        int ordinal = ordinalCalc.evaluateInteger(evaluator);
                        return this.nthLevel(hierarchy, ordinal);
                    }
                };
            }

            Level nthLevel(Hierarchy hierarchy, int n) {
                Level[] levels = hierarchy.getLevels();
                if (n >= levels.length || n < 0) {
                    throw 8.newEvalException(this, "Index '" + n + "' out of bounds");
                }
                return levels[n];
            }
        });
        this.define(new FunDefBase("Levels", "Returns the level whose name is specified by a string expression.", "mlhS"){

            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getType();
                return LevelType.forType(argType);
            }

            public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                final StringCalc nameCalc = compiler.compileString(call.getArg(1));
                return new AbstractLevelCalc(call, new Calc[]{hierarchyCalc, nameCalc}){

                    public Level evaluateLevel(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        String name = nameCalc.evaluateString(evaluator);
                        for (Level level : hierarchy.getLevels()) {
                            if (!level.getName().equals(name)) continue;
                            return level;
                        }
                        throw FunUtil.newEvalException(call.getFunDef(), "Level '" + name + "' not found in hierarchy '" + hierarchy + "'");
                    }
                };
            }
        });
        this.define(new FunDefBase("Levels", "Returns the level whose name is specified by a string expression.", "flS"){

            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getType();
                return LevelType.forType(argType);
            }

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractLevelCalc(call, new Calc[]{stringCalc}){

                    public Level evaluateLevel(Evaluator evaluator) {
                        String levelName = stringCalc.evaluateString(evaluator);
                        return this.findLevel(evaluator, levelName);
                    }
                };
            }

            Level findLevel(Evaluator evaluator, String s) {
                OlapElement o;
                Cube cube = evaluator.getCube();
                OlapElement olapElement = o = s.startsWith("[") ? evaluator.getSchemaReader().lookupCompound(cube, 10.parseIdentifier(s), false, 4) : null;
                if (o instanceof Level) {
                    return (Level)o;
                }
                if (o == null) {
                    throw 10.newEvalException(this, "Level '" + s + "' not found");
                }
                throw 10.newEvalException(this, "Levels('" + s + "') found " + o);
            }
        });
        this.define(IsEmptyFunDef.FunctionResolver);
        this.define(IsEmptyFunDef.PostfixResolver);
        this.define(IsNullFunDef.Resolver);
        this.define(IsFunDef.Resolver);
        this.define(AncestorFunDef.Resolver);
        this.define(new FunDefBase("Cousin", "<Member> Cousin(<Member>, <Ancestor Member>)", "Returns the member with the same relative position under <ancestor member> as the member specified.", "fmmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                final MemberCalc ancestorMemberCalc = compiler.compileMember(call.getArg(1));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc, ancestorMemberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member ancestorMember = ancestorMemberCalc.evaluateMember(evaluator);
                        return FunUtil.cousin(evaluator.getSchemaReader(), member, ancestorMember);
                    }
                };
            }
        });
        this.define(DimensionCurrentMemberFunDef.instance);
        this.define(HierarchyCurrentMemberFunDef.instance);
        this.define(new FunDefBase("DataMember", "Returns the system-generated data member that is associated with a nonleaf member of a dimension.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getDataMember();
                    }
                };
            }
        });
        this.define(new FunDefBase("DefaultMember", "Returns the default member of a dimension.", "pmd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{dimensionCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return evaluator.getSchemaReader().getHierarchyDefaultMember(dimension.getHierarchies()[0]);
                    }
                };
            }
        });
        this.define(new FunDefBase("DefaultMember", "Returns the default member of a hierarchy.", "pmh"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{hierarchyCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return evaluator.getSchemaReader().getHierarchyDefaultMember(hierarchy);
                    }
                };
            }
        });
        this.define(new FunDefBase("FirstChild", "Returns the first child of a member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.firstChild(evaluator, member);
                    }
                };
            }

            Member firstChild(Evaluator evaluator, Member member) {
                Member[] children = evaluator.getSchemaReader().getMemberChildren(member);
                return children.length == 0 ? member.getHierarchy().getNullMember() : children[0];
            }
        });
        this.define(new FunDefBase("FirstSibling", "Returns the first child of the parent of a member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.firstSibling(member, evaluator);
                    }
                };
            }

            Member firstSibling(Member member, Evaluator evaluator) {
                Member[] children;
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                if (parent == null) {
                    if (member.isNull()) {
                        return member;
                    }
                    children = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                } else {
                    children = schemaReader.getMemberChildren(parent);
                }
                return children[0];
            }
        });
        this.define(LeadLagFunDef.LagResolver);
        this.define(new FunDefBase("LastChild", "Returns the last child of a member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.lastChild(evaluator, member);
                    }
                };
            }

            Member lastChild(Evaluator evaluator, Member member) {
                Member[] children = evaluator.getSchemaReader().getMemberChildren(member);
                return children.length == 0 ? member.getHierarchy().getNullMember() : children[children.length - 1];
            }
        });
        this.define(new FunDefBase("LastSibling", "Returns the last child of the parent of a member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.firstSibling(member, evaluator);
                    }
                };
            }

            Member firstSibling(Member member, Evaluator evaluator) {
                Member[] children;
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                if (parent == null) {
                    if (member.isNull()) {
                        return member;
                    }
                    children = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                } else {
                    children = schemaReader.getMemberChildren(parent);
                }
                return children[children.length - 1];
            }
        });
        this.define(LeadLagFunDef.LeadResolver);
        this.define(new FunDefBase("Members", "Returns the member whose name is specified by a string expression.", "fmS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                throw new UnsupportedOperationException();
            }
        });
        this.define(new FunDefBase("NextMember", "Returns the next member in the level that contains a specified member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, 1);
                    }
                };
            }
        });
        this.define(OpeningClosingPeriodFunDef.OpeningPeriodResolver);
        this.define(OpeningClosingPeriodFunDef.ClosingPeriodResolver);
        this.define(ParallelPeriodFunDef.Resolver);
        this.define(new FunDefBase("Parent", "Returns the parent of a member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.memberParent(evaluator, member);
                    }
                };
            }

            Member memberParent(Evaluator evaluator, Member member) {
                Member parent = evaluator.getSchemaReader().getMemberParent(member);
                if (parent == null) {
                    parent = member.getHierarchy().getNullMember();
                }
                return parent;
            }
        });
        this.define(new FunDefBase("PrevMember", "Returns the previous member in the level that contains a specified member.", "pmm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, -1);
                    }
                };
            }
        });
        this.define(new FunDefBase("StrToMember", "Returns a member from a unique name String in MDX format.", "fmS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc memberNameCalc = compiler.compileString(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberNameCalc}){

                    public Member evaluateMember(Evaluator evaluator) {
                        String memberName = memberNameCalc.evaluateString(evaluator);
                        return this.strToMember(evaluator, memberName);
                    }
                };
            }

            Member strToMember(Evaluator evaluator, String memberName) {
                Cube cube = evaluator.getCube();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                List<Id.Segment> uniqueNameParts = Util.parseIdentifier(memberName);
                return (Member)schemaReader.lookupCompound(cube, uniqueNameParts, true, 6);
            }
        });
        this.define(ValidMeasureFunDef.instance);
        this.define(AggregateFunDef.resolver);
        this.define(new MultiResolver("$AggregateChildren", "$AggregateChildren(<Hierarchy>)", "Equivalent to 'Aggregate(<Hierarchy>.CurrentMember.Children); for internal use.", new String[]{"Inh"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(dummyFunDef){

                    public void unparse(Exp[] args, PrintWriter pw) {
                        pw.print(this.getName());
                        pw.print("(");
                        args[0].unparse(pw);
                        pw.print(")");
                    }

                    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                        final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                        final ValueCalc valueCalc = new ValueCalc(call);
                        return new GenericCalc(call){

                            public Object evaluate(Evaluator evaluator) {
                                Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                                return this.aggregateChildren(evaluator, hierarchy, valueCalc);
                            }

                            public Calc[] getCalcs() {
                                return new Calc[]{hierarchyCalc, valueCalc};
                            }
                        };
                    }

                    Object aggregateChildren(Evaluator evaluator, Hierarchy hierarchy, Calc valueFunCall) {
                        Member member = evaluator.getParent().getContext(hierarchy.getDimension());
                        List members = (List)member.getPropertyValue(Property.CONTRIBUTING_CHILDREN.name);
                        Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
                        if (aggregator == null) {
                            throw FunUtil.newEvalException(null, "Could not find an aggregator in the current evaluation context");
                        }
                        Aggregator rollup = aggregator.getRollup();
                        if (rollup == null) {
                            throw FunUtil.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
                        }
                        return rollup.aggregate(evaluator.push(), members, valueFunCall);
                    }
                };
            }
        });
        this.define(AvgFunDef.Resolver);
        this.define(CorrelationFunDef.Resolver);
        this.define(CountFunDef.Resolver);
        this.define(new FunDefBase("Count", "Returns the number of tuples in a set including empty cells.", "pnx"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final ListCalc memberListCalc = compiler.compileList(call.getArg(0));
                return new AbstractIntegerCalc(call, new Calc[]{memberListCalc}){

                    public int evaluateInteger(Evaluator evaluator) {
                        List memberList = memberListCalc.evaluateList(evaluator);
                        return FunUtil.count(evaluator, memberList, true);
                    }
                };
            }
        });
        this.define(CovarianceFunDef.CovarianceResolver);
        this.define(CovarianceFunDef.CovarianceNResolver);
        this.define(IifFunDef.STRING_INSTANCE);
        this.define(IifFunDef.NUMERIC_INSTANCE);
        this.define(IifFunDef.TUPLE_INSTANCE);
        this.define(IifFunDef.BOOLEAN_INSTANCE);
        this.define(IifFunDef.MEMBER_INSTANCE);
        this.define(IifFunDef.LEVEL_INSTANCE);
        this.define(IifFunDef.HIERARCHY_INSTANCE);
        this.define(IifFunDef.DIMENSION_INSTANCE);
        this.define(IifFunDef.SET_INSTANCE);
        this.define(new FunDefBase("InStr", "Returns the position of the first occurrence of one string within another. Implements very basic form of InStr", "fnSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc stringCalc1 = compiler.compileString(call.getArg(0));
                final StringCalc stringCalc2 = compiler.compileString(call.getArg(1));
                return new AbstractIntegerCalc(call, new Calc[]{stringCalc1, stringCalc2}){

                    public int evaluateInteger(Evaluator evaluator) {
                        String value = stringCalc1.evaluateString(evaluator);
                        String pattern = stringCalc2.evaluateString(evaluator);
                        return value.indexOf(pattern) + 1;
                    }
                };
            }
        });
        this.define(LinReg.InterceptResolver);
        this.define(LinReg.PointResolver);
        this.define(LinReg.R2Resolver);
        this.define(LinReg.SlopeResolver);
        this.define(LinReg.VarianceResolver);
        this.define(MinMaxFunDef.MaxResolver);
        this.define(MinMaxFunDef.MinResolver);
        this.define(MedianFunDef.Resolver);
        this.define(PercentileFunDef.Resolver);
        this.define(new FunDefBase("Ordinal", "Returns the zero-based ordinal value associated with a level.", "pnl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractIntegerCalc(call, new Calc[]{levelCalc}){

                    public int evaluateInteger(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getDepth();
                    }
                };
            }
        });
        this.define(RankFunDef.Resolver);
        this.define(CacheFunDef.Resolver);
        this.define(StdevFunDef.StdevResolver);
        this.define(StdevFunDef.StddevResolver);
        this.define(StdevPFunDef.StdevpResolver);
        this.define(StdevPFunDef.StddevpResolver);
        this.define(SumFunDef.Resolver);
        this.define(new FunDefBase("Value", "Returns the value of a measure.", "pnm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new GenericCalc(call){

                    public Object evaluate(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member old = evaluator.setContext(member);
                        Object value = evaluator.evaluateCurrent();
                        evaluator.setContext(old);
                        return value;
                    }

                    public boolean dependsOn(Dimension dimension) {
                        if (super.dependsOn(dimension)) {
                            return true;
                        }
                        return !memberCalc.getType().usesDimension(dimension, true);
                    }

                    public Calc[] getCalcs() {
                        return new Calc[]{memberCalc};
                    }
                };
            }
        });
        this.define(VarFunDef.VarResolver);
        this.define(VarFunDef.VarianceResolver);
        this.define(VarPFunDef.VariancePResolver);
        this.define(VarPFunDef.VarPResolver);
        this.define(AddCalculatedMembersFunDef.resolver);
        this.define(new FunDefBase("Ascendants", "Returns the set of the ascendants of a specified member.", "fxm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{memberCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.ascendants(member);
                    }
                };
            }

            List<Member> ascendants(Member member) {
                if (member.isNull()) {
                    return Collections.emptyList();
                }
                Object[] members = member.getAncestorMembers();
                ArrayList<Member> result = new ArrayList<Member>(members.length + 1);
                result.add(member);
                XOMUtil.addAll(result, (Object[])members);
                return result;
            }
        });
        this.define(TopBottomCountFunDef.BottomCountResolver);
        this.define(TopBottomPercentSumFunDef.BottomPercentResolver);
        this.define(TopBottomPercentSumFunDef.BottomSumResolver);
        this.define(TopBottomCountFunDef.TopCountResolver);
        this.define(TopBottomPercentSumFunDef.TopPercentResolver);
        this.define(TopBottomPercentSumFunDef.TopSumResolver);
        this.define(new FunDefBase("Children", "Returns the children of a member.", "pxm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{memberCalc}, false){

                    public List evaluateList(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member[] children = FunUtil.getNonEmptyMemberChildren(evaluator, member);
                        return Arrays.asList(children);
                    }
                };
            }
        });
        this.define(CrossJoinFunDef.Resolver);
        this.define(NonEmptyCrossJoinFunDef.Resolver);
        this.define(CrossJoinFunDef.StarResolver);
        this.define(DescendantsFunDef.Resolver);
        this.define(DistinctFunDef.instance);
        this.define(DrilldownLevelFunDef.Resolver);
        this.define(DrilldownLevelTopBottomFunDef.DrilldownLevelTopResolver);
        this.define(DrilldownLevelTopBottomFunDef.DrilldownLevelBottomResolver);
        this.define(DrilldownMemberFunDef.Resolver);
        this.define(ExceptFunDef.Resolver);
        this.define(ExistsFunDef.resolver);
        this.define(ExtractFunDef.Resolver);
        this.define(FilterFunDef.instance);
        this.define(GenerateFunDef.ListResolver);
        this.define(GenerateFunDef.StringResolver);
        this.define(HeadTailFunDef.HeadResolver);
        this.define(HierarchizeFunDef.Resolver);
        this.define(IntersectFunDef.resolver);
        this.define(LastPeriodsFunDef.Resolver);
        this.define(new FunDefBase("Members", "Returns the set of members in a dimension.", "pxd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{dimensionCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return FunUtil.dimensionMembers(dimension, evaluator, false);
                    }
                };
            }
        });
        this.define(new FunDefBase("AllMembers", "Returns a set that contains all members, including calculated members, of the specified dimension.", "pxd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{dimensionCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return FunUtil.dimensionMembers(dimension, evaluator, true);
                    }
                };
            }
        });
        this.define(new FunDefBase("Members", "Returns the set of members in a hierarchy.", "pxh"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{hierarchyCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return FunUtil.hierarchyMembers(hierarchy, evaluator, false);
                    }
                };
            }
        });
        this.define(new FunDefBase("AllMembers", "Returns a set that contains all members, including calculated members, of the specified hierarchy.", "pxh"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{hierarchyCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return FunUtil.hierarchyMembers(hierarchy, evaluator, true);
                    }
                };
            }
        });
        this.define(new FunDefBase("Members", "Returns the set of members in a level.", "pxl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{levelCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return FunUtil.levelMembers(level, evaluator, false);
                    }
                };
            }
        });
        this.define(new FunDefBase("AllMembers", "Returns a set that contains all members, including calculated members, of the specified level.", "pxl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{levelCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return FunUtil.levelMembers(level, evaluator, true);
                    }
                };
            }
        });
        this.define(XtdFunDef.MtdResolver);
        this.define(OrderFunDef.Resolver);
        this.define(PeriodsToDateFunDef.Resolver);
        this.define(XtdFunDef.QtdResolver);
        this.define(new FunDefBase("StripCalculatedMembers", "Removes calculated members from a set.", "fxx"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{listCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        List list = listCalc.evaluateList(evaluator);
                        FunUtil.removeCalculatedMembers(list);
                        return list;
                    }
                };
            }
        });
        this.define(new FunDefBase("Siblings", "Returns the siblings of a specified member, including the member itself.", "pxm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{memberCalc}){

                    public List evaluateList(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.memberSiblings(member, evaluator);
                    }
                };
            }

            List memberSiblings(Member member, Evaluator evaluator) {
                if (member.isNull()) {
                    return Collections.EMPTY_LIST;
                }
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                Member[] siblings = parent == null ? schemaReader.getHierarchyRootMembers(member.getHierarchy()) : schemaReader.getMemberChildren(parent);
                return Arrays.asList(siblings);
            }
        });
        this.define(StrToSetFunDef.Resolver);
        this.define(SubsetFunDef.Resolver);
        this.define(HeadTailFunDef.TailResolver);
        this.define(ToggleDrillStateFunDef.Resolver);
        this.define(UnionFunDef.Resolver);
        this.define(VisualTotalsFunDef.Resolver);
        this.define(XtdFunDef.WtdResolver);
        this.define(XtdFunDef.YtdResolver);
        this.define(RangeFunDef.instance);
        this.define(SetFunDef.Resolver);
        this.define(FormatFunDef.Resolver);
        this.define(new FunDefBase("Caption", "Returns the caption of a dimension.", "pSd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{dimensionCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return dimension.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "Returns the caption of a hierarchy.", "pSh"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{hierarchyCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return hierarchy.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "Returns the caption of a level.", "pSl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{levelCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Caption", "Returns the caption of a member.", "pSm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getCaption();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "Returns the name of a dimension.", "pSd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{dimensionCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return dimension.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "Returns the name of a hierarchy.", "pSh"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{hierarchyCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return hierarchy.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "Returns the name of a level.", "pSl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{levelCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getName();
                    }
                };
            }
        });
        this.define(new FunDefBase("Name", "Returns the name of a member.", "pSm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getName();
                    }
                };
            }
        });
        this.define(SetToStrFunDef.instance);
        this.define(TupleToStrFunDef.instance);
        this.define(new FunDefBase("UniqueName", "Returns the unique name of a dimension.", "pSd"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{dimensionCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return dimension.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "Returns the unique name of a hierarchy.", "pSh"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{hierarchyCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return hierarchy.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "Returns the unique name of a level.", "pSl"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{levelCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getUniqueName();
                    }
                };
            }
        });
        this.define(new FunDefBase("UniqueName", "Returns the unique name of a member.", "pSm"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getUniqueName();
                    }
                };
            }
        });
        this.define(SetItemFunDef.intResolver);
        this.define(SetItemFunDef.stringResolver);
        this.define(TupleItemFunDef.instance);
        this.define(StrToTupleFunDef.Resolver);
        this.define(TupleFunDef.Resolver);
        this.define(CoalesceEmptyFunDef.Resolver);
        this.define(CaseTestFunDef.Resolver);
        this.define(CaseMatchFunDef.Resolver);
        this.define(PropertiesFunDef.Resolver);
        this.define(new ParameterFunDef.ParameterResolver());
        this.define(new ParameterFunDef.ParamRefResolver());
        this.define(new FunDefBase("+", "Adds two numbers.", "innn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8) {
                            if (v1 == 1.2345E-8) {
                                return 1.2345E-8;
                            }
                            return v1;
                        }
                        if (v1 == 1.2345E-8) {
                            return v0;
                        }
                        return v0 + v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("-", "Subtracts two numbers.", "innn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8) {
                            if (v1 == 1.2345E-8) {
                                return 1.2345E-8;
                            }
                            return -v1;
                        }
                        if (v1 == 1.2345E-8) {
                            return v0;
                        }
                        return v0 - v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("*", "Multiplies two numbers.", "innn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return 1.2345E-8;
                        }
                        return v0 * v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("/", "Divides two numbers.", "innn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                boolean isNullDenominatorProducesNull = MondrianProperties.instance().NullDenominatorProducesNull.get();
                if (!isNullDenominatorProducesNull) {
                    return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                        public double evaluateDouble(Evaluator evaluator) {
                            double v0 = calc0.evaluateDouble(evaluator);
                            double v1 = calc1.evaluateDouble(evaluator);
                            if (v0 == 1.2345E-8) {
                                return 1.2345E-8;
                            }
                            if (v1 == 1.2345E-8) {
                                return Double.POSITIVE_INFINITY;
                            }
                            return v0 / v1;
                        }
                    };
                }
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return 1.2345E-8;
                        }
                        return v0 / v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("-", "Returns the negative of a number.", "Pnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc = compiler.compileDouble(call.getArg(0));
                return new AbstractDoubleCalc(call, new Calc[]{calc}){

                    public double evaluateDouble(Evaluator evaluator) {
                        double v = calc.evaluateDouble(evaluator);
                        if (v == 1.2345E-8) {
                            return 1.2345E-8;
                        }
                        return -v;
                    }
                };
            }
        });
        this.define(new FunDefBase("||", "Concatenates two strings.", "iSSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractStringCalc(call, new Calc[]{calc0, calc1}){

                    public String evaluateString(Evaluator evaluator) {
                        String s0 = calc0.evaluateString(evaluator);
                        String s1 = calc1.evaluateString(evaluator);
                        return s0 + s1;
                    }
                };
            }
        });
        this.define(new FunDefBase("AND", "Returns the conjunction of two conditions.", "ibbb"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        boolean b0 = calc0.evaluateBoolean(evaluator);
                        if (!evaluator.isEvalAxes() && !b0) {
                            return false;
                        }
                        boolean b1 = calc1.evaluateBoolean(evaluator);
                        return b0 && b1;
                    }
                };
            }
        });
        this.define(new FunDefBase("OR", "Returns the disjunction of two conditions.", "ibbb"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        boolean b0 = calc0.evaluateBoolean(evaluator);
                        if (!evaluator.isEvalAxes() && b0) {
                            return true;
                        }
                        boolean b1 = calc1.evaluateBoolean(evaluator);
                        return b0 || b1;
                    }
                };
            }
        });
        this.define(new FunDefBase("XOR", "Returns whether two conditions are mutually exclusive.", "ibbb"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        boolean b1;
                        boolean b0 = calc0.evaluateBoolean(evaluator);
                        return b0 != (b1 = calc1.evaluateBoolean(evaluator));
                    }
                };
            }
        });
        this.define(new FunDefBase("NOT", "Returns the negation of a condition.", "Pbb"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc = compiler.compileBoolean(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{calc}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        return !calc.evaluateBoolean(evaluator);
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "Returns whether two expressions are equal.", "ibSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.equals(b1);
                    }
                };
            }
        });
        this.define(new FunDefBase("=", "Returns whether two expressions are equal.", "ibnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 == v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "Returns whether two expressions are not equal.", "ibSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return !b0.equals(b1);
                    }
                };
            }
        });
        this.define(new FunDefBase("<>", "Returns whether two expressions are not equal.", "ibnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 != v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("<", "Returns whether an expression is less than another.", "ibnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 < v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("<", "Returns whether an expression is less than another.", "ibSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) < 0;
                    }
                };
            }
        });
        this.define(new FunDefBase("<=", "Returns whether an expression is less than or equal to another.", "ibnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 <= v1;
                    }
                };
            }
        });
        this.define(new FunDefBase("<=", "Returns whether an expression is less than or equal to another.", "ibSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) <= 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">", "Returns whether an expression is greater than another.", "ibnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 > v1;
                    }
                };
            }
        });
        this.define(new FunDefBase(">", "Returns whether an expression is greater than another.", "ibSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) > 0;
                    }
                };
            }
        });
        this.define(new FunDefBase(">=", "Returns whether an expression is greater than or equal to another.", "ibnn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 >= v1;
                    }
                };
            }
        });
        this.define(new FunDefBase(">=", "Returns whether an expression is greater than or equal to another.", "ibSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) >= 0;
                    }
                };
            }
        });
        this.define(NthQuartileFunDef.FirstQResolver);
        this.define(NthQuartileFunDef.ThirdQResolver);
        this.define(CalculatedChildFunDef.instance);
        this.define(CastFunDef.Resolver);
        this.define(new FunDefBase("UCase", "Returns a string that has been converted to uppercase", "fSS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final Locale locale = compiler.getEvaluator().getConnectionLocale();
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{stringCalc}){

                    public String evaluateString(Evaluator evaluator) {
                        String value = stringCalc.evaluateString(evaluator);
                        return value.toUpperCase(locale);
                    }
                };
            }
        });
        this.define(new FunDefBase("Len", "Returns the number of characters in a string", "fnS"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractIntegerCalc(call, new Calc[]{stringCalc}){

                    public int evaluateInteger(Evaluator evaluator) {
                        String value = stringCalc.evaluateString(evaluator);
                        return value.length();
                    }
                };
            }
        });
        for (FunDef funDef : JavaFunDef.scan(Vba.class)) {
            this.define(funDef);
        }
        for (FunDef funDef : JavaFunDef.scan(Excel.class)) {
            this.define(funDef);
        }
    }

    public static BuiltinFunTable instance() {
        if (instance == null) {
            instance = new BuiltinFunTable();
            instance.init();
        }
        return instance;
    }
}

