/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.QueryPrintWriter;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Category;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.Pair;
import mondrian.util.UnionIterator;
import mondrian.util.UtilCompatible;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.log4j.Logger;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util
extends XOMUtil {
    public static final String nl = System.getProperty("line.separator");
    private static final Logger LOGGER = Logger.getLogger(Util.class);
    public static final Object nullValue = new Double(1.2345E-8);
    public static final Object EmptyValue = new Double(-1.2345E-8);
    private static long databaseMillis = 0L;
    private static final Random metaRandom = Util.createRandom(MondrianProperties.instance().TestSeed.get());
    public static final boolean PreJdk15 = System.getProperty("java.version").startsWith("1.4");
    public static final int JdbcVersion = System.getProperty("java.version").compareTo("1.6") >= 0 ? 4 : 3;
    public static final boolean Retrowoven = Access.class.getSuperclass().getName().equals("com.rc.retroweaver.runtime.Enum_");
    private static final UtilCompatible compatible;

    public static boolean isNull(Object o) {
        return o == null || o == nullValue;
    }

    public static <T> boolean isSorted(List<T> list) {
        Object prev = null;
        for (T t : list) {
            if (prev != null && ((Comparable)prev).compareTo(t) >= 0) {
                return false;
            }
            prev = t;
        }
        return true;
    }

    public static String mdxEncodeString(String st) {
        StringBuilder retString = new StringBuilder(st.length() + 20);
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (c == ']' && i + 1 < st.length() && st.charAt(i + 1) != '.') {
                retString.append(']');
            }
            retString.append(c);
        }
        return retString.toString();
    }

    public static String quoteForMdx(String val) {
        StringBuilder buf = new StringBuilder(val.length() + 20);
        buf.append("\"");
        String s0 = Util.replace(val, "\"", "\"\"");
        buf.append(s0);
        buf.append("\"");
        return buf.toString();
    }

    public static String quoteMdxIdentifier(String id) {
        StringBuilder buf = new StringBuilder(id.length() + 20);
        Util.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    public static void quoteMdxIdentifier(String id, StringBuilder buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Util.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    public static String quoteMdxIdentifier(List<Id.Segment> ids) {
        StringBuilder sb = new StringBuilder(64);
        Util.quoteMdxIdentifier(ids, sb);
        return sb.toString();
    }

    public static void quoteMdxIdentifier(List<Id.Segment> ids, StringBuilder sb) {
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(ids.get(i).toString());
        }
    }

    public static boolean equals(Object s, Object t) {
        return s == null ? t == null : s.equals(t);
    }

    public static boolean equals(String s, String t) {
        return Util.equals((Object)s, (Object)t);
    }

    public static boolean equalName(String s, String t) {
        if (s == null) {
            return t == null;
        }
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        return caseSensitive ? s.equals(t) : s.equalsIgnoreCase(t);
    }

    public static boolean equal(String s, String t, boolean matchCase) {
        return matchCase ? s.equals(t) : s.equalsIgnoreCase(t);
    }

    public static int caseSensitiveCompareName(String s, String t) {
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        if (caseSensitive) {
            return s.compareTo(t);
        }
        int v = s.compareToIgnoreCase(t);
        return v == 0 ? s.compareTo(t) : v;
    }

    public static int compareName(String s, String t) {
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        return caseSensitive ? s.compareTo(t) : s.compareToIgnoreCase(t);
    }

    public static String normalizeName(String s) {
        return MondrianProperties.instance().CaseSensitive.get() ? s : s.toUpperCase();
    }

    public static int compareKey(Object k1, Object k2) {
        if (k1 instanceof Boolean) {
            k1 = k1.toString();
            k2 = k2.toString();
        }
        return ((Comparable)k1).compareTo(k2);
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 20);
        int start = 0;
        char[] chars = s.toCharArray();
        int step = find.length();
        if (step == 0) {
            sb.append(s);
            Util.replace(sb, 0, find, replace);
        } else {
            while (true) {
                sb.append(chars, start, found - start);
                if (found == s.length()) break;
                sb.append(replace);
                start = found + step;
                if ((found = s.indexOf(find, start)) != -1) continue;
                found = s.length();
            }
        }
        return sb.toString();
    }

    public static StringBuilder replace(StringBuilder buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static List<Id.Segment> parseIdentifier(String s) {
        if (!s.startsWith("[")) {
            return Collections.singletonList(new Id.Segment(s, Id.Quoting.UNQUOTED));
        }
        ArrayList<Id.Segment> list = new ArrayList<Id.Segment>();
        int i = 0;
        while (i < s.length()) {
            Id.Quoting type;
            if (s.charAt(i) != '&' && s.charAt(i) != '[') {
                throw MondrianResource.instance().MdxInvalidMember.ex(s);
            }
            if (s.charAt(i) == '&') {
                ++i;
                type = Id.Quoting.KEY;
            } else {
                type = Id.Quoting.QUOTED;
            }
            if (s.charAt(i) != '[') {
                throw MondrianResource.instance().MdxInvalidMember.ex(s);
            }
            int j = Util.getEndIndex(s, i + 1);
            if (j == -1) {
                throw MondrianResource.instance().MdxInvalidMember.ex(s);
            }
            list.add(new Id.Segment(Util.replace(s.substring(i + 1, j), "]]", "]"), type));
            i = j + 2;
        }
        return list;
    }

    private static int getEndIndex(String s, int i) {
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == ']') {
                if (i + 1 < s.length() && s.charAt(i + 1) == ']') {
                    i += 2;
                    continue;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String implode(List<Id.Segment> names) {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                sb.append(".");
            }
            Util.quoteMdxIdentifier(names.get((int)i).name, sb);
        }
        return sb.toString();
    }

    public static String makeFqName(String name) {
        return Util.quoteMdxIdentifier(name);
    }

    public static String makeFqName(OlapElement parent, String name) {
        if (parent == null) {
            return Util.quoteMdxIdentifier(name);
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(parent.getUniqueName());
        buf.append('.');
        Util.quoteMdxIdentifier(name, buf);
        return buf.toString();
    }

    public static String makeFqName(String parentUniqueName, String name) {
        if (parentUniqueName == null) {
            return Util.quoteMdxIdentifier(name);
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(parentUniqueName);
        buf.append('.');
        Util.quoteMdxIdentifier(name, buf);
        return buf.toString();
    }

    public static OlapElement lookupCompound(SchemaReader schemaReader, OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category) {
        return Util.lookupCompound(schemaReader, parent, names, failIfNotFound, category, MatchType.EXACT);
    }

    public static OlapElement lookupCompound(SchemaReader schemaReader, OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
        Util.assertPrecondition(parent != null, "parent != null");
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Util.lookupCompound: ");
            buf.append("parent.name=");
            buf.append(parent.getName());
            buf.append(", category=");
            buf.append(Category.instance.getName(category));
            buf.append(", names=");
            Util.quoteMdxIdentifier(names, buf);
            LOGGER.debug((Object)buf.toString());
        }
        switch (category) {
            case 0: 
            case 6: {
                Member member = schemaReader.getCalculatedMember(names);
                if (member == null) break;
                return member;
            }
        }
        switch (category) {
            case 0: 
            case 8: {
                NamedSet namedSet = schemaReader.getNamedSet(names);
                if (namedSet == null) break;
                return namedSet;
            }
        }
        for (int i = 0; i < names.size(); ++i) {
            Id.Segment name = names.get(i);
            OlapElement child = schemaReader.getElementChild(parent, name, matchType);
            if (child != null && matchType != MatchType.EXACT && !Util.equalName(child.getName(), name.name)) {
                Util.assertPrecondition(child instanceof Member);
                Member bestChild = (Member)child;
                for (int j = i + 1; j < names.size(); ++j) {
                    Member[] children = schemaReader.getMemberChildren(bestChild);
                    List<Member> childrenList = Arrays.asList(children);
                    FunUtil.hierarchize(childrenList, false);
                    bestChild = matchType == MatchType.AFTER ? childrenList.get(0) : childrenList.get(children.length - 1);
                    if (bestChild != null) continue;
                    child = null;
                    break;
                }
                parent = bestChild;
                break;
            }
            if (child == null) {
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buf = new StringBuilder(64);
                    buf.append("Util.lookupCompound: ");
                    buf.append("parent.name=");
                    buf.append(parent.getName());
                    buf.append(" has no child with name=");
                    buf.append(name);
                    LOGGER.debug((Object)buf.toString());
                }
                if (!failIfNotFound) {
                    return null;
                }
                if (category == 6) {
                    throw MondrianResource.instance().MemberNotFound.ex(Util.quoteMdxIdentifier(names));
                }
                throw MondrianResource.instance().MdxChildObjectNotFound.ex(name.name, parent.getQualifiedName());
            }
            parent = child;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Util.lookupCompound: ");
            buf.append("found child.name=");
            buf.append(parent.getName());
            buf.append(", child.class=");
            buf.append(parent.getClass().getName());
            LOGGER.debug((Object)buf.toString());
        }
        switch (category) {
            case 2: {
                if (parent instanceof Dimension) {
                    return parent;
                }
                if (parent instanceof Hierarchy) {
                    return parent.getDimension();
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find dimension '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 3: {
                if (parent instanceof Hierarchy) {
                    return parent;
                }
                if (parent instanceof Dimension) {
                    return parent.getHierarchy();
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find hierarchy '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 4: {
                if (parent instanceof Level) {
                    return parent;
                }
                if (failIfNotFound) {
                    throw Util.newError("Can not find level '" + Util.implode(names) + "'");
                }
                return null;
            }
            case 6: {
                if (parent instanceof Member) {
                    return parent;
                }
                if (failIfNotFound) {
                    throw MondrianResource.instance().MdxCantFindMember.ex(Util.implode(names));
                }
                return null;
            }
            case 0: {
                Util.assertPostcondition(parent != null, "return != null");
                return parent;
            }
        }
        throw Util.newInternal("Bad switch " + category);
    }

    public static OlapElement lookup(Query q, List<Id.Segment> nameParts) {
        Exp exp = Util.lookup(q, nameParts, false);
        if (exp instanceof MemberExpr) {
            MemberExpr memberExpr = (MemberExpr)exp;
            return memberExpr.getMember();
        }
        if (exp instanceof LevelExpr) {
            LevelExpr levelExpr = (LevelExpr)exp;
            return levelExpr.getLevel();
        }
        if (exp instanceof HierarchyExpr) {
            HierarchyExpr hierarchyExpr = (HierarchyExpr)exp;
            return hierarchyExpr.getHierarchy();
        }
        if (exp instanceof DimensionExpr) {
            DimensionExpr dimensionExpr = (DimensionExpr)exp;
            return dimensionExpr.getDimension();
        }
        throw Util.newInternal("Not an olap element: " + exp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exp lookup(Query q, List<Id.Segment> nameParts, boolean allowProp) {
        String fullName = Util.quoteMdxIdentifier(nameParts);
        SchemaReader schemaReader = q.getSchemaReader(false);
        OlapElement olapElement = schemaReader.lookupCompound(q.getCube(), nameParts, false, 0);
        if (olapElement != null) {
            SchemaReader accessConSchemaReader = q.getSchemaReader(true);
            Role role = accessConSchemaReader.getRole();
            if (!role.canAccess(olapElement)) {
                olapElement = null;
            }
            if (olapElement instanceof Member) {
                olapElement = accessConSchemaReader.substitute((Member)olapElement);
            }
        }
        if (olapElement == null) {
            if (allowProp && nameParts.size() > 1) {
                List<Id.Segment> namePartsButOne = nameParts.subList(0, nameParts.size() - 1);
                String propertyName = nameParts.get((int)(nameParts.size() - 1)).name;
                olapElement = schemaReader.lookupCompound(q.getCube(), namePartsButOne, false, 6);
                if (olapElement != null && Util.isValidProperty((Member)olapElement, propertyName)) {
                    return new UnresolvedFunCall(propertyName, Syntax.Property, new Exp[]{Util.createExpr(olapElement)});
                }
            }
            if (!q.ignoreInvalidMembers()) throw MondrianResource.instance().MdxChildObjectNotFound.ex(fullName, q.getCube().getQualifiedName());
            olapElement = null;
            for (int nameLen = nameParts.size() - 1; nameLen > 0 && olapElement == null; --nameLen) {
                List<Id.Segment> partialName = nameParts.subList(0, nameLen);
                olapElement = schemaReader.lookupCompound(q.getCube(), partialName, false, 0);
            }
            if (olapElement == null) throw MondrianResource.instance().MdxChildObjectNotFound.ex(fullName, q.getCube().getQualifiedName());
            olapElement = olapElement.getHierarchy().getNullMember();
        }
        q.addMeasuresMembers(olapElement);
        return Util.createExpr(olapElement);
    }

    static Cube lookupCube(SchemaReader schemaReader, String cubeName, boolean fail) {
        for (Cube cube : schemaReader.getCubes()) {
            if (Util.compareName(cube.getName(), cubeName) != 0) continue;
            return cube;
        }
        if (fail) {
            throw MondrianResource.instance().MdxCubeNotFound.ex(cubeName);
        }
        return null;
    }

    public static Exp createExpr(OlapElement element) {
        if (element instanceof Member) {
            Member member = (Member)element;
            return new MemberExpr(member);
        }
        if (element instanceof Level) {
            Level level = (Level)element;
            return new LevelExpr(level);
        }
        if (element instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)element;
            return new HierarchyExpr(hierarchy);
        }
        if (element instanceof Dimension) {
            Dimension dimension = (Dimension)element;
            return new DimensionExpr(dimension);
        }
        if (element instanceof NamedSet) {
            NamedSet namedSet = (NamedSet)element;
            return new NamedSetExpr(namedSet);
        }
        throw Util.newInternal("Unexpected element type: " + element);
    }

    public static Member lookupHierarchyRootMember(SchemaReader reader, Hierarchy hierarchy, Id.Segment memberName) {
        return Util.lookupHierarchyRootMember(reader, hierarchy, memberName, MatchType.EXACT);
    }

    public static Member lookupHierarchyRootMember(SchemaReader reader, Hierarchy hierarchy, Id.Segment memberName, MatchType matchType) {
        Member[] rootMembers = reader.getHierarchyRootMembers(hierarchy);
        Member searchMember = null;
        if (matchType != MatchType.EXACT && !hierarchy.hasAll() && rootMembers.length > 0) {
            searchMember = hierarchy.createMember(null, rootMembers[0].getLevel(), memberName.name, null);
        }
        int bestMatch = -1;
        for (int i = 0; i < rootMembers.length; ++i) {
            int rc = matchType == MatchType.EXACT || hierarchy.hasAll() ? rootMembers[i].getName().compareToIgnoreCase(memberName.name) : FunUtil.compareSiblingMembers(rootMembers[i], searchMember);
            if (rc == 0) {
                return rootMembers[i];
            }
            if (hierarchy.hasAll()) continue;
            if (matchType == MatchType.BEFORE) {
                if (rc >= 0 || bestMatch != -1 && FunUtil.compareSiblingMembers(rootMembers[i], rootMembers[bestMatch]) <= 0) continue;
                bestMatch = i;
                continue;
            }
            if (matchType != MatchType.AFTER || rc <= 0 || bestMatch != -1 && FunUtil.compareSiblingMembers(rootMembers[i], rootMembers[bestMatch]) >= 0) continue;
            bestMatch = i;
        }
        if (matchType != MatchType.EXACT && bestMatch != -1) {
            return rootMembers[bestMatch];
        }
        return rootMembers.length == 1 && rootMembers[0].isAll() ? reader.lookupMemberChildByName(rootMembers[0], memberName, matchType) : null;
    }

    public static Level lookupHierarchyLevel(Hierarchy hierarchy, String s) {
        Level[] levels;
        for (Level level : levels = hierarchy.getLevels()) {
            if (!level.getName().equalsIgnoreCase(s)) continue;
            return level;
        }
        return null;
    }

    public static int getMemberOrdinalInParent(SchemaReader reader, Member member) {
        Member parent = member.getParentMember();
        Member[] siblings = parent == null ? reader.getHierarchyRootMembers(member.getHierarchy()) : reader.getMemberChildren(parent);
        for (int i = 0; i < siblings.length; ++i) {
            if (!siblings[i].equals(member)) continue;
            return i;
        }
        throw Util.newInternal("could not find member " + member + " amongst its siblings");
    }

    public static Member getFirstDescendantOnLevel(SchemaReader reader, Member parent, Level level) {
        Member m = parent;
        while (m.getLevel() != level) {
            Member[] children = reader.getMemberChildren(m);
            m = children[0];
        }
        return m;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String singleQuoteString(String val) {
        StringBuilder buf = new StringBuilder(64);
        Util.singleQuoteString(val, buf);
        return buf.toString();
    }

    public static void singleQuoteString(String val, StringBuilder buf) {
        buf.append('\'');
        String s0 = Util.replace(val, "'", "''");
        buf.append(s0);
        buf.append('\'');
    }

    public static Random createRandom(long seed) {
        if (seed == 0L) {
            seed = new Random().nextLong();
            System.out.println("random: seed=" + seed);
        } else if (seed == -1L && metaRandom != null) {
            seed = metaRandom.nextLong();
        }
        return new Random(seed);
    }

    public static boolean isValidProperty(Member member, String propertyName) {
        return Util.lookupProperty(member.getLevel(), propertyName) != null;
    }

    protected static Property lookupProperty(Level level, String propertyName) {
        do {
            Property[] properties;
            for (Property property : properties = level.getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        } while ((level = level.getParentLevel()) != null);
        boolean caseSensitive = MondrianProperties.instance().CaseSensitive.get();
        Property property = Property.lookup(propertyName, caseSensitive);
        if (property != null && property.isMemberProperty() && property.isStandard()) {
            return property;
        }
        return null;
    }

    public static void deprecated(String reason) {
        throw new UnsupportedOperationException(reason);
    }

    public static Member[] addLevelCalculatedMembers(SchemaReader reader, Level level, Member[] members) {
        List<Member> calcMembers = reader.getCalculatedMembers(level.getHierarchy());
        ArrayList<Member> calcMembersInThisLevel = new ArrayList<Member>();
        for (Member calcMember : calcMembers) {
            if (!calcMember.getLevel().equals(level)) continue;
            calcMembersInThisLevel.add(calcMember);
        }
        if (!calcMembersInThisLevel.isEmpty()) {
            ArrayList<Member> newMemberList = new ArrayList<Member>(Arrays.asList(members));
            newMemberList.addAll(calcMembersInThisLevel);
            members = newMemberList.toArray(new Member[newMemberList.size()]);
        }
        return members;
    }

    public static RuntimeException needToImplement(Object o) {
        throw new UnsupportedOperationException("need to implement " + o);
    }

    public static <T extends Enum<T>> RuntimeException badValue(Enum<T> anEnum) {
        return Util.newInternal("Was not expecting value '" + anEnum + "' for enumeration '" + anEnum.getDeclaringClass().getName() + "' in this context");
    }

    public static String maskVersion(String str) {
        MondrianServer.MondrianVersion mondrianVersion = MondrianServer.forConnection(null).getVersion();
        String versionString = mondrianVersion.getVersionString();
        return Util.replace(str, versionString, "${mondrianVersion}");
    }

    public static String wildcardToRegexp(List<String> wildcards) {
        StringBuilder buf = new StringBuilder();
        block0: for (String value : wildcards) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            int i = 0;
            while (true) {
                int percent = value.indexOf(37, i);
                int underscore = value.indexOf(95, i);
                if (percent == -1 && underscore == -1) {
                    if (i >= value.length()) continue block0;
                    buf.append(Util.quotePattern(value.substring(i)));
                    continue block0;
                }
                if (underscore >= 0 && (underscore < percent || percent < 0)) {
                    if (i < underscore) {
                        buf.append(Util.quotePattern(value.substring(i, underscore)));
                    }
                    buf.append('.');
                    i = underscore + 1;
                    continue;
                }
                if (percent < 0 || percent >= underscore && underscore >= 0) break;
                if (i < percent) {
                    buf.append(Util.quotePattern(value.substring(i, percent)));
                }
                buf.append(".*");
                i = percent + 1;
            }
            throw new IllegalArgumentException();
        }
        return buf.toString();
    }

    public static String camelToUpper(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        int prevUpper = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > prevUpper + 1) {
                    buf.append('_');
                }
                prevUpper = i;
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static List<String> parseCommaList(String nameCommaList) {
        String[] strings;
        if (nameCommaList.equals("")) {
            return Collections.emptyList();
        }
        if (nameCommaList.endsWith(",")) {
            String zzz = "zzz";
            List<String> list = Util.parseCommaList(nameCommaList + "zzz");
            String last = list.get(list.size() - 1);
            if (last.equals("zzz")) {
                list.remove(list.size() - 1);
            } else {
                list.set(list.size() - 1, last.substring(0, last.length() - "zzz".length()));
            }
            return list;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String string : strings = nameCommaList.split(",")) {
            int count = names.size();
            if (count > 0 && ((String)names.get(count - 1)).equals("")) {
                if (count == 1) {
                    if (string.equals("")) {
                        names.add("");
                        continue;
                    }
                    names.set(0, "," + string);
                    continue;
                }
                names.set(count - 2, (String)names.get(count - 2) + "," + string);
                names.remove(count - 1);
                continue;
            }
            names.add(string);
        }
        return names;
    }

    public static <T> T getAnnotation(Method method, String annotationClassName, T defaultValue) {
        return compatible.getAnnotation(method, annotationClassName, defaultValue);
    }

    public static <T> String commaList(String s, List<T> list) {
        StringBuilder buf = new StringBuilder(s);
        buf.append("(");
        int k = -1;
        for (T t : list) {
            if (++k > 0) {
                buf.append(", ");
            }
            buf.append(t);
        }
        buf.append(")");
        return buf.toString();
    }

    public static <T> Iterable<T> union(final Iterable<? extends T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new UnionIterator(iterables);
            }
        };
    }

    public static <T> Iterable<T> union(final Collection<? extends T> ... collections) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new UnionIterator(collections);
            }
        };
    }

    public static String uniquify(String name, int maxLength, Collection<String> nameList) {
        assert (name != null);
        if (name.length() > maxLength) {
            name = name.substring(0, maxLength);
        }
        if (nameList.contains(name)) {
            String aliasBase = name;
            int j = 0;
            while (true) {
                if ((name = aliasBase + j).length() > maxLength) {
                    aliasBase = aliasBase.substring(0, aliasBase.length() - 1);
                    continue;
                }
                if (!nameList.contains(name)) break;
                ++j;
            }
        }
        nameList.add(name);
        return name;
    }

    public static void assertTrue(boolean b) {
        if (!b) {
            throw Util.newInternal("assert failed");
        }
    }

    public static void assertTrue(boolean b, String message) {
        if (!b) {
            throw Util.newInternal("assert failed: " + message);
        }
    }

    public static RuntimeException newInternal(String message) {
        return MondrianResource.instance().Internal.ex(message);
    }

    public static RuntimeException newInternal(Throwable e, String message) {
        return MondrianResource.instance().Internal.ex(message, e);
    }

    public static RuntimeException newError(String message) {
        return Util.newInternal(message);
    }

    public static RuntimeException newError(Throwable e, String message) {
        return Util.newInternal(e, message);
    }

    public static RuntimeException unexpected(Enum value) {
        return Util.newInternal("Was not expecting value '" + value + "' for enumeration '" + value.getClass().getName() + "' in this context");
    }

    public static void assertPrecondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPrecondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static void assertPostcondition(boolean b) {
        Util.assertTrue(b);
    }

    public static void assertPostcondition(boolean b, String condition) {
        Util.assertTrue(b, condition);
    }

    public static String[] convertStackToString(Throwable e) {
        ArrayList<String> list = new ArrayList<String>();
        while (e != null) {
            String sMsg = Util.getErrorMessage(e);
            list.add(sMsg);
            e = e.getCause();
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getErrorMessage(Throwable err) {
        boolean prependClassName = !(err instanceof SQLException) && err.getClass() != Exception.class;
        return Util.getErrorMessage(err, prependClassName);
    }

    public static String getErrorMessage(Throwable err, boolean prependClassName) {
        String errMsg = err.getMessage();
        if (errMsg == null || err instanceof RuntimeException) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            err.printStackTrace(pw);
            return sw.toString();
        }
        return prependClassName ? err.getClass().getName() + ": " + errMsg : errMsg;
    }

    public static String unparse(Exp exp) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exp.unparse(pw);
        return sw.toString();
    }

    public static String unparse(Query query) {
        StringWriter sw = new StringWriter();
        QueryPrintWriter pw = new QueryPrintWriter(sw);
        query.unparse(pw);
        return sw.toString();
    }

    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        String fs = System.getProperty("file.separator");
        if (fs.length() == 1) {
            char sep = fs.charAt(0);
            if (sep != '/') {
                path = path.replace(sep, '/');
            }
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
        }
        path = "file://" + path;
        return new URL(path);
    }

    public static PropertyList parseConnectString(String s) {
        return new ConnectStringParser(s).parse();
    }

    public static int hash(int i, int j) {
        return i << 4 ^ j;
    }

    public static int hash(int h, Object o) {
        int k = o == null ? 0 : o.hashCode();
        return (h << 4 | h) ^ k;
    }

    public static int hashArray(int h, Object[] a) {
        if (a == null) {
            return Util.hash(h, 19690429);
        }
        if (a.length == 0) {
            return Util.hash(h, 19690721);
        }
        for (Object anA : a) {
            h = Util.hash(h, anA);
        }
        return h;
    }

    public static long dbTimeMillis() {
        return databaseMillis;
    }

    public static void addDatabaseTime(long millis) {
        databaseMillis += millis;
    }

    public static long nonDbTimeMillis() {
        long systemMillis = System.currentTimeMillis();
        return systemMillis - databaseMillis;
    }

    public static Validator createSimpleValidator(final FunTable funTable) {
        return new Validator(){

            public Query getQuery() {
                return null;
            }

            public Exp validate(Exp exp, boolean scalar) {
                return exp;
            }

            public void validate(ParameterExpr parameterExpr) {
            }

            public void validate(MemberProperty memberProperty) {
            }

            public void validate(QueryAxis axis) {
            }

            public void validate(Formula formula) {
            }

            public boolean canConvert(Exp fromExp, int to, int[] conversionCount) {
                return true;
            }

            public boolean requiresExpression() {
                return false;
            }

            public FunTable getFunTable() {
                return funTable;
            }

            public Parameter createOrLookupParam(boolean definition, String name, Type type, Exp defaultExp, String description) {
                return null;
            }
        };
    }

    public static String readFully(Reader rdr, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        StringBuilder buf = new StringBuilder(bufferSize);
        int len = rdr.read(buffer);
        while (len != -1) {
            buf.append(buffer, 0, len);
            len = rdr.read(buffer);
        }
        String s = buf.toString();
        return s.length() == 0 ? null : s;
    }

    public static String readURL(String urlStr) throws MalformedURLException, IOException {
        return Util.readURL(urlStr, null);
    }

    public static String readURL(String urlStr, Map map) throws MalformedURLException, IOException {
        URL url = new URL(urlStr);
        return Util.readURL(url, (Map<String, String>)map);
    }

    public static String readURL(URL url) throws IOException {
        return Util.readURL(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURL(URL url, Map<String, String> map) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
        int BUF_SIZE = 8096;
        try {
            String xmlCatalog = Util.readFully(r, 8096);
            if (map != null) {
                xmlCatalog = Util.replaceProperties(xmlCatalog, map);
            }
            String string = xmlCatalog;
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    public static FileObject readVirtualFile(String url) throws FileSystemException {
        File userDir;
        FileObject file;
        FileSystemManager fsManager = VFS.getManager();
        if (fsManager == null) {
            throw Util.newError("Cannot get virtual file system manager");
        }
        if (url.startsWith("file://localhost")) {
            url = url.substring("file://localhost".length());
        }
        if (url.startsWith("file:")) {
            url = url.substring("file:".length());
        }
        if (!(file = fsManager.resolveFile(userDir = new File("").getAbsoluteFile(), url)).isReadable()) {
            throw Util.newError("Virtual file is not readable: " + url);
        }
        FileContent fileContent = file.getContent();
        if (fileContent == null) {
            throw Util.newError("Cannot get virtual file content: " + url);
        }
        return file;
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return properties.entrySet();
            }
        };
    }

    public static String replaceProperties(String text, Map<String, String> env) {
        StringBuffer buf = new StringBuffer(text.length() + 200);
        Pattern pattern = Pattern.compile("\\$\\{([^${}]+)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String varName = matcher.group(1);
            String varValue = env.get(varName);
            if (varValue != null) {
                matcher.appendReplacement(buf, varValue);
                continue;
            }
            matcher.appendReplacement(buf, "\\${$1}");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String printMemory() {
        return Util.printMemory(null);
    }

    public static String printMemory(String msg) {
        Runtime rt = Runtime.getRuntime();
        long freeMemory = rt.freeMemory();
        long totalMemory = rt.totalMemory();
        StringBuilder buf = new StringBuilder(64);
        buf.append("FREE_MEMORY:");
        if (msg != null) {
            buf.append(msg);
            buf.append(':');
        }
        buf.append(' ');
        buf.append(freeMemory / 1024L);
        buf.append("kb ");
        long hundredths = freeMemory * 10000L / totalMemory;
        buf.append(hundredths / 100L);
        if ((hundredths %= 100L) >= 10L) {
            buf.append('.');
        } else {
            buf.append(".0");
        }
        buf.append(hundredths);
        buf.append('%');
        return buf.toString();
    }

    public static <T> Set<T> cast(Set<?> set) {
        return set;
    }

    public static <T> List<T> cast(List<?> list) {
        return list;
    }

    public static <E extends Enum<E>> E lookup(Class<E> clazz, String name) {
        return Util.lookup(clazz, name, null);
    }

    public static <E extends Enum<E>> E lookup(Class<E> clazz, String name, E defaultValue) {
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> Set<E> enumSetOf(E first, E ... rest) {
        return compatible.enumSetOf(first, (Enum[])rest);
    }

    public static <E extends Enum<E>> Set<E> enumSetNoneOf(Class<E> elementType) {
        return compatible.enumSetNoneOf(elementType);
    }

    public static <E extends Enum<E>> Set<E> enumSetAllOf(Class<E> elementType) {
        return compatible.enumSetAllOf(elementType);
    }

    public static BigDecimal makeBigDecimalFromDouble(double d) {
        return compatible.makeBigDecimalFromDouble(d);
    }

    public static String quotePattern(String s) {
        return compatible.quotePattern(s);
    }

    public static UserDefinedFunction createUdf(Class<?> udfClass) {
        UserDefinedFunction udf;
        String className = udfClass.getName();
        try {
            udf = (UserDefinedFunction)udfClass.newInstance();
        }
        catch (InstantiationException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex("", className, UserDefinedFunction.class.getName());
        }
        catch (IllegalAccessException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex("", className, UserDefinedFunction.class.getName());
        }
        catch (ClassCastException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex("", className, UserDefinedFunction.class.getName());
        }
        return udf;
    }

    static {
        String className = PreJdk15 || Retrowoven ? "mondrian.util.UtilCompatibleJdk14" : "mondrian.util.UtilCompatibleJdk15";
        try {
            Class<?> clazz = Class.forName(className);
            compatible = (UtilCompatible)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw Util.newInternal(e, "Could not load '" + className + "'");
        }
        catch (InstantiationException e) {
            throw Util.newInternal(e, "Could not load '" + className + "'");
        }
        catch (IllegalAccessException e) {
            throw Util.newInternal(e, "Could not load '" + className + "'");
        }
    }

    private static class ConnectStringParser {
        private final String s;
        private final int n;
        private int i;
        private final StringBuilder nameBuf;
        private final StringBuilder valueBuf;

        private ConnectStringParser(String s) {
            this.s = s;
            this.i = 0;
            this.n = s.length();
            this.nameBuf = new StringBuilder(64);
            this.valueBuf = new StringBuilder(64);
        }

        PropertyList parse() {
            PropertyList list = new PropertyList();
            while (this.i < this.n) {
                this.parsePair(list);
            }
            return list;
        }

        void parsePair(PropertyList list) {
            String value;
            String name = this.parseName();
            if (name == null) {
                return;
            }
            if (this.i >= this.n) {
                value = "";
            } else if (this.s.charAt(this.i) == ';') {
                ++this.i;
                value = "";
            } else {
                value = this.parseValue();
            }
            list.put(name, value);
        }

        String parseName() {
            this.nameBuf.setLength(0);
            block4: while (true) {
                char c = this.s.charAt(this.i);
                switch (c) {
                    case '=': {
                        ++this.i;
                        if (this.i < this.n && (c = this.s.charAt(this.i)) == '=') {
                            ++this.i;
                            this.nameBuf.append(c);
                            continue block4;
                        }
                        String name = this.nameBuf.toString();
                        name = name.trim();
                        return name;
                    }
                    case ' ': {
                        if (this.nameBuf.length() != 0) break;
                        ++this.i;
                        if (this.i < this.n) continue block4;
                        return null;
                    }
                }
                this.nameBuf.append(c);
                ++this.i;
                if (this.i >= this.n) break;
            }
            return this.nameBuf.toString().trim();
        }

        String parseValue() {
            String value;
            char c;
            while ((c = this.s.charAt(this.i)) == ' ') {
                ++this.i;
                if (this.i < this.n) continue;
                return "";
            }
            if (c == '\"' || c == '\'') {
                String value2 = this.parseQuoted(c);
                while (this.i < this.n && (c = this.s.charAt(this.i)) == ' ') {
                    ++this.i;
                }
                if (this.i >= this.n) {
                    return value2;
                }
                if (this.s.charAt(this.i) == ';') {
                    ++this.i;
                    return value2;
                }
                throw new RuntimeException("quoted value ended too soon, at position " + this.i + " in '" + this.s + "'");
            }
            int semi = this.s.indexOf(59, this.i);
            if (semi >= 0) {
                value = this.s.substring(this.i, semi);
                this.i = semi + 1;
            } else {
                value = this.s.substring(this.i);
                this.i = this.n;
            }
            return value.trim();
        }

        String parseQuoted(char q) {
            char c;
            Util.assertTrue((c = this.s.charAt(this.i++)) == q);
            this.valueBuf.setLength(0);
            while (this.i < this.n) {
                c = this.s.charAt(this.i);
                if (c == q) {
                    ++this.i;
                    if (this.i < this.n && (c = this.s.charAt(this.i)) == q) {
                        this.valueBuf.append(c);
                        ++this.i;
                        continue;
                    }
                    return this.valueBuf.toString();
                }
                this.valueBuf.append(c);
                ++this.i;
            }
            throw new RuntimeException("Connect string '" + this.s + "' contains unterminated quoted value '" + this.valueBuf.toString() + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyList
    implements Iterable<Pair<String, String>> {
        List<Pair<String, String>> list = new ArrayList<Pair<String, String>>();

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (!((String)pair.left).equalsIgnoreCase(key)) continue;
                return (String)pair.right;
            }
            return defaultValue;
        }

        public String put(String key, String value) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (!((String)pair.left).equalsIgnoreCase(key)) continue;
                String old = (String)pair.right;
                if (!key.equalsIgnoreCase("Provider")) {
                    pair.right = value;
                }
                return old;
            }
            this.list.add(new Pair<String, String>(key, value));
            return null;
        }

        public boolean remove(String key) {
            boolean found = false;
            for (int i = 0; i < this.list.size(); ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (!pair.getKey().equalsIgnoreCase(key)) continue;
                this.list.remove(i);
                found = true;
                --i;
            }
            return found;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                Pair<String, String> pair = this.list.get(i);
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append((String)pair.left);
                sb.append('=');
                String right = (String)pair.right;
                if (right == null) {
                    sb.append("'null'");
                    continue;
                }
                int needsQuote = right.indexOf(59);
                if (needsQuote >= 0) {
                    if (right.charAt(0) != '\'') {
                        sb.append("'");
                    }
                    sb.append(Util.replace(right, "'", "''"));
                    if (right.charAt(right.length() - 1) == '\'') continue;
                    sb.append("'");
                    continue;
                }
                sb.append(right);
            }
            return sb.toString();
        }

        @Override
        public Iterator<Pair<String, String>> iterator() {
            return this.list.iterator();
        }
    }

    public static class ErrorCellValue {
        public String toString() {
            return "#ERR";
        }
    }
}

