/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.core.style.ToStringCreator;

public class DefaultAttributeMapper
implements AttributeMapper,
Serializable {
    private List mappings = new LinkedList();

    public void addMapping(Mapping mapping) {
        this.mappings.add(mapping);
    }

    public void addMappings(Mapping[] mappings) {
        if (mappings == null) {
            return;
        }
        this.mappings.addAll(Arrays.asList(mappings));
    }

    public Mapping[] getMappings() {
        return this.mappings.toArray(new Mapping[this.mappings.size()]);
    }

    public void map(Object source, Object target, Map context) {
        if (this.mappings != null) {
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                Mapping mapping = (Mapping)it.next();
                mapping.map(source, target, context);
            }
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("mappings", (Object)this.mappings).toString();
    }
}

