/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format;

import org.springframework.core.NestedRuntimeException;

public class InvalidFormatException
extends NestedRuntimeException {
    private String invalidValue;
    private String expectedFormat;

    public InvalidFormatException(String invalidValue, String expectedFormat) {
        this(invalidValue, expectedFormat, null);
    }

    public InvalidFormatException(String invalidValue, String expectedFormat, Throwable cause) {
        super("Invalid format for value " + invalidValue + "; the expected format was '" + expectedFormat + "'", cause);
        this.invalidValue = invalidValue;
        this.expectedFormat = expectedFormat;
    }

    public InvalidFormatException(String invalidValue, String expectedFormat, String message, Throwable cause) {
        super(message, cause);
        this.invalidValue = invalidValue;
        this.expectedFormat = expectedFormat;
    }

    public String getInvalidValue() {
        return this.invalidValue;
    }

    public String getExpectedFormat() {
        return this.expectedFormat;
    }
}

