/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.webflow.registry.AbstractFlowRegistryFactoryBean;
import org.springframework.webflow.registry.ExternalizedFlowDefinition;
import org.springframework.webflow.registry.ExternalizedFlowRegistrar;
import org.springframework.webflow.registry.FlowRegistry;
import org.springframework.webflow.registry.XmlFlowRegistrar;

public class XmlFlowRegistryFactoryBean
extends AbstractFlowRegistryFactoryBean {
    private ExternalizedFlowRegistrar flowRegistrar = this.createFlowRegistrar();
    private Properties flowDefinitions;

    protected ExternalizedFlowRegistrar createFlowRegistrar() {
        return new XmlFlowRegistrar();
    }

    protected ExternalizedFlowRegistrar getFlowRegistrar() {
        return this.flowRegistrar;
    }

    public void setFlowLocations(Resource[] locations) {
        this.getFlowRegistrar().setFlowLocations(locations);
    }

    public void setFlowDefinitions(Properties flowDefinitions) {
        this.flowDefinitions = flowDefinitions;
    }

    protected void doPopulate(FlowRegistry registry) {
        this.addFlowDefinitionsFromPropertiesIfNecessary();
        this.getFlowRegistrar().registerFlows(registry, this.getFlowArtifactFactory());
    }

    private void addFlowDefinitionsFromPropertiesIfNecessary() {
        if (this.flowDefinitions != null && this.flowDefinitions.size() > 0) {
            ArrayList<ExternalizedFlowDefinition> flows = new ArrayList<ExternalizedFlowDefinition>(this.flowDefinitions.size());
            Iterator<Map.Entry<Object, Object>> it = this.flowDefinitions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String flowId = (String)entry.getKey();
                String location = (String)entry.getValue();
                Resource resource = this.getFlowArtifactFactory().getResourceLoader().getResource(location);
                flows.add(new ExternalizedFlowDefinition(flowId, resource));
            }
            this.getFlowRegistrar().addFlowDefinitions(flows.toArray(new ExternalizedFlowDefinition[0]));
            this.flowDefinitions = null;
        }
    }
}

