/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowException;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;

public class FlowRequestHandler {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$executor$support$FlowRequestHandler == null ? (class$org$springframework$webflow$executor$support$FlowRequestHandler = FlowRequestHandler.class$("org.springframework.webflow.executor.support.FlowRequestHandler")) : class$org$springframework$webflow$executor$support$FlowRequestHandler));
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentExtractor argumentExtractor;
    static /* synthetic */ Class class$org$springframework$webflow$executor$support$FlowRequestHandler;

    public FlowRequestHandler(FlowExecutor flowExecutor) {
        this(flowExecutor, new FlowExecutorArgumentExtractor());
    }

    public FlowRequestHandler(FlowExecutor flowExecutor, FlowExecutorArgumentExtractor argumentExtractor) {
        Assert.notNull((Object)flowExecutor, (String)"The flow executor is required");
        Assert.notNull((Object)argumentExtractor, (String)"The flow executor argument extractor is required");
        this.flowExecutor = flowExecutor;
        this.argumentExtractor = argumentExtractor;
    }

    public ResponseInstruction handleFlowRequest(ExternalContext context) throws FlowException {
        FlowExecutionKey flowExecutionKey;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event signaled in " + context));
        }
        if ((flowExecutionKey = this.argumentExtractor.extractFlowExecutionKey(context)) != null) {
            ResponseInstruction response = this.flowExecutor.signalEvent(this.argumentExtractor.extractEventId(context), flowExecutionKey, context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning [resume] " + response));
            }
            return response;
        }
        Serializable conversationId = this.argumentExtractor.extractConversationId(context);
        if (conversationId != null) {
            ResponseInstruction response = this.flowExecutor.getCurrentResponseInstruction(conversationId, context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning [current] " + response));
            }
            return response;
        }
        ResponseInstruction response = this.flowExecutor.launch(this.argumentExtractor.extractFlowId(context), context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning [launch] " + response));
        }
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

