/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.springframework.binding.format.Formatter;
import org.springframework.core.JdkVersion;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.executor.FlowExecutionKeyFormatter;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class FlowExecutorArgumentExtractor {
    private static final String FLOW_ID_PARAMETER = "_flowId";
    private static final String FLOW_EXECUTION_KEY_PARAMETER = "_flowExecutionKey";
    private static final String EVENT_ID_PARAMETER = "_eventId";
    private static final String CONVERSATION_ID_PARAMETER = "_conversationId";
    private static final String PARAMETER_VALUE_DELIMITER = "_";
    private String flowIdParameterName = "_flowId";
    private String defaultFlowId;
    private String flowExecutionKeyParameterName = "_flowExecutionKey";
    private Formatter flowExecutionKeyFormatter = new FlowExecutionKeyFormatter();
    private String eventIdParameterName = "_eventId";
    private String conversationIdParameterName = "_conversationId";
    private String parameterDelimiter = "_";
    private static final String FLOW_EXECUTION_KEY_ATTRIBUTE = "flowExecutionKey";
    private static final String FLOW_EXECUTION_CONTEXT_ATTRIBUTE = "flowExecutionContext";
    private static final String DEFAULT_URL_ENCODING_SCHEME = "UTF-8";
    private String flowExecutionKeyAttributeName = "flowExecutionKey";
    private String flowExecutionContextAttributeName = "flowExecutionContext";
    private String urlEncodingScheme = "UTF-8";
    static /* synthetic */ Class class$org$springframework$webflow$execution$repository$FlowExecutionKey;

    public String getFlowIdParameterName() {
        return this.flowIdParameterName;
    }

    public void setFlowIdParameterName(String flowIdParameterName) {
        this.flowIdParameterName = flowIdParameterName;
    }

    public String getDefaultFlowId() {
        return this.defaultFlowId;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.defaultFlowId = defaultFlowId;
    }

    public String getFlowExecutionKeyParameterName() {
        return this.flowExecutionKeyParameterName;
    }

    public void setFlowExecutionKeyParameterName(String flowExecutionIdParameterName) {
        this.flowExecutionKeyParameterName = flowExecutionIdParameterName;
    }

    public void setFlowExecutionKeyFormatter(Formatter flowExecutionKeyFormatter) {
        this.flowExecutionKeyFormatter = flowExecutionKeyFormatter;
    }

    public String getEventIdParameterName() {
        return this.eventIdParameterName;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    public String getConversationIdParameterName() {
        return this.conversationIdParameterName;
    }

    public void setConversationIdParameterName(String conversationIdParameterName) {
        this.conversationIdParameterName = conversationIdParameterName;
    }

    public String extractFlowId(ExternalContext context) {
        String flowId = context.getRequestParameterMap().get(this.flowIdParameterName);
        return flowId != null ? flowId : this.defaultFlowId;
    }

    public FlowExecutionKey extractFlowExecutionKey(ExternalContext context) throws IllegalArgumentException {
        String encodedKey = context.getRequestParameterMap().get(this.flowExecutionKeyParameterName);
        return encodedKey != null ? (FlowExecutionKey)this.flowExecutionKeyFormatter.parseValue(encodedKey, class$org$springframework$webflow$execution$repository$FlowExecutionKey == null ? (class$org$springframework$webflow$execution$repository$FlowExecutionKey = FlowExecutorArgumentExtractor.class$("org.springframework.webflow.execution.repository.FlowExecutionKey")) : class$org$springframework$webflow$execution$repository$FlowExecutionKey) : null;
    }

    public String extractEventId(ExternalContext context) throws IllegalArgumentException {
        String eventId = this.findParameter(this.eventIdParameterName, context.getRequestParameterMap());
        Assert.hasText((String)eventId, (String)("No eventId could be obtained: make sure the client provides the '" + this.eventIdParameterName + "' parameter as input along with the '" + this.flowExecutionKeyParameterName + "' parameter; the parameters provided for this request were:" + StylerUtils.style((Object)context.getRequestParameterMap())));
        return eventId;
    }

    public Serializable extractConversationId(ExternalContext context) {
        return context.getRequestParameterMap().get(this.conversationIdParameterName);
    }

    private String findParameter(String logicalParameterName, ParameterMap parameters) {
        String value = parameters.get(logicalParameterName);
        if (value != null) {
            return value;
        }
        String prefix = logicalParameterName + this.parameterDelimiter;
        Iterator paramNames = parameters.getMap().keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (!paramName.startsWith(prefix)) continue;
            String strValue = paramName.substring(prefix.length());
            if (strValue.endsWith(".x") || strValue.endsWith(".y")) {
                strValue = strValue.substring(0, strValue.length() - 2);
            }
            return strValue;
        }
        return null;
    }

    public String getFlowExecutionKeyAttributeName() {
        return this.flowExecutionKeyAttributeName;
    }

    public void setFlowExecutionKeyAttributeName(String flowExecutionKeyAttributeName) {
        this.flowExecutionKeyAttributeName = flowExecutionKeyAttributeName;
    }

    public String getFlowExecutionContextAttributeName() {
        return this.flowExecutionContextAttributeName;
    }

    public void setFlowExecutionContextAttributeName(String flowExecutionContextAttributeName) {
        this.flowExecutionContextAttributeName = flowExecutionContextAttributeName;
    }

    public String createFlowUrl(FlowRedirect flowRedirect, ExternalContext externalContext) {
        StringBuffer flowUrl = new StringBuffer();
        flowUrl.append(externalContext.getDispatcherPath());
        flowUrl.append('?');
        this.appendQueryParameter(this.flowIdParameterName, flowRedirect.getFlowId(), flowUrl);
        if (!flowRedirect.getInput().isEmpty()) {
            flowUrl.append('&');
        }
        this.appendQueryParameters(flowRedirect.getInput(), flowUrl);
        return flowUrl.toString();
    }

    public String createConversationUrl(Serializable conversationId, ExternalContext context) {
        StringBuffer conversationUrl = new StringBuffer();
        conversationUrl.append(context.getDispatcherPath());
        conversationUrl.append('?');
        this.appendQueryParameter(this.conversationIdParameterName, conversationId, conversationUrl);
        return conversationUrl.toString();
    }

    public String createExternalUrl(ExternalRedirect redirect, FlowExecutionKey flowExecutionKey, ExternalContext context) {
        StringBuffer externalUrl = new StringBuffer();
        externalUrl.append(redirect.getUrl());
        if (flowExecutionKey != null) {
            boolean first;
            boolean bl = first = redirect.getUrl().indexOf(63) < 0;
            if (first) {
                externalUrl.append('?');
            } else {
                externalUrl.append('&');
            }
            this.appendQueryParameter(this.flowExecutionKeyParameterName, this.flowExecutionKeyFormatter.formatValue((Object)flowExecutionKey), externalUrl);
        }
        return externalUrl.toString();
    }

    public void put(FlowExecutionKey flowExecutionKey, Map model) {
        if (flowExecutionKey != null) {
            model.put(this.flowExecutionKeyAttributeName, this.flowExecutionKeyFormatter.formatValue((Object)flowExecutionKey));
        }
    }

    public void put(FlowExecutionContext context, Map model) {
        model.put(this.flowExecutionContextAttributeName, context);
    }

    protected String encodeValue(Object value) {
        return value != null ? this.urlEncode(value.toString()) : "";
    }

    private void appendQueryParameters(Map model, StringBuffer targetUrl) {
        Iterator entries = model.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.appendQueryParameter(entry.getKey(), entry.getValue(), targetUrl);
            if (!entries.hasNext()) continue;
            targetUrl.append('&');
        }
    }

    private void appendQueryParameter(Object key, Object value, StringBuffer targetUrl) {
        String encodedKey = this.urlEncode(key.toString());
        String encodedValue = this.encodeValue(value);
        targetUrl.append(encodedKey).append('=').append(encodedValue);
    }

    private String urlEncode(String input) {
        if (JdkVersion.getMajorJavaVersion() < 1) {
            return URLEncoder.encode(input);
        }
        try {
            return URLEncoder.encode(input, this.urlEncodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot encode URL " + input);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

