/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import java.io.Serializable;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.repository.FlowExecutionKey;

public class FlowExecutionKeyFormatter
implements Formatter {
    private static final String CONVERSATION_ID_PREFIX = "_s";
    private static final String CONTINUATION_ID_PREFIX = "_c";

    public String formatValue(Object continuationKey) throws IllegalArgumentException {
        Assert.notNull((Object)continuationKey, (String)"The flow execution key is required");
        FlowExecutionKey key = (FlowExecutionKey)continuationKey;
        return CONVERSATION_ID_PREFIX + key.getConversationId() + CONTINUATION_ID_PREFIX + key.getContinuationId();
    }

    public Object parseValue(String continuationKeyString, Class targetClass) throws InvalidFormatException {
        Assert.hasText((String)continuationKeyString, (String)"The string encoded flow execution key is required");
        Assert.isTrue((boolean)continuationKeyString.startsWith(CONVERSATION_ID_PREFIX), (String)("Invalid string encoded flow execution key '" + continuationKeyString + "'"));
        int continuationStart = continuationKeyString.indexOf(CONTINUATION_ID_PREFIX, CONVERSATION_ID_PREFIX.length());
        String conversationId = continuationKeyString.substring(CONVERSATION_ID_PREFIX.length(), continuationStart);
        String continuationId = continuationKeyString.substring(continuationStart + CONTINUATION_ID_PREFIX.length());
        return new FlowExecutionKey((Serializable)((Object)conversationId), (Serializable)((Object)continuationId));
    }
}

