/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.Action;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.action.AbstractAction;

public class GuardedAction
extends AbstractAction {
    private Action action;
    private TransitionCriteria executionCriteria;

    public GuardedAction(Action action, TransitionCriteria executionCriteria) {
        Assert.notNull((Object)action, (String)"The action is required");
        Assert.notNull((Object)executionCriteria, (String)"The guarding execution criteria is required");
        this.action = action;
        this.executionCriteria = executionCriteria;
    }

    public Action getAction() {
        return this.action;
    }

    public TransitionCriteria getExecutionCriteria() {
        return this.executionCriteria;
    }

    public Event doExecute(RequestContext context) throws Exception {
        if (this.getExecutionCriteria().test(context)) {
            return this.getAction().execute(context);
        }
        return this.success();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("action", (Object)this.getAction()).append("executionCriteria", (Object)this.executionCriteria).toString();
    }
}

