/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.webflow.AbstractAttributeMap;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.UnmodifiableAttributeMap;

public class AttributeMap
extends AbstractAttributeMap {
    public AttributeMap() {
        this.initAttributes(new HashMap());
    }

    public AttributeMap(int size) {
        this.initAttributes(new HashMap(size));
    }

    public AttributeMap(int size, int loadFactor) {
        this.initAttributes(new HashMap(size, loadFactor));
    }

    public AttributeMap(AttributeCollection attributes) {
        Assert.notNull((Object)attributes, (String)"The target attribute collection is required");
        this.initAttributes(new HashMap(attributes.getMap()));
    }

    public Object put(String attributeName, Object attributeValue) {
        return this.getMapInternal().put(attributeName, attributeValue);
    }

    public UnmodifiableAttributeMap unmodifiable() {
        return new UnmodifiableAttributeMap(this.getMap());
    }

    public AttributeMap(Map map) {
        Assert.notNull((Object)map, (String)"The target map is required");
        this.initAttributes(map);
    }

    public AttributeMap putAll(AttributeCollection attributes) {
        if (attributes == null) {
            return this;
        }
        this.getMapInternal().putAll(attributes.getMap());
        return this;
    }

    public Object remove(String attributeName) {
        return this.getMapInternal().remove(attributeName);
    }

    public AttributeMap clear() throws UnsupportedOperationException {
        this.getMapInternal().clear();
        return this;
    }

    public AttributeMap replaceWith(AttributeCollection attributes) throws UnsupportedOperationException {
        this.clear();
        this.putAll(attributes);
        return this;
    }

    public AttributeMap union(AttributeCollection attributes) {
        HashMap map = new HashMap(this.size() + attributes.size(), 1.0f);
        map.putAll(this.getMap());
        map.putAll(attributes.getMap());
        return new AttributeMap(map);
    }

    protected Map createAttributeMap() {
        return new HashMap();
    }
}

