/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.binding.method.MethodSignature;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.Action;
import org.springframework.webflow.AnnotatedObject;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;

public class AnnotatedAction
extends AnnotatedObject
implements Action {
    public static final String NAME_PROPERTY = "name";
    public static final String METHOD_PROPERTY = "method";
    public static final String RESULT_NAME_PROPERTY = "resultName";
    public static final String RESULT_SCOPE_PROPERTY = "resultScope";
    private Action targetAction;
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;
    static /* synthetic */ Class class$org$springframework$webflow$ScopeType;

    public AnnotatedAction() {
    }

    public AnnotatedAction(Action targetAction) {
        this.setTargetAction(targetAction);
    }

    public AnnotatedAction(Action targetAction, AttributeMap attributes) {
        this.setTargetAction(targetAction);
        this.getAttributeMap().putAll(attributes);
    }

    public Action getTargetAction() {
        return this.targetAction;
    }

    public void setTargetAction(Action targetAction) {
        Assert.notNull((Object)targetAction, (String)"The targetAction is required");
        this.targetAction = targetAction;
    }

    public String getName() {
        return this.getAttributeMap().getString(NAME_PROPERTY);
    }

    public void setName(String name) {
        this.getAttributeMap().put(NAME_PROPERTY, name);
    }

    public boolean isNamed() {
        return StringUtils.hasText((String)this.getName());
    }

    public MethodSignature getMethod() {
        return (MethodSignature)this.getAttributeMap().get(METHOD_PROPERTY, class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = AnnotatedAction.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature);
    }

    public void setMethod(MethodSignature method) {
        this.getAttributeMap().put(METHOD_PROPERTY, method);
    }

    public String getResultName() {
        return this.getAttributeMap().getString(RESULT_NAME_PROPERTY);
    }

    public void setResultName(String resultName) {
        this.getAttributeMap().put(RESULT_NAME_PROPERTY, resultName);
    }

    public ScopeType getResultScope() {
        return (ScopeType)((Object)this.getAttributeMap().get(RESULT_SCOPE_PROPERTY, class$org$springframework$webflow$ScopeType == null ? (class$org$springframework$webflow$ScopeType = AnnotatedAction.class$("org.springframework.webflow.ScopeType")) : class$org$springframework$webflow$ScopeType));
    }

    public void setResultScope(ScopeType resultScope) {
        this.getAttributeMap().put(RESULT_SCOPE_PROPERTY, (Object)resultScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event execute(RequestContext context) throws Exception {
        try {
            context.setAttributes(this.getAttributeMap());
            Event result = this.getTargetAction().execute(context);
            Event event = this.postProcessResult(result);
            return event;
        }
        finally {
            context.setAttributes(null);
        }
    }

    protected Event postProcessResult(Event resultEvent) {
        if (resultEvent == null) {
            return null;
        }
        if (this.isNamed()) {
            String qualifiedId = this.getName() + "." + resultEvent.getId();
            resultEvent = new Event(resultEvent.getSource(), qualifiedId, resultEvent.getAttributes());
        }
        return resultEvent;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("targetAction", (Object)this.getTargetAction()).append("attributes", (Object)this.getAttributeMap()).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

