/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.navi.MemberProperties;
import com.tonbeller.jpivot.xmla.XMLA_Dimension;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_MemberProp;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class XMLA_MemberProperties
extends ExtensionSupport
implements MemberProperties {
    static Logger logger = Logger.getLogger((Class)XMLA_MemberProperties.class);
    private MemberPropertyMeta[] visibleProps;

    public XMLA_MemberProperties() {
        super.setId("memberProperties");
    }

    public MemberPropertyMeta[] getMemberPropertyMetas(Level level) {
        XMLA_Level xlev = (XMLA_Level)level;
        XMLA_Model xmlaModel = (XMLA_Model)this.getModel();
        Map propMap = xmlaModel.isSAP() || xmlaModel.isMondrian() ? ((XMLA_Dimension)xlev.getHierarchy().getDimension()).getProps() : xlev.getProps();
        if (propMap.size() == 0) {
            return new MemberPropertyMeta[0];
        }
        String scope = this.getPropertyScope(level);
        MemberPropertyMeta[] props = new MemberPropertyMeta[propMap.size()];
        int i = 0;
        Iterator iter = propMap.values().iterator();
        while (iter.hasNext()) {
            XMLA_MemberProp prop = (XMLA_MemberProp)iter.next();
            String name = prop.getName();
            String caption = prop.getCaption();
            if (xmlaModel.isSAP() || xmlaModel.isMondrian()) {
                props[i++] = new MemberPropertyMeta(caption + " / " + name, name, scope);
                continue;
            }
            props[i++] = new MemberPropertyMeta(caption, name, scope);
        }
        return props;
    }

    public boolean isLevelScope() {
        return false;
    }

    public String getPropertyScope(Member m) {
        Level level = m.getLevel();
        return this.getPropertyScope(level);
    }

    private String getPropertyScope(Level level) {
        return ((XMLA_Dimension)level.getHierarchy().getDimension()).getUniqueName();
    }

    public void setVisibleProperties(MemberPropertyMeta[] props) {
        this.visibleProps = props;
        ((XMLA_Model)this.getModel()).fireModelChanged();
    }

    public MemberPropertyMeta[] getVisibleProperties() {
        return this.visibleProps;
    }
}

