/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.tags;

import com.tonbeller.jpivot.core.ModelFactory;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.expr.ExprUtils;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class MondrianModelFactory {
    private static Logger logger = Logger.getLogger((Class)MondrianModelFactory.class);

    private MondrianModelFactory() {
    }

    static String makeConnectString(Config cfg) {
        StringBuffer sb = new StringBuffer("provider=Mondrian");
        if (cfg.getJdbcUrl() != null) {
            String jdbcUrl = cfg.getJdbcUrl();
            sb.append(";Jdbc=");
            if (jdbcUrl.indexOf(59) >= 0) {
                char c = jdbcUrl.charAt(0);
                if (c != '\"' && c != '\'') {
                    char escape = '\"';
                    if (jdbcUrl.indexOf(34) >= 0) {
                        if (jdbcUrl.indexOf(39) >= 0) {
                            throw new IllegalArgumentException("jdbcUrl is not valid - contains single and double quotes");
                        }
                        escape = '\'';
                    }
                    sb.append(escape);
                    sb.append(jdbcUrl);
                    sb.append(escape);
                } else {
                    sb.append(jdbcUrl);
                }
            } else {
                sb.append(jdbcUrl);
            }
            if (cfg.getJdbcUser() != null) {
                sb.append(";JdbcUser=").append(cfg.getJdbcUser());
            }
            if (cfg.getJdbcPassword() != null && cfg.getJdbcPassword().length() > 0) {
                sb.append(";JdbcPassword=").append(cfg.getJdbcPassword());
            }
        } else if (cfg.getDataSource() != null) {
            sb.append(";DataSource=java:comp/env/").append(cfg.getDataSource());
            MondrianModelFactory.testDataSource(cfg.getDataSource());
        }
        sb.append(";Catalog=").append(cfg.getSchemaUrl());
        if (cfg.getDynLocale() != null) {
            sb.append(";Locale=").append(cfg.getDynLocale());
        }
        if (cfg.getRole() != null) {
            sb.append(";Role=").append(cfg.getRole());
        }
        if (cfg.getDataSourceChangeListener() != null) {
            sb.append(";dataSourceChangeListener=").append(cfg.getDataSourceChangeListener());
        }
        return sb.toString();
    }

    private static void testDataSource(String dataSourceName) {
        Connection connection = null;
        String dsName = "java:comp/env/" + dataSourceName;
        try {
            DataSource dataSource = (DataSource)new InitialContext().lookup(dsName);
            connection = dataSource.getConnection();
        }
        catch (Throwable e) {
            String msg = "Datasource " + dsName + " is not configured properly";
            logger.error((Object)msg, e);
            throw new RuntimeException(msg, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("could not close SQL Connection for DataSource " + dataSourceName), (Throwable)e);
                }
            }
        }
    }

    public static MondrianModel instance() throws SAXException, IOException {
        URL url = MondrianModel.class.getResource("config.xml");
        return (MondrianModel)ModelFactory.instance(url);
    }

    public static MondrianModel instance(Config cfg) throws SAXException, IOException {
        URL url = MondrianModel.class.getResource("config.xml");
        return MondrianModelFactory.instance(url, cfg);
    }

    public static MondrianModel instance(URL url, Config cfg) throws SAXException, IOException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)cfg.toString());
            logger.info((Object)("ConnectString=" + MondrianModelFactory.makeConnectString(cfg)));
        }
        MondrianModel mm = (MondrianModel)ModelFactory.instance(url);
        mm.setMdxQuery(cfg.getMdxQuery());
        mm.setConnectString(MondrianModelFactory.makeConnectString(cfg));
        mm.setJdbcDriver(cfg.getJdbcDriver());
        mm.setDynresolver(cfg.getDynResolver());
        mm.setDynLocale(cfg.getDynLocale());
        mm.setDataSourceChangeListener(cfg.getDataSourceChangeListener());
        if ("false".equalsIgnoreCase(cfg.getConnectionPooling())) {
            mm.setConnectionPooling(false);
        }
        mm.setExternalDataSource(cfg.getExternalDataSource());
        return mm;
    }

    public static class Config {
        String jdbcUrl;
        String jdbcDriver;
        String jdbcUser;
        String jdbcPassword;
        String dataSource;
        String schemaUrl;
        String mdxQuery;
        String role;
        String dynResolver;
        String dynLocale;
        String connectionPooling;
        DataSource externalDataSource = null;
        String dataSourceChangeListener;

        public void allowOverride(RequestContext context) {
            Resources res = context.getResources();
            this.setRole(this.getDefault(res, "mondrian.role", this.getRole()));
            this.setDynResolver(this.getDefault(res, "mondrian.dynResolver", this.getDynResolver()));
            this.setDynLocale(this.getDefault(res, "mondrian.dynLocale", this.getDynLocale()));
            this.setDataSourceChangeListener(this.getDefault(res, "mondrian.dataSourceChangeListener", this.getDataSourceChangeListener()));
            if (this.externalDataSource != null) {
                logger.info((Object)"using external data source");
                return;
            }
            this.setJdbcDriver(this.replace(res, this.getJdbcDriver()));
            this.setJdbcUrl(this.replace(res, this.getJdbcUrl()));
            this.setJdbcUser(this.replace(res, this.getJdbcUser()));
            this.setJdbcPassword(this.replace(res, this.getJdbcPassword()));
            this.setConnectionPooling(this.replace(res, this.getConnectionPooling()));
            this.setDataSource(this.replace(res, this.getDataSource()));
            if (!this.empty(this.dataSource)) {
                logger.info((Object)("using data source " + this.dataSource));
                this.findDataSource(context);
                return;
            }
            if (!this.empty(this.jdbcDriver)) {
                logger.info((Object)("using driver manager " + this.jdbcUrl));
                return;
            }
            this.setDataSource(this.getDefault(res, "jdbc.datasource", this.getDataSource()));
            if (!this.empty(this.dataSource)) {
                logger.info((Object)("using default data source " + this.dataSource));
                this.findDataSource(context);
                return;
            }
            logger.info((Object)("using default driver manager " + this.jdbcUrl));
            this.setJdbcDriver(this.getDefault(res, "jdbc.driver", this.getJdbcDriver()));
            this.setJdbcUrl(this.getDefault(res, "jdbc.url", this.getJdbcUrl()));
            this.setJdbcUser(this.getDefault(res, "jdbc.user", this.getJdbcUser()));
            this.setJdbcPassword(this.getDefault(res, "jdbc.password", this.getJdbcPassword()));
            this.setConnectionPooling(this.getDefault(res, "jdbc.connectionPooling", this.getConnectionPooling()));
        }

        private void findDataSource(RequestContext context) {
            Object obj = ExprUtils.isExpression((String)this.dataSource) ? context.getModelReference(this.dataSource) : context.getSession().getAttribute(this.dataSource);
            if (obj instanceof DataSource) {
                logger.info((Object)("using app dataSource " + this.dataSource));
                this.dataSource = null;
                this.externalDataSource = (DataSource)obj;
            }
        }

        private String getDefault(Resources res, String key, String val) {
            if ((val = this.replace(res, val)) != null) {
                return val;
            }
            return res.getOptionalString(key, null);
        }

        private String replace(Resources res, String val) {
            if (this.empty(val)) {
                return null;
            }
            return res.replace(val);
        }

        private boolean empty(String s) {
            return s == null || s.trim().length() == 0;
        }

        public String getJdbcDriver() {
            return this.jdbcDriver;
        }

        public String getJdbcPassword() {
            return this.jdbcPassword;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public String getJdbcUser() {
            return this.jdbcUser;
        }

        public String getMdxQuery() {
            return this.mdxQuery;
        }

        public String getSchemaUrl() {
            return this.schemaUrl;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setJdbcDriver(String jdbcDriver) {
            this.jdbcDriver = jdbcDriver;
        }

        public void setJdbcPassword(String jdbcPassword) {
            this.jdbcPassword = jdbcPassword;
        }

        public void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        public void setJdbcUser(String jdbcUser) {
            this.jdbcUser = jdbcUser;
        }

        public void setMdxQuery(String mdxQuery) {
            this.mdxQuery = mdxQuery;
        }

        public void setSchemaUrl(String schemaUrl) {
            this.schemaUrl = schemaUrl;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(String string) {
            this.dataSource = string;
        }

        public String getDynResolver() {
            return this.dynResolver;
        }

        public void setDynResolver(String dynResolver) {
            this.dynResolver = dynResolver;
        }

        public String getConnectionPooling() {
            return this.connectionPooling;
        }

        public void setConnectionPooling(String connectionPooling) {
            this.connectionPooling = connectionPooling;
        }

        public DataSource getExternalDataSource() {
            return this.externalDataSource;
        }

        public void setExternalDataSource(DataSource externalDataSource) {
            this.externalDataSource = externalDataSource;
        }

        public String getDynLocale() {
            return this.dynLocale;
        }

        public void setDynLocale(String dynLocale) {
            this.dynLocale = dynLocale;
        }

        public String toString() {
            return "Config[jdbcUrl=" + this.jdbcUrl + ", jdbcDriver=" + this.jdbcDriver + ", jdbcUser=" + this.jdbcUser + ", jdbcPassword=" + this.jdbcPassword + ", dataSource=" + this.dataSource + ", schemaUrl=" + this.schemaUrl + ", mdxQuery=" + this.mdxQuery + ", role=" + this.role + ", dynResolver=" + this.dynResolver + ", connectionPooling=" + this.connectionPooling + ", externalDataSource=" + this.externalDataSource + ", dynLocale=" + this.dynLocale + ", dataSourceChangeListener=" + this.dataSourceChangeListener + "]";
        }

        public String getDataSourceChangeListener() {
            return this.dataSourceChangeListener;
        }

        public void setDataSourceChangeListener(String dataSourceChangeListener) {
            this.dataSourceChangeListener = dataSourceChangeListener;
        }
    }
}

