/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXLevel;
import com.tonbeller.jpivot.olap.query.MDXMember;
import com.tonbeller.jpivot.olap.query.PositionBase;
import com.tonbeller.jpivot.util.CubeIndexIterator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ResultBase
implements Result {
    private static String[] specialProps = new String[]{"arrow"};
    protected List axesList;
    protected List aCells = new ArrayList();
    protected Axis slicer;
    protected Model model;
    boolean overflow = false;

    public ResultBase(Model model) {
        this.axesList = new ArrayList();
        this.model = model;
    }

    void processSpecialProps() {
    }

    public abstract Axis[] getAxes();

    public Axis getSlicer() {
        return this.slicer;
    }

    public List getCells() {
        return this.aCells;
    }

    public void hierarchize(int iAxis) {
        List posList = ((Axis)this.axesList.get(iAxis)).getPositions();
        int nDim = this.axesList.size();
        int indexForAxis = nDim - 1 - iAxis;
        int[] ni = new int[nDim];
        int[] iFull = new int[nDim];
        for (int i = 0; i < nDim; ++i) {
            ni[i] = ((Axis)this.axesList.get(i)).getPositions().size() - 1;
        }
        int[] iSlice = new int[nDim - 1];
        CubeIndexIterator cubit = null;
        if (nDim > 1) {
            this.full2slice(ni, iSlice, iAxis);
            cubit = new CubeIndexIterator(iSlice, false);
        }
        int iPos = 0;
        int nDimension = 0;
        Iterator iter = posList.iterator();
        while (iter.hasNext()) {
            PositionBase pos = (PositionBase)iter.next();
            if (nDimension == 0) {
                nDimension = pos.getMembers().length;
            }
            pos.number = iPos;
            if (pos.cellList == null) {
                pos.cellList = new ArrayList();
            } else {
                pos.cellList.clear();
            }
            if (nDim > 1) {
                int[] iCurrent;
                cubit.reset();
                while ((iCurrent = cubit.next()) != null) {
                    this.slice2full(iCurrent, iFull, indexForAxis, iPos);
                    int ii = this.lindex(iFull, ni);
                    pos.cellList.add(this.aCells.get(ii));
                }
            } else {
                pos.cellList.add(this.aCells.get(iPos));
            }
            ++iPos;
        }
        posList = this.sortPosList(posList, 0, nDim);
        int nc = this.aCells.size();
        this.aCells.clear();
        for (int i = 0; i < nc; ++i) {
            this.aCells.add(null);
        }
        iPos = 0;
        Iterator iter2 = posList.iterator();
        while (iter2.hasNext()) {
            PositionBase posBase = (PositionBase)iter2.next();
            if (nDim > 1) {
                cubit.reset();
                Iterator iterator = posBase.cellList.iterator();
                while (iterator.hasNext()) {
                    Object cellObj = iterator.next();
                    int[] iCurrent = cubit.next();
                    if (iCurrent != null) {
                        this.slice2full(iCurrent, iFull, indexForAxis, iPos);
                        int ii = this.lindex(iFull, ni);
                        this.aCells.set(ii, cellObj);
                        continue;
                    }
                    break;
                }
            } else {
                Object cellObj = posBase.cellList.get(0);
                this.aCells.set(iPos, cellObj);
            }
            posBase.cellList.clear();
            ++iPos;
        }
    }

    private List sortPosList(List posList, final int iDim, int nDim) {
        this.printPosList(posList, new PrintWriter(System.out), "Start sortPosList " + iDim);
        if (posList.size() < 2) {
            return posList;
        }
        final HashMap<Member, Integer> firstOcc = new HashMap<Member, Integer>();
        int k = 0;
        Iterator iter = posList.iterator();
        while (iter.hasNext()) {
            PositionBase posb = (PositionBase)iter.next();
            posb.parent = null;
            Member m = posb.getMembers()[iDim];
            if (!firstOcc.containsKey(m)) {
                firstOcc.put(m, new Integer(k));
            }
            ++k;
        }
        Collections.sort(posList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int level2;
                Position pos1 = (Position)o1;
                Position pos2 = (Position)o2;
                Member a1 = pos1.getMembers()[iDim];
                Member a2 = pos2.getMembers()[iDim];
                int level1 = ((MDXLevel)((Object)a1.getLevel())).getDepth();
                if (level1 == (level2 = ((MDXLevel)((Object)a2.getLevel())).getDepth())) {
                    return ((PositionBase)pos1).number - ((PositionBase)pos2).number;
                }
                return level1 - level2;
            }
        });
        int i = 0;
        Iterator iter2 = posList.iterator();
        while (iter2.hasNext()) {
            PositionBase posb = (PositionBase)iter2.next();
            if (!iter2.hasNext()) break;
            MDXMember m = (MDXMember)posb.getMembers()[iDim];
            int iLevel = ((MDXLevel)((Object)m.getLevel())).getDepth();
            ListIterator lit = posList.listIterator(i + 1);
            while (lit.hasNext()) {
                MDXMember m2;
                int iLevel2;
                PositionBase posb2 = (PositionBase)lit.next();
                if (posb2.parent != null || (iLevel2 = ((MDXLevel)((Object)(m2 = (MDXMember)posb2.getMembers()[iDim]).getLevel())).getDepth()) <= iLevel) continue;
                if (iLevel2 > iLevel + 1) break;
                if (!m.getUniqueName().equals(m2.getParentUniqueName())) continue;
                posb2.parent = posb;
            }
            ++i;
        }
        Collections.sort(posList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Member ap2;
                Member ap1;
                Member a2;
                PositionBase pos1 = (PositionBase)o1;
                PositionBase pos2 = (PositionBase)o2;
                Member a1 = pos1.getMembers()[iDim];
                if (((Object)a1).equals(a2 = pos2.getMembers()[iDim])) {
                    return pos1.number - pos2.number;
                }
                int level1 = ((MDXLevel)((Object)a1.getLevel())).getDepth();
                int level2 = ((MDXLevel)((Object)a2.getLevel())).getDepth();
                PositionBase par1 = null;
                PositionBase par2 = null;
                PositionBase parb = null;
                if (level1 < level2) {
                    Member ab;
                    parb = pos2;
                    for (int j = 0; j < level2 - level1; ++j) {
                        if (parb == null) continue;
                        parb = parb.parent;
                    }
                    if (parb != null && ((Object)(ab = parb.getMembers()[iDim])).equals(a1)) {
                        return -1;
                    }
                    par1 = pos1;
                    par2 = parb;
                } else if (level1 > level2) {
                    Member ab;
                    parb = pos1;
                    for (int j = 0; j < level1 - level2; ++j) {
                        if (parb == null) continue;
                        parb = parb.parent;
                    }
                    if (parb != null && ((Object)(ab = parb.getMembers()[iDim])).equals(a2)) {
                        return 1;
                    }
                    par1 = parb;
                    par2 = pos2;
                } else {
                    par1 = pos1;
                    par2 = pos2;
                }
                if (par1 == null || par2 == null) {
                    return pos1.number - pos2.number;
                }
                Member apar1 = par1.getMembers()[iDim];
                Member apar2 = par2.getMembers()[iDim];
                PositionBase p1 = par1.parent;
                PositionBase p2 = par2.parent;
                while (p1 != null && p2 != null && !((Object)(ap1 = p1.getMembers()[iDim])).equals(ap2 = p2.getMembers()[iDim])) {
                    par1 = p1;
                    par2 = p2;
                    p1 = par1.parent;
                    p2 = par2.parent;
                    if (p1 == null || p2 == null) break;
                    apar1 = ap1;
                    apar2 = ap2;
                }
                int retcode = (Integer)firstOcc.get(apar1) - (Integer)firstOcc.get(apar2);
                return retcode;
            }
        });
        this.printPosList(posList, new PrintWriter(System.out), "Step 3 sortPosList " + iDim);
        if (iDim == nDim - 1) {
            return posList;
        }
        ArrayList<PositionBase> newPosList = new ArrayList<PositionBase>();
        List<PositionBase> subList = new ArrayList<PositionBase>();
        Member first = null;
        Iterator iter3 = posList.iterator();
        while (iter3.hasNext()) {
            PositionBase pb = (PositionBase)iter3.next();
            if (first == null) {
                first = pb.getMembers()[iDim];
                subList.add(pb);
                continue;
            }
            Member current = pb.getMembers()[iDim];
            if (((Object)current).equals(first)) {
                subList.add(pb);
                continue;
            }
            subList = this.sortPosList(subList, iDim + 1, nDim);
            newPosList.addAll(subList);
            subList.clear();
            first = current;
            subList.add(pb);
        }
        if (subList.size() > 1) {
            subList = this.sortPosList(subList, iDim + 1, nDim);
        }
        newPosList.addAll(subList);
        this.printPosList(newPosList, new PrintWriter(System.out), "End sortPosList " + iDim);
        return newPosList;
    }

    private void printPosList(List posList, PrintWriter wout, String label) {
        wout.println(label);
        int n = 0;
        Iterator iter = posList.iterator();
        while (iter.hasNext()) {
            PositionBase pb = (PositionBase)iter.next();
            Member[] members = pb.getMembers();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < members.length; ++i) {
                if (i == 0) {
                    sb.append(n);
                    sb.append(" ");
                    sb.append(pb.number);
                    sb.append(" ");
                } else {
                    sb.append(" * ");
                }
                sb.append(members[i].getLabel());
            }
            wout.println(sb.toString());
            ++n;
        }
        wout.flush();
    }

    private void full2slice(int[] iFull, int[] iSlice, int iAxis) {
        if (iSlice.length == 0) {
            return;
        }
        int j = 0;
        for (int i = 0; i < iFull.length; ++i) {
            if (i == iAxis) continue;
            iSlice[j++] = iFull[i];
        }
    }

    private void slice2full(int[] iSlice, int[] iFull, int iAxis, int iAxisVal) {
        if (iSlice.length == 0) {
            iFull[0] = iAxisVal;
            return;
        }
        int j = 0;
        for (int i = 0; i < iFull.length; ++i) {
            iFull[i] = i != iAxis ? iSlice[j++] : iAxisVal;
        }
    }

    private int lindex(int[] iar, int[] ni) {
        int k = iar[0];
        for (int j = 1; j < iar.length; ++j) {
            k = k * (ni[j - 1] + 1) + iar[j];
        }
        return k;
    }

    public Object getRootDecoree() {
        return this;
    }

    public void accept(Visitor visitor) {
        visitor.visitResult(this);
    }

    public static void renderHtml(Result result, String mdx, String outfile) throws IOException {
        PrintWriter wout = new PrintWriter(new BufferedWriter(new FileWriter(outfile)));
        Axis[] axes = result.getAxes();
        wout.println("<HTML>");
        wout.println("<HEAD>");
        wout.println("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-1\">");
        wout.println("<TITLE>Result from MDX Query</TITLE>");
        wout.println("</HEAD>");
        wout.println("<BODY>");
        wout.println("<h1>MDX Query Result</h1>");
        if (mdx != null) {
            wout.println("<p>");
            wout.println(mdx);
            wout.println("</p>");
        }
        wout.println("<table border=\"3\">");
        wout.println("<thead><tr>");
        if (axes.length == 0) {
            wout.println("<th>Slicer</th><th>Result</th>");
            wout.println("</thead><tbody><tr>");
            ResultBase.renderSlicerRowHeader(result.getSlicer(), wout);
            Cell cell = (Cell)result.getCells().get(0);
            String value = cell.getFormattedValue();
            wout.println("<td>" + value + "</td>");
            wout.println("</tr>");
        } else if (axes.length == 1) {
            ResultBase.renderColHeaders(wout, axes[0]);
            wout.println("</tr></thead>");
            wout.println("<tbody><tr>");
            ResultBase.renderSlicerRowHeader(result.getSlicer(), wout);
            int n = 0;
            for (int i = 0; i < axes[0].getPositions().size(); ++i) {
                Cell cell = (Cell)result.getCells().get(n++);
                String value = cell.getFormattedValue();
                wout.println("<td>" + value + "</td>");
            }
            wout.println("</tr>");
        } else if (axes.length == 2) {
            ResultBase.renderColHeaders(wout, axes[0]);
            wout.println("</tr></thead>");
            wout.println("<tbody>");
            Position[] positions = axes[1].getPositions().toArray(new Position[0]);
            int n = 0;
            for (int i = 0; i < positions.length; ++i) {
                int j;
                wout.println("<tr>");
                Member[] members = positions[i].getMembers();
                String caption = "";
                for (j = 0; j < members.length; ++j) {
                    caption = j > 0 ? caption + "<br>" + members[j].getLabel() : members[j].getLabel();
                }
                wout.println("<th>" + caption + "</th>");
                for (j = 0; j < axes[0].getPositions().size(); ++j) {
                    Cell cell = (Cell)result.getCells().get(n++);
                    String value = cell.getFormattedValue();
                    wout.println("<td>" + value + "</td>");
                }
                wout.println("</tr>");
            }
        } else {
            throw new IllegalArgumentException("ResultBase.renderHtml cannot handle more than 2 axes");
        }
        wout.println("</tbody>");
        wout.println("</BODY></HTML>");
        wout.close();
    }

    private static void renderColHeaders(PrintWriter wout, Axis axis) {
        wout.println("<th></th>");
        Position[] positions = axis.getPositions().toArray(new Position[0]);
        for (int i = 0; i < positions.length; ++i) {
            Member[] members = positions[i].getMembers();
            String caption = "";
            for (int j = 0; j < members.length; ++j) {
                caption = j > 0 ? caption + "<br>" + members[j].getLabel() : members[j].getLabel();
            }
            wout.println("<th>" + caption + "</th>");
        }
    }

    private static void renderSlicerRowHeader(Axis slicerax, PrintWriter wout) {
        Position[] positions = slicerax.getPositions().toArray(new Position[0]);
        String caption = "";
        for (int i = 0; i < positions.length; ++i) {
            Member[] members = positions[i].getMembers();
            for (int j = 0; j < members.length; ++j) {
                caption = j == 0 && i == 0 ? members[j].getLabel() : caption + "<br>" + members[j].getLabel();
            }
        }
        wout.println("<th>" + caption + "</th>");
    }

    public void printOut(PrintStream ps) {
        Axis[] axes = this.getAxes();
        for (int i = 0; i < axes.length; ++i) {
            Axis a = axes[i];
            ps.println("Axis " + i);
            this.printAxis(ps, a);
        }
        Axis slicer = this.getSlicer();
        ps.println("Slicer Axis ");
        this.printAxis(ps, slicer);
        Iterator it = this.aCells.iterator();
        int ic = 0;
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            String val = c.getFormattedValue();
            ps.println("Cell " + ic++ + " Value=" + val);
        }
    }

    private void printAxis(PrintStream ps, Axis a) {
        List positions = a.getPositions();
        Iterator it = positions.iterator();
        int ip = 0;
        while (it.hasNext()) {
            Position p = (Position)it.next();
            ps.println("Position " + ip++);
            Member[] members = p.getMembers();
            for (int j = 0; j < members.length; ++j) {
                Member m = members[j];
                String mcap = m.getLabel();
                int idep = m.getRootDistance();
                ps.println("Member " + mcap + " depth=" + idep);
            }
        }
    }

    public boolean isOverflowOccured() {
        return this.overflow;
    }

    public void setOverflowOccured(boolean overflow) {
        this.overflow = overflow;
    }
}

