/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ModelFactory;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.tbutils.res.Resources;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class MondrianModelFactory {
    private static Logger logger = Logger.getLogger((Class)MondrianModelFactory.class);
    private static Resources resources = Resources.instance();

    private MondrianModelFactory() {
    }

    static String makeConnectString(Config cfg) {
        StringBuffer sb = new StringBuffer("provider=Mondrian");
        if (cfg.getJdbcUrl() != null) {
            String jdbcUrl = cfg.getJdbcUrl();
            sb.append(";Jdbc=");
            if (jdbcUrl.indexOf(59) >= 0) {
                char c = jdbcUrl.charAt(0);
                if (c != '\"' && c != '\'') {
                    char escape = '\"';
                    if (jdbcUrl.indexOf(34) >= 0) {
                        if (jdbcUrl.indexOf(39) >= 0) {
                            throw new IllegalArgumentException(resources.getString("jpivot.MondrianModelFactory.error.invalidJdbcUrl"));
                        }
                        escape = '\'';
                    }
                    sb.append(escape);
                    sb.append(jdbcUrl);
                    sb.append(escape);
                } else {
                    sb.append(jdbcUrl);
                }
            } else {
                sb.append(jdbcUrl);
            }
            if (cfg.getJdbcUser() != null) {
                sb.append(";JdbcUser=").append(cfg.getJdbcUser());
            }
            if (cfg.getJdbcPassword() != null && cfg.getJdbcPassword().length() > 0) {
                sb.append(";JdbcPassword=").append(cfg.getJdbcPassword());
            }
        } else if (cfg.getDataSource() != null) {
            sb.append(";DataSource=java:comp/env/").append(cfg.getDataSource());
            MondrianModelFactory.testDataSource(cfg.getDataSource());
        }
        sb.append(";Catalog=").append(cfg.getSchemaUrl());
        if (cfg.getDynLocale() != null) {
            sb.append(";Locale=").append(cfg.getDynLocale());
        }
        if (cfg.getRole() != null) {
            sb.append(";Role=").append(cfg.getRole());
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testDataSource(String dataSourceName) {
        Connection connection = null;
        String dsName = "java:comp/env/" + dataSourceName;
        try {
            DataSource dataSource = (DataSource)new InitialContext().lookup(dsName);
            connection = dataSource.getConnection();
            if (connection == null) return;
        }
        catch (Throwable e) {
            try {
                String msg = resources.getString("jpivot.MondrianModelFactory.error.datasourceNotConfigured", new Object[]{dsName});
                logger.error((Object)msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    logger.error((Object)resources.getString("jpivot.MondrianModelFactory.error.cannotCloseSqlConnection", new Object[]{dataSourceName}), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            connection.close();
            return;
        }
        catch (SQLException e) {
            logger.error((Object)resources.getString("jpivot.MondrianModelFactory.error.cannotCloseSqlConnection", new Object[]{dataSourceName}), (Throwable)e);
            return;
        }
    }

    public static MondrianModel instance() throws SAXException, IOException {
        URL url = MondrianModelFactory.class.getResource("config.xml");
        return (MondrianModel)ModelFactory.instance(url);
    }

    public static MondrianModel instance(Config cfg) throws SAXException, IOException {
        URL url = MondrianModelFactory.class.getResource("config.xml");
        return MondrianModelFactory.instance(url, cfg);
    }

    public static MondrianModel instance(URL url, Config cfg) throws SAXException, IOException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)cfg.toString());
            logger.info((Object)resources.getString("jpivot.MondrianModelFactory.message.connectionString", new Object[]{MondrianModelFactory.makeConnectString(cfg)}));
        }
        MondrianModel mm = (MondrianModel)ModelFactory.instance(url);
        mm.setMdxQuery(cfg.getMdxQuery());
        mm.setConnectString(MondrianModelFactory.makeConnectString(cfg));
        mm.setJdbcDriver(cfg.getJdbcDriver());
        mm.setDynresolver(cfg.getDynResolver());
        mm.setDynLocale(cfg.getDynLocale());
        if ("false".equalsIgnoreCase(cfg.getConnectionPooling())) {
            mm.setConnectionPooling(false);
        }
        mm.setExternalDataSource(cfg.getExternalDataSource());
        return mm;
    }

    public static class Config {
        String jdbcUrl;
        String jdbcDriver;
        String jdbcUser;
        String jdbcPassword;
        String dataSource;
        String schemaUrl;
        String mdxQuery;
        String role;
        String dynResolver;
        String dynLocale;
        String connectionPooling;
        DataSource externalDataSource = null;

        public String getJdbcDriver() {
            return this.jdbcDriver;
        }

        public String getJdbcPassword() {
            return this.jdbcPassword;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public String getJdbcUser() {
            return this.jdbcUser;
        }

        public String getMdxQuery() {
            return this.mdxQuery;
        }

        public String getSchemaUrl() {
            return this.schemaUrl;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setJdbcDriver(String jdbcDriver) {
            this.jdbcDriver = jdbcDriver;
        }

        public void setJdbcPassword(String jdbcPassword) {
            this.jdbcPassword = jdbcPassword;
        }

        public void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        public void setJdbcUser(String jdbcUser) {
            this.jdbcUser = jdbcUser;
        }

        public void setMdxQuery(String mdxQuery) {
            this.mdxQuery = mdxQuery;
        }

        public void setSchemaUrl(String schemaUrl) {
            this.schemaUrl = schemaUrl;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(String string) {
            this.dataSource = string;
        }

        public String getDynResolver() {
            return this.dynResolver;
        }

        public void setDynResolver(String dynResolver) {
            this.dynResolver = dynResolver;
        }

        public String getConnectionPooling() {
            return this.connectionPooling;
        }

        public void setConnectionPooling(String connectionPooling) {
            this.connectionPooling = connectionPooling;
        }

        public DataSource getExternalDataSource() {
            return this.externalDataSource;
        }

        public void setExternalDataSource(DataSource externalDataSource) {
            this.externalDataSource = externalDataSource;
        }

        public String getDynLocale() {
            return this.dynLocale;
        }

        public void setDynLocale(String dynLocale) {
            this.dynLocale = dynLocale;
        }

        public String toString() {
            return "Config[jdbcUrl=" + this.jdbcUrl + ", jdbcDriver=" + this.jdbcDriver + ", jdbcUser=" + this.jdbcUser + ", jdbcPassword=" + this.jdbcPassword + ", dataSource=" + this.dataSource + ", schemaUrl=" + this.schemaUrl + ", mdxQuery=" + this.mdxQuery + ", role=" + this.role + ", dynResolver=" + this.dynResolver + ", connectionPooling=" + this.connectionPooling + ", externalDataSource=" + this.externalDataSource + ", dynLocale=" + this.dynLocale + "]";
        }
    }
}

